package com.baijiayun.openapi.sdk.dto.newsub;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class GetPartnerBillListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] sub_partner_id 子账号partner_id
     */
    @JsonProperty("sub_partner_id")
    private String subPartnerId;

    /**
     * 默认全部，查询月份2022-06
     */
    private String month;

    /**
     * 默认0全部，1大班课，2小班课，4企业直播，5云点播，11短信服务，12百家云校，13美颜服务，14虚拟背景服务，16BRTC，17外呼服务
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * 默认0全部，1AVSDK，2混合WEBRTC，3纯WEBRTC，4小班课，5专业小班课1v1，6普通小班课1v1
     */
    @JsonProperty("room_type")
    private Integer roomType;

    /**
     * 页码，默认第一页
     */
    private String page;

    /**
     * 每页条数，默认10条
     */
    @JsonProperty("page_size")
    private String pageSize;
}