package com.baijiayun.openapi.sdk.dto.mixedplayback;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 按照名称搜索的关键字
     */
    private String keyword;

    /**
     * 创建时间查询范围 格式如 2024-05-17 09:51:56，start_time 和 end_time 必须同时设置才能生效
     */
    @JsonProperty("start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * 创建时间查询范围 格式如 2024-05-17 09:51:56，start_time 和 end_time 必须同时设置才能生效
     */
    @JsonProperty("end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 当前查询页 默认 1
     */
    private Integer page;

    /**
     * 每页数量 默认 10
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}