package com.baijiayun.openapi.sdk.dto.livesetting;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import lombok.Data;

@Data
public class GetSensitiveWordReq implements Serializable {
    private static final long serialVersionUID = -1L;

    private Integer page;

    @JsonProperty("page_size")
    private Integer pageSize;

    /**
     * 1:大班课，2，小班课，3：双师，4，企业直播（单一产品线账号不需要传此参数）
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * 教室级别敏感词，传此参数则设置为教室级别敏感词，默认不传为账号产品线级别敏感词
     */
    @JsonProperty("room_id")
    private String roomId;

    private String query;
}