package com.baijiayun.openapi.sdk.dto.livesetting;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import lombok.Data;

@Data
public class GetQuizListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 分页参数 默认值1
     */
    private Integer page;

    /**
     * 分页参数 默认值20
     */
    @JsonProperty("page_size")
    private Integer pageSize;

    /**
     * 关键字查询
     */
    private String query;

    /**
     * 1:大班课，2，小班课，3：双师，4，企业直播（单一产品线账号不需要传此参数）
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;
}