package com.baijiayun.openapi.sdk.dto.liveaccount;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetAttentionListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 教室ID
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] date YYYY-MM-DD格式，如：2020-11-01
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date;

    /**
     * 分页参数
     */
    private Integer page;

    /**
     * 每页返回条数
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}