package com.baijiayun.openapi.sdk.dto.live;

import com.baijiayun.openapi.sdk.utils.UnixTimestampSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2024/7/2
 */
@Data
public class SendChatMessageDto implements Serializable {
    @JsonProperty("message_type")
    private String messageType = "message_send";// 消息类型：固定
    private String content;// 消息内容
    private Integer to = -1;// 消息群发，-1 固定
    private SendChatMessageFrom from;
    private SendChatMessageData data;// 图片类型data字段必填，非图片类型不需要data字段
    private String uid;// 同 from 中的user_id
    @JsonProperty("agent_id")
    private Integer agentId = 0;// 传 0
    @JsonSerialize(using = UnixTimestampSerializer.class)
    private Date time;// 教室内发消息的时间
    @JsonProperty("is_mock")
    private Boolean isMock = true;// is_mock = true 表示虚拟消息
    @JsonProperty("no_chat_check")
    private Integer noChatCheck;// 是否跳过消息审核
    @JsonProperty("class_id")
    private String classId;// 教室ID
    private Integer group = 0;// 传0
}
