package com.baijiayun.openapi.sdk.dto.live;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class SendBroadcastReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 教室ID
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] key 信令的名称
     */
    private String key;

    /**
     * [必填] value 信令的具体内容
     */
    private String value;

    /**
     * [必填] is_all 1:发送给所有人 0:发送给老师和助教
     */
    @JsonProperty("is_all")
    private Integer isAll;

    /**
     * [必填] use_cache 是否在教室内缓存，设置为1，后进教室的用户可以获取到此信令，1:在教室内缓存 0:不缓存
     */
    @JsonProperty("use_cache")
    private Integer useCache;
}