package com.baijiayun.openapi.sdk.dto.fluency;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetNetworkDataReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 0:大班课,1:小班课,2:企业直播; 默认不填为小班课
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * 搜索开始时间 '2020-04-01 00:00:00'
     */
    @JsonProperty("start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * 搜索结束时间 '2020-04-01 23:59:59'
     */
    @JsonProperty("end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 页码
     */
    private Integer page;

    /**
     * 每页大小
     */
    @JsonProperty("page_size")
    private Integer pageSize;

    /**
     * 房间号
     */
    @JsonProperty("room_id")
    private String roomId;
}