package com.baijiayun.openapi.sdk.dto.doubleteacher;

import com.baijiayun.openapi.sdk.utils.UnixTimestampSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class CreateRecordCourseReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] title 标题
     */
    private String title;

    /**
     * [必填] start_time 开始时间(unix时间戳)
     */
    @JsonProperty("start_time")
    @JsonSerialize(using = UnixTimestampSerializer.class)
    private Date startTime;

    /**
     * [必填] end_time 结束时间(unix时间戳)
     */
    @JsonProperty("end_time")
    @JsonSerialize(using = UnixTimestampSerializer.class)
    private Date endTime;
}