package com.baijiayun.openapi.sdk.dto.doubleteacher;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class AddScheduleReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 直播教室号
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] serial_number 课节编号，同一课程同一天的课节编号不可重复，更新排课信息时需要此编号
     */
    @JsonProperty("serial_number")
    private String serialNumber;

    /**
     * [必填] date 日期，格式如：2018-01-03
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date;

    /**
     * [必填] title 课节标题
     */
    private String title;

    /**
     * [必填] start_time 开始时间
     */
    @JsonProperty("start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * [必填] end_time 结束时间
     */
    @JsonProperty("end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 主讲老师姓名（非必填）
     */
    @JsonProperty("teacher_name")
    private String teacherName;
}