package com.baijiayun.openapi.sdk.dto.doubleteacher;

import com.baijiayun.openapi.sdk.utils.UnixTimestampSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class AddCourseVideoReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] video_unique 视频唯一标识
     */
    @JsonProperty("video_unique")
    private String videoUnique;

    /**
     * [必填] play_start_time 开始时间(unix时间戳)
     */
    @JsonProperty("play_start_time")
    @JsonSerialize(using = UnixTimestampSerializer.class)
    private Date playStartTime;

    /**
     * [必填] play_end_time 结束时间(unix时间戳)
     */
    @JsonProperty("play_end_time")
    @JsonSerialize(using = UnixTimestampSerializer.class)
    private Date playEndTime;
}