package com.baijiayun.openapi.sdk.dto.doc;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.File;
import java.io.Serializable;

@Data
public class UploadDocReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 教室号，如果传了教室号则文档自动绑定到该教室，不传则不绑定
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 是否使用动效PPT，只针对PPT有效
     */
    @JsonProperty("ppt_animation")
    private Integer pptAnimation;

    /**
     * [必填] attachment 要上传的文件（文件不参数签名的计算）
     */
    private File attachment;

    /**
     * 上级文件目录id 0或者不传：分类到其他文件目录
     */
    @JsonProperty("parent_finder_id")
    private Long parentFinderId;
}