package com.baijiayun.openapi.sdk.dto.classgoods;

import com.baijiayun.openapi.sdk.utils.DoublePrecisionSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;

@Data
public class EditGoodsReq implements Serializable {

    /**
     * 直播间room_id
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 百家云那边的商品id
     */
    @JsonProperty("goods_id")
    private Long goodsId;

    /**
     * 商品名称
     */
    @JsonProperty("goods_name")
    private String goodsName;

    /**
     * 商品图片地址，多个用"，"分割
     */
    @JsonProperty("goods_img")
    private String goodsImg;

    /**
     * 商品原价，保留两位小数
     */
    @JsonSerialize(using = DoublePrecisionSerializer.class)
    private Double price;

    /**
     * 折扣价格，保留两位小数
     */
    @JsonProperty("discount_price")
    @JsonSerialize(using = DoublePrecisionSerializer.class)
    private Double discountPrice;

    /**
     * 商品描述
     */
    private String desc;

    /**
     * 跳转链接
     */
    private String url;

    /**
     * 图片素材id
     */
    @JsonProperty("media_id")
    private Long mediaId;

    /**
     * 产品线类型，1: 大班课
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * 商品页面打开方式 0:当前页打开 1:新页面打开
     * @see com.baijiayun.openapi.sdk.enums.BjyGoodsOpenType
     */
    @JsonProperty("open_type")
    private Integer openType;

    /**
     * is_discount_price_hide
     * 折扣价格是否隐藏
     * 当折扣价格为null时 字段可以传1
     */
    @JsonProperty("is_discount_price_hide")
    private Integer isDiscountPriceHide;
}

