package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.CallbackUrlResp;
import com.baijiayun.openapi.sdk.dto.videoaccount.*;

/**
 * Auto generate interface of VideoAccountApi.
 */
@BjyClient
public interface VideoAccountApi {

    /**
     * API-20: 获取账号套餐使用量
     * @param partnerInfo 百家云合作者参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_20_VIDEO_ACCOUNT_GET_ACCOUNT_INFO)
    BjyResult<Void> getAccountInfo(BjyPartnerInfo partnerInfo);

    /**
     * API-22: 查询账号一段时间内使用的流量
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_22_VIDEO_ACCOUNT_GET_USED_FLOW)
    BjyResult<Void> getUsedFlow(BjyPartnerInfo partnerInfo, GetUsedFlowReq req);

    /**
     * API-37: 查询账号内一段时间内的流量并返回流量消耗明细
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_37_VIDEO_ACCOUNT_GET_USED_FLOW_DETAIL)
    BjyResult<Void> getUsedFlowDetail(BjyPartnerInfo partnerInfo, GetUsedFlowDetailReq req);

    /**
     * API-39: 获取账号存储空间和流量使用统计
     * @param partnerInfo 百家云合作者参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_39_VIDEO_ACCOUNT_GET_STORGE_AND_FLOW_INFO)
    BjyResult<Void> getStorageAndFlowInfo(BjyPartnerInfo partnerInfo);

    /**
     * 设置转码回调地址
     * @param partnerInfo 百家云合作者参数
     * @param url [必填] 回调地址，必须是http(s)://开头
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_VIDEO_ACCOUNT_SET_TRANSCODE_CALLBACK_URL)
    BjyResult<CallbackUrlResp> setTranscodeCallbackUrl(BjyPartnerInfo partnerInfo, String url);

    /**
     * 获取转码回调地址
     * @param partnerInfo 百家云合作者参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_X_VIDEO_ACCOUNT_GET_TRANSCODE_CALLBACK_URL)
    BjyResult<CallbackUrlResp> getTranscodeCallbackUrl(BjyPartnerInfo partnerInfo);
}