package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.PageSizeReq;
import com.baijiayun.openapi.sdk.dto.RoomPageReq;
import com.baijiayun.openapi.sdk.dto.TotalListResp;
import com.baijiayun.openapi.sdk.dto.user.*;

import java.util.List;

/**
 * Auto generate interface of UserApi.
 */
@BjyClient
public interface UserApi {

    /**
     * API 1 : 添加用户
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_USER_ADD_USER)
    BjyResult<Void> addUser(BjyPartnerInfo partnerInfo, AddUserReq req);

    /**
     * API 2 : 获取用户列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_2_USER_GET_USER_LIST)
    BjyResult<Void> getUserList(BjyPartnerInfo partnerInfo, GetUserListReq req);

    /**
     * API 3 : 批量删除用户
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_3_USER_BATCH_REMOVE_USER)
    BjyResult<Void> batchRemoveUser(BjyPartnerInfo partnerInfo, BatchRemoveUserReq req);

    /**
     * API 4 : 给教室批量关联学员
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_4_USER_CLASS_BIND_STUDENT_BATCH)
    BjyResult<Void> classBindStudentBatch(BjyPartnerInfo partnerInfo, ClassBindStudentBatchReq req);

    /**
     * API 5 : 给教室关联老师/助教
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_5_USER_CLASS_BIND_TEACHER)
    BjyResult<Void> classBindTeacher(BjyPartnerInfo partnerInfo, ClassBindTeacherReq req);

    /**
     * API 6 : 获取教室关联的学员列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_USER_GET_CLASS_STUDENT)
    BjyResult<TotalListResp<ClassStudentUserDto>> getClassStudent(BjyPartnerInfo partnerInfo, RoomPageReq req);

    /**
     * API 7 : 获取教室关联的老师和助教
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_7_USER_GET_CLASS_TEACHER)
    BjyResult<Void> getClassTeacher(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 8 : 批量移除教室内关联的学员
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_8_USER_CLASS_REMOVE_STUDENT_BATCH)
    BjyResult<Void> classRemoveStudentBatch(BjyPartnerInfo partnerInfo, ClassRemoveStudentBatchReq req);

    /**
     * API 9 : 移除教室内关联的老师/助教
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_9_USER_CLASS_REMOVE_TEACHER)
    BjyResult<Void> classRemoveTeacher(BjyPartnerInfo partnerInfo, ClassRemoveTeacherReq req);

    /**
     * API 10 : 通过手机号获取用户
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_10_USER_GET_USER_BY_PHONE_NUMBER)
    BjyResult<Void> getUserByPhoneNumber(BjyPartnerInfo partnerInfo, GetUserByPhoneNumberReq req);

    /**
     * API 11 : 修改用户信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_11_USER_EDIT_USER)
    BjyResult<Void> editUser(BjyPartnerInfo partnerInfo, EditUserReq req);

    /**
     * API 12 : 修改教室内关联助教水军角色为普通助教
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_12_USER_CLASS_RELATION_FAKE_ASSISTANT)
    BjyResult<Void> classRelationFakeAssistant(BjyPartnerInfo partnerInfo, ClassRelationFakeAssistantReq req);

    /**
     * API 13 : 班级列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_13_USER_LIST_GROUP)
    BjyResult<Void> listGroup(BjyPartnerInfo partnerInfo, PageSizeReq req);

    /**
     * API 23: 单个回放白名单增加学员
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_23_USER_PLAYBACK_BIND_STUDENT_BATCH)
    BjyResult<Void> playbackBindStudentBatch(BjyPartnerInfo partnerInfo, PlaybackBindStudentBatchReq req);

    /**
     * API 24: 单个回放删除白名单学员
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_24_USER_PLAYBACK_REMOVE_STUDENT_BATCH)
    BjyResult<Void> playbackRemoveStudentBatch(BjyPartnerInfo partnerInfo, PlaybackRemoveStudentBatchReq req);

    /**
     * API 25: 查询单个回放绑定白名单
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_25_USER_GET_PLAYBACK_STUDENT)
    BjyResult<Void> getPlaybackStudent(BjyPartnerInfo partnerInfo, GetPlaybackStudentReq req);

    /**
     * API 26: 增加房间级别回放白名单学员
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_26_USER_ROOM_PLAYBACK_BIND_STUDENT_BATCH)
    BjyResult<Void> roomPlaybackBindStudentBatch(BjyPartnerInfo partnerInfo, RoomPlaybackBindStudentBatchReq req);

    /**
     * API 27: 查询房间回放白名单学员
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_27_USER_GET_ROOM_PLAYBACK_STUDENT)
    BjyResult<Void> getRoomPlaybackStudent(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 28: 删除房间回放白名单学员
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_28_USER_ROOM_PLAYBACK_REMOVE_STUDENT_BATCH)
    BjyResult<Void> roomPlaybackRemoveStudentBatch(BjyPartnerInfo partnerInfo, RoomPlaybackRemoveStudentBatchReq req);

    /**
     * API 4 : 给教室批量关联学员
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_4_USER_CLASS_BIND_STUDENT_BATCH_ARRAY)
    BjyResult<Void> classBindStudentBatchArray(BjyPartnerInfo partnerInfo, ClassBindStudentBatchArrayReq req);

    /**
     * 批量创建用户
     * @param partnerInfo 百家云合作者参数
     * @param userJson [必填] user_json 用户列表(json_encode数据) 如[{"user_sn":"hw4jd12","name":"ly","phone_number":"13500000100","password":"123456"},{"user_sn":"hw4j34","name":"ly","phone_number":"13500000101","password":"123456"}]
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_USER_BATCH_ADD_STUDENT_USER)
    BjyResult<BatchAddStudentUserResp> batchAddStudentUser(BjyPartnerInfo partnerInfo, @RequestParam("user_json") List<BatchAddStudentUserDto> userJson);

    /**
     * 查询班级下的学员列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_USER_GET_GROUP_USER_LIST)
    BjyResult<Void> getGroupUserList(BjyPartnerInfo partnerInfo, GetGroupUserListReq req);

    /**
     * 获取管理员所属的教室列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_USER_GET_BELONG_ROOM_LIST)
    BjyResult<Void> getBelongRoomList(BjyPartnerInfo partnerInfo, GetBelongRoomListReq req);

    /**
     * 获取管理员所属的点播列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_USER_GET_BELONG_VIDEO_LIST)
    BjyResult<Void> getBelongVideoList(BjyPartnerInfo partnerInfo, GetBelongVideoListReq req);
}