package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.student.*;

/**
 * Auto generate interface of StudentApi.
 */
@BjyClient
public interface StudentApi {

    /**
     * 双师添加一个学生
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_STUDENT_CREATE)
    BjyResult<Void> create(BjyPartnerInfo partnerInfo, CreateReq req);

    /**
     * 双师批量增加学生
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_STUDENT_CREATE_BATCH)
    BjyResult<Void> createBatch(BjyPartnerInfo partnerInfo, CreateBatchReq req);

    /**
     * 双师修改学生信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_STUDENT_UPDATE)
    BjyResult<Void> update(BjyPartnerInfo partnerInfo, UpdateReq req);

    /**
     * 双师删除学生
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_STUDENT_DELETE)
    BjyResult<Void> delete(BjyPartnerInfo partnerInfo, DeleteReq req);

    /**
     * 批量删除学生
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_STUDENT_DELETE_BATCH)
    BjyResult<Void> deleteBatch(BjyPartnerInfo partnerInfo, DeleteBatchReq req);

    /**
     * 展示班级内有效学生信息
     * @param partnerInfo 百家云合作者参数
     * @param classId [必填] class_id 第三方班级 id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_STUDENT_LIST)
    BjyResult<Void> list(BjyPartnerInfo partnerInfo, @RequestParam("class_id") Integer classId);
}