package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.roomscore.*;

/**
 * Auto generate interface of RoomScoreApi.
 */
@BjyClient
public interface RoomScoreApi {

    /**
     * API 111 : 获取教室个人积分记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_111_ROOM_SCORE_GET_USER_SCORE_LIST)
    BjyResult<Void> getUserScoreList(BjyPartnerInfo partnerInfo, GetUserScoreListReq req);

    /**
     * 积分设置
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_SCORE_SET_CONFIG)
    BjyResult<Void> setConfig(BjyPartnerInfo partnerInfo, SetConfigReq req);

    /**
     * 积分查询
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_SCORE_GET_CONFIG_LIST)
    BjyResult<Void> getConfigList(BjyPartnerInfo partnerInfo, GetConfigListReq req);
}