package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.PageSizeReq;
import com.baijiayun.openapi.sdk.dto.RoomPageReq;
import com.baijiayun.openapi.sdk.dto.TotalListResp;
import com.baijiayun.openapi.sdk.dto.roomdata.*;

import java.util.List;

/**
 * Auto generate interface of RoomDataApi.
 */
@BjyClient
public interface RoomDataApi {

    /**
     * API 18 : 导出教室聊天记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_18_ROOM_DATA_EXPORT_CHAT_MSG)
    BjyResult<ExportChatMsgResp> exportChatMsg(BjyPartnerInfo partnerInfo, ExportChatMsgReq req);

    /**
     * API 20 : 导出直播教室学员观看记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_20_ROOM_DATA_EXPORT_LIVE_REPORT)
    BjyResult<ExportLiveReportResp> exportLiveReport(BjyPartnerInfo partnerInfo, ExportLiveReportReq req);

    /**
     * API 21 : 获取指定日期所有的直播间人次和最高并发量
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_21_ROOM_DATA_GET_ALL_ROOM_USER_STAT)
    BjyResult<Void> getAllRoomUserStat(BjyPartnerInfo partnerInfo, GetAllRoomUserStatReq req);

    /**
     * API 22 : 获取指定房间一段时间内的并发量
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_22_ROOM_DATA_GET_ROOM_PEAK_USER)
    BjyResult<Void> getRoomPeakUser(BjyPartnerInfo partnerInfo, GetRoomPeakUserReq req);

    /**
     * API 25 : 获取教室聊天文件地址
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室ID
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_25_ROOM_DATA_GET_CHAT_MSG_URL)
    BjyResult<List<GetChatMsgUrlResp>> getChatMsgUrl(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 28: 获取教室测试试题信息
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_28_ROOM_DATA_GET_ROOM_QUIZ)
    BjyResult<Void> getRoomQuiz(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 29 : 获取直播回放测验题目的学员答案信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_29_ROOM_DATA_GET_QUIZ_USER_ANSWER)
    BjyResult<Void> getQuizUserAnswer(BjyPartnerInfo partnerInfo, GetQuizUserAnswerReq req);

    /**
     * API 30: 获取教室学员签到信息
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_30_ROOM_DATA_GET_USER_CHECKIN_INFO)
    BjyResult<Void> getUserCheckinInfo(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 34 : 获取教室举手连麦数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_34_ROOM_DATA_GET_ROOM_RAISE_DATA)
    BjyResult<Void> getRoomRaiseData(BjyPartnerInfo partnerInfo, GetRoomRaiseDataReq req);

    /**
     * API 38 : 第三方教室中学生抢红包统计
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_38_ROOM_DATA_GET_ROOM_RED_PACKAGE)
    BjyResult<Void> getRoomRedPackage(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 39 : 获取教室抽奖数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_39_ROOM_DATA_EXPORT_AWARD_STAT)
    BjyResult<TotalListResp<ExportAwardStatDto>> exportAwardStat(BjyPartnerInfo partnerInfo, ExportAwardStatReq req);

    /**
     * API 40 : 获取教室问答数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_40_ROOM_DATA_EXPORT_QA_STAT)
    BjyResult<Void> exportQaStat(BjyPartnerInfo partnerInfo, ExportQaStatReq req);

    /**
     * API 41 : 获取教室邀请函数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_41_ROOM_DATA_EXPORT_QUESTIONNAIRE_STAT)
    BjyResult<Void> exportQuestionnaireStat(BjyPartnerInfo partnerInfo, ExportQuestionnaireStatReq req);

    /**
     * API 42 : 获取教室答题器数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_42_ROOM_DATA_EXPORT_ANSWER_STAT)
    BjyResult<Void> exportAnswerStat(BjyPartnerInfo partnerInfo, ExportAnswerStatReq req);

    /**
     * API 48 : 直播教室的点赞数据
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_48_ROOM_DATA_EXPORT_ROOM_PRAISE_STAT)
    BjyResult<Void> exportRoomPraiseStat(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 49 : 获取教室课后评价数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_49_ROOM_DATA_GET_EVALUATION_STAT)
    BjyResult<Void> getEvaluationStat(BjyPartnerInfo partnerInfo, GetEvaluationStatReq req);

    /**
     * API 54 : 获取直播带货点赞或礼物数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_54_ROOM_DATA_GET_LIVE_SELL_DATA)
    BjyResult<Void> getLiveSellData(BjyPartnerInfo partnerInfo, GetLiveSellDataReq req);

    /**
     * API 66 : 获取参加码使用记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_66_ROOM_DATA_GET_CODE_USAGE_BATCH)
    BjyResult<Void> getCodeUsageBatch(BjyPartnerInfo partnerInfo, GetCodeUsageBatchReq req);

    /**
     * API 71 : 根据日期获取教室等效分钟数
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_71_ROOM_DATA_GET_MEDIA_LENGTH_BY_DATE)
    BjyResult<Void> getMediaLengthByDate(BjyPartnerInfo partnerInfo, GetMediaLengthByDateReq req);

    /**
     * API 72 : 获取大班课奖励数据
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 房间号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_72_ROOM_DATA_GET_AWARD_DATA)
    BjyResult<Void> getAwardData(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 104 : 获取直播间点赞热度数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_104_ROOM_DATA_GET_ROOM_DATE_NEW_PRAISE_COUNT)
    BjyResult<Void> getRoomDateNewPraiseCount(BjyPartnerInfo partnerInfo, GetRoomDateNewPraiseCountReq req);

    /**
     * API 105 : 获取直播间数据报表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_105_ROOM_DATA_GET_LIVE_DATA_REPORT)
    BjyResult<Void> getLiveDataReport(BjyPartnerInfo partnerInfo, GetLiveDataReportReq req);

    /**
     * API 112 : 获取教室学员签到次数列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_112_ROOM_DATA_GET_CHECKIN_SESSION_LIST)
    BjyResult<Void> getCheckinSessionList(BjyPartnerInfo partnerInfo, RoomPageReq req);

    /**
     * API 113 : 获取教室学员单次签到列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_113_ROOM_DATA_GET_CHECKIN_SESSION_USER_LIST)
    BjyResult<Void> getCheckinSessionUserList(BjyPartnerInfo partnerInfo, GetCheckinSessionUserListReq req);

    /**
     * API 114 : 获取教室答题器题目列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_114_ROOM_DATA_GET_ROOM_QUESTION_LIST)
    BjyResult<Void> getRoomQuestionList(BjyPartnerInfo partnerInfo, RoomPageReq req);

    /**
     * API 115: 获取教室学员单次答题器答案列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_115_ROOM_DATA_GET_ROOM_QUESTION_ANSWER_LIST)
    BjyResult<Void> getRoomQuestionAnswerList(BjyPartnerInfo partnerInfo, GetRoomQuestionAnswerListReq req);

    /**
     * AIP 33 : 获取表情报告截取的表情图片
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_DATA_GET_EXP_REPORT_LIST)
    BjyResult<Void> getExpReportList(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 36 : 获取教室设备自检的信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_36_ROOM_DATA_GET_USER_DEVICE_INFO)
    BjyResult<Void> getUserDeviceInfo(BjyPartnerInfo partnerInfo, RoomPageReq req);

    /**
     * API 37 : 按天获取课后评价数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_37_ROOM_DATA_GET_EVALUATION_LIST)
    BjyResult<Void> getEvaluationList(BjyPartnerInfo partnerInfo, GetEvaluationListReq req);

    /**
     * API 40 : 监课接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_40_ROOM_DATA_GET_MONITOR_DATA)
    BjyResult<Void> getMonitorData(BjyPartnerInfo partnerInfo, PageSizeReq req);

    /**
     * API 44 : 获取小班课学情报告数据
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 房间id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_44_ROOM_DATA_GET_STUDY_REPORT)
    BjyResult<Void> getStudyReport(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 57 : 获取小班课黑板保存数据
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 直播间id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_57_ROOM_DATA_GET_DOWNLOAD_BLACKBOARD_IMG)
    BjyResult<Void> getDownloadBlackboardImg(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * 获取教室专注度检测详情
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_DATA_EXPORT_ATTENTION_DETAIL)
    BjyResult<Void> exportAttentionDetail(BjyPartnerInfo partnerInfo, ExportAttentionDetailReq req);

    /**
     * API 59 : 获取教室一次点名的信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_59_ROOM_DATA_GET_CHECKIN_INFO)
    BjyResult<Void> getCheckinInfo(BjyPartnerInfo partnerInfo, GetCheckinInfoReq req);

    /**
     * API 58 : 获取教室点名列表
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_58_ROOM_DATA_GET_CHECKIN_LIST)
    BjyResult<Void> getCheckinList(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * 获取直播间试卷列表
     * @param partnerInfo 百家云合作者参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_DATA_GET_QUIZ_LIST)
    BjyResult<Void> getQuizList(BjyPartnerInfo partnerInfo);

    /**
     * 获取试卷的答案列表
     * @param partnerInfo 百家云合作者参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_DATA_GET_ANSWER_LIST)
    BjyResult<Void> getAnswerList(BjyPartnerInfo partnerInfo);

    /**
     * API 20 : 小班课教室进出明细
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_20_ROOM_DATA_GET_ENTER_OR_OUT_CLASS_DETAIL)
    BjyResult<Void> getEnterOrOutClassDetail(BjyPartnerInfo partnerInfo, GetEnterOrOutClassDetailReq req);

    /**
     * API 6 : 新东方定制 - 查看指定id答题器数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_ROOM_DATA_GET_QUESTION_ANSWER)
    BjyResult<Void> getQuestionAnswer(BjyPartnerInfo partnerInfo, GetQuestionAnswerReq req);

    /**
     * API 1:获取用户进出记录下载地址
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_ROOM_DATA_GET_USER_EVENT_DOWNLOAD_URL)
    BjyResult<Void> getUserEventDownloadUrl(BjyPartnerInfo partnerInfo, GetUserEventDownloadUrlReq req);

    /**
     * API:批量获取用户进出记录下载地址
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_ROOM_DATA_GET_USER_EVENT_DOWNLOAD_URL_BATCH)
    BjyResult<Void> getUserEventDownloadUrlBatch(BjyPartnerInfo partnerInfo, GetUserEventDownloadUrlBatchReq req);

    /**
     * API 70: 获取单次答题器记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_70_ROOM_DATA_EXPORT_ANSWER_BY_QUESTION_ID)
    BjyResult<Void> exportAnswerByQuestionId(BjyPartnerInfo partnerInfo, ExportAnswerByQuestionIdReq req);

    /**
     * API 71: 获取单次红包记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_71_ROOM_DATA_GET_RED_PACKAGE_RECORD_INFO)
    BjyResult<Void> getRedPackageRecordInfo(BjyPartnerInfo partnerInfo, GetRedPackageRecordInfoReq req);

    /**
     * 获取互动次数
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_DATA_GET_ROOM_INTERACT_DATA)
    BjyResult<Void> getRoomInteractData(BjyPartnerInfo partnerInfo, GetRoomInteractDataReq req);

    /**
     * 获取直播间举手、互动数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_DATA_EXPORT_DEVICE_INTERACT_STAT)
    BjyResult<Void> exportDeviceInteractStat(BjyPartnerInfo partnerInfo, ExportDeviceInteractStatReq req);

    /**
     * API 2 : 获取等效分钟数
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_2_ROOM_DATA_GET_MEDIA_LENGTH)
    BjyResult<Void> getMediaLength(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 1 : 获取过滤的聊天内容
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_ROOM_DATA_GET_FILTERED_CHAT_MSG)
    BjyResult<Void> getFilteredChatMsg(BjyPartnerInfo partnerInfo, GetFilteredChatMsgReq req);

    /**
     * API 105:获取直播间多平台推流配置开启状态
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_105_ROOM_DATA_GET_MULTI_PLATFORM_STREAMING_STATUS)
    BjyResult<Void> getMultiPlatformStreamingStatus(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 106:保存直播间多平台推流配置开启状态
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_106_ROOM_DATA_SAVE_MULTI_PLATFORM_STREAMING_STATUS)
    BjyResult<Void> saveMultiPlatformStreamingStatus(BjyPartnerInfo partnerInfo, SaveMultiPlatformStreamingStatusReq req);

    /**
     * API 107:获取直播间多平台推流配置信息列表
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_107_ROOM_DATA_GET_MULTI_PLATFORM_STREAMING_LIST)
    BjyResult<Void> getMultiPlatformStreamingList(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 108:新增直播间多平台推流配置信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_108_ROOM_DATA_ADD_MULTI_PLATFORM_STREAMING)
    BjyResult<Void> addMultiPlatformStreaming(BjyPartnerInfo partnerInfo, AddMultiPlatformStreamingReq req);

    /**
     * API 109:编辑直播间多平台推流配置信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_109_ROOM_DATA_EDIT_MULTI_PLATFORM_STREAMING)
    BjyResult<Void> editMultiPlatformStreaming(BjyPartnerInfo partnerInfo, EditMultiPlatformStreamingReq req);

    /**
     * API 110:删除直播间多平台推流配置信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_110_ROOM_DATA_DELETE_MULTI_PLATFORM_STREAMING)
    BjyResult<Void> deleteMultiPlatformStreaming(BjyPartnerInfo partnerInfo, DeleteMultiPlatformStreamingReq req);

    /**
     * 导出教室专注度检测列表
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_DATA_EXPORT_ATTENTION_LIST)
    BjyResult<Void> exportAttentionList(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);
}