package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.CountResp;
import com.baijiayun.openapi.sdk.dto.RoomPageReq;
import com.baijiayun.openapi.sdk.dto.TotalListResp;
import com.baijiayun.openapi.sdk.dto.room.*;

/**
 * Auto generate interface of RoomApi.
 */
@BjyClient
public interface RoomApi {

    /**
     * API 2 : 创建房间
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_2_ROOM_CREATE)
    BjyResult<CreateResp> create(BjyPartnerInfo partnerInfo, CreateReq req);

    /**
     * API 3 : 更新房间信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_3_ROOM_UPDATE)
    BjyResult<Void> update(BjyPartnerInfo partnerInfo, UpdateReq req);

    /**
     * API 4 : 删除房间
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 房间id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_4_ROOM_DELETE)
    BjyResult<Void> delete(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 5 : 获取房间信息
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 房间id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_5_ROOM_INFO)
    BjyResult<InfoResp> info(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 6 : 生成用户参加码
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_ROOM_GET_CODE)
    BjyResult<GetCodeResp> getCode(BjyPartnerInfo partnerInfo, GetCodeReq req);

    /**
     * API 7 : 获取用户参加码信息
     * @param partnerInfo 百家云合作者参数
     * @param code [必填] code 学生参加码
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_7_ROOM_GET_CODE_INFO)
    BjyResult<Void> getCodeInfo(BjyPartnerInfo partnerInfo, String code);

    /**
     * API 8 : 获取已生成的参加码列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_8_ROOM_LIST_CODE)
    BjyResult<Void> listCode(BjyPartnerInfo partnerInfo, ListCodeReq req);

    /**
     * API 9 : 获取房间列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_9_ROOM_LIST)
    BjyResult<ListResp> list(BjyPartnerInfo partnerInfo, ListReq req);

    /**
     * API 31 : 创建分组直播参加码
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_31_ROOM_CREATE_GROUP_LIVE_CODES)
    BjyResult<Void> createGroupLiveCodes(BjyPartnerInfo partnerInfo, CreateGroupLiveCodesReq req);

    /**
     * API 32 : 获取分组直播参加码
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_32_ROOM_GET_GROUP_LIVE_CODES)
    BjyResult<Void> getGroupLiveCodes(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 33 : 获取推流直播的推流地址
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_33_ROOM_GET_PUSH_LIVE_URL)
    BjyResult<GetPushLiveUrlResp> getPushLiveUrl(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 36 : 获取支持大小班的分组直播小班教室room_id
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_36_ROOM_GET_GROUP_SUB_ROOM_ID)
    BjyResult<Void> getGroupSubRoomId(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 37: 获取推流直播的拉流地址
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 房间ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_37_ROOM_GET_PULL_STREAM_URL)
    BjyResult<GetPullStreamUrlResp> getPullStreamUrl(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 43 : 生成用户试听参加码
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_43_ROOM_GET_AUDITION_CODE)
    BjyResult<Void> getAuditionCode(BjyPartnerInfo partnerInfo, GetAuditionCodeReq req);

    /**
     * API 46 : 直播设置插播回放
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_46_ROOM_SET_SPOT_VIDEO)
    BjyResult<Void> setSpotVideo(BjyPartnerInfo partnerInfo, SetSpotVideoReq req);

    /**
     * API 47 : 获取教室设置的插播回放
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_47_ROOM_GET_SPOT_VIDEO)
    BjyResult<Void> getSpotVideo(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 53 : 禁用/启用直播间
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_53_ROOM_SWITCH_ROOM_STATUS)
    BjyResult<Void> switchRoomStatus(BjyPartnerInfo partnerInfo, SwitchRoomStatusReq req);

    /**
     * API 57 : 直播带货创建进房记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_57_ROOM_CREATE_SELL_JOIN_RECORD)
    BjyResult<Void> createSellJoinRecord(BjyPartnerInfo partnerInfo, CreateSellJoinRecordReq req);

    /**
     * API 58 : 直播带货创建购买记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_58_ROOM_CREATE_SELL_BUY_RECORD)
    BjyResult<Void> createSellBuyRecord(BjyPartnerInfo partnerInfo, CreateSellBuyRecordReq req);

    /**
     * API 59: 设置虚拟人数与成员
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_59_ROOM_ADJUST_DISPLAY_USER)
    BjyResult<Void> adjustDisplayUser(BjyPartnerInfo partnerInfo, AdjustDisplayUserReq req);

    /**
     * API 65 : 删除用户参加码
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_65_ROOM_DELETE_CODE)
    BjyResult<Void> deleteCode(BjyPartnerInfo partnerInfo, DeleteCodeReq req);

    /**
     * API 73 : 强制关闭教室
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_73_ROOM_ENFORCE_FORBID_ROOM)
    BjyResult<Void> enforceForbidRoom(BjyPartnerInfo partnerInfo, EnforceForbidRoomReq req);

    /**
     * API 74:获取设置隔离用户数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_74_ROOM_DIVIDE_USER_DATA)
    BjyResult<Void> divideUserData(BjyPartnerInfo partnerInfo, DivideUserDataReq req);

    /**
     * API 79 : 教室插播视频
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_79_ROOM_SET_ROOM_SPOT_LIVE)
    BjyResult<Boolean> setRoomSpotLive(BjyPartnerInfo partnerInfo, SetRoomSpotLiveReq req);

    /**
     * API 80 : 清除教室插播视频
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_80_ROOM_CLEAR_ROOM_SPOT_LIVE)
    BjyResult<Boolean> clearRoomSpotLive(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 81 : 教室点播预热
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_81_ROOM_SET_ROOM_VIDEO_ON_DEMAND)
    BjyResult<Boolean> setRoomVideoOnDemand(BjyPartnerInfo partnerInfo, SetRoomVideoOnDemandReq req);

    /**
     * API 82 : 清除教室内的点播预热视频
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_82_ROOM_CLEAR_ROOM_VIDEO_ON_DEMAND)
    BjyResult<Void> clearRoomVideoOnDemand(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 83 : 设置教室观看限制
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_83_ROOM_SET_ROOM_WATCH_LIMIT)
    BjyResult<Void> setRoomWatchLimit(BjyPartnerInfo partnerInfo, SetRoomWatchLimitReq req);

    /**
     * API 96 : 修改分组直播组名
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_96_ROOM_UPDATE_GROUP_NAME)
    BjyResult<Void> updateGroupName(BjyPartnerInfo partnerInfo, UpdateGroupNameReq req);

    /**
     * API 97 : 上传分组直播分组logo
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_97_ROOM_SET_LIVE_ROOM_GROUP_LOGO)
    BjyResult<Void> setLiveRoomGroupLogo(BjyPartnerInfo partnerInfo, SetLiveRoomGroupLogoReq req);

    /**
     * API 98 : 获取已上传分组直播分组logo地址
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_98_ROOM_GET_LIVE_ROOM_GROUP_LOGO)
    BjyResult<Void> getLiveRoomGroupLogo(BjyPartnerInfo partnerInfo, GetLiveRoomGroupLogoReq req);

    /**
     * API 116 : 按角色获取分组直播参加码接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_116_ROOM_GET_GROUP_LIVE_CODES_BY_USER_ROLE)
    BjyResult<Void> getGroupLiveCodesByUserRole(BjyPartnerInfo partnerInfo, GetGroupLiveCodesByUserRoleReq req);

    /**
     * API 117 : 学生昵称支持客户自定义上传
     * @param partnerInfo 百家云合作者参数
     * @param nickname [必填] nickname 昵称列表，以英文逗号分隔。作为直播间助教发言随机昵称库，最多支持50个
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_117_ROOM_SET_RANDOM_NICKNAME)
    BjyResult<Void> setRandomNickname(BjyPartnerInfo partnerInfo, String nickname);

    /**
     * API 41 : 批量添加插播
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_41_ROOM_BATCH_ADD_SPOT_VIDEO)
    BjyResult<Void> batchAddSpotVideo(BjyPartnerInfo partnerInfo, BatchAddSpotVideoReq req);

    /**
     * API 43 : 批量移除小班课中的插播
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_43_ROOM_BATCH_REMOVE_SPOT_VIDEO)
    BjyResult<Void> batchRemoveSpotVideo(BjyPartnerInfo partnerInfo, BatchRemoveSpotVideoReq req);

    /**
     * API 7 : 新东方定制 - 批量创建线上双师分组
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_7_ROOM_BATCH_CREATE_SUB_LIVE_ROOM)
    BjyResult<Void> batchCreateSubLiveRoom(BjyPartnerInfo partnerInfo, BatchCreateSubLiveRoomReq req);

    /**
     * API 8 : 新东方定制 - 批量删除教室
     * @param partnerInfo 百家云合作者参数
     * @param roomIds [必填] room_ids room_id,多个用逗号隔开
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_8_ROOM_BATCH_DELETE)
    BjyResult<Void> batchDelete(BjyPartnerInfo partnerInfo, @RequestParam("room_ids") String roomIds);

    /**
     * API 76 : 获取教室主讲老师的信息
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_76_ROOM_TEACHER_INFO)
    BjyResult<Void> teacherInfo(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 1 : 创建双师加大直播教室接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_ROOM_CREATE_DOUBLE_TEACHER_LIVE)
    BjyResult<Void> createDoubleTeacherLive(BjyPartnerInfo partnerInfo, CreateDoubleTeacherLiveReq req);

    /**
     * API 77 : 获取推流直播的多个CDN推流地址
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_77_ROOM_GET_MULTI_PUSH_STREAM_URL)
    BjyResult<Void> getMultiPushStreamUrl(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 6:给教室设置观看密码
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_ROOM_SET_ROOM_PASSWORD)
    BjyResult<Void> setRoomPassword(BjyPartnerInfo partnerInfo, SetRoomPasswordReq req);

    /**
     * 紧急踢人
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_KICK_OUT_USER)
    BjyResult<Void> kickOutUser(BjyPartnerInfo partnerInfo, KickOutUserReq req);

    /**
     * 移除黑名单。注：一次最多200个
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_REMOVE_BLACKLIST)
    BjyResult<Void> removeBlacklist(BjyPartnerInfo partnerInfo, RemoveBlacklistReq req);

    /**
     * 批量踢人。注：一次最多200个
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_BATCH_KICK_OUT_USER)
    BjyResult<Void> batchKickOutUser(BjyPartnerInfo partnerInfo, BatchKickOutUserReq req);

    /**
     * API 16:更新进入房间参加码
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_16_ROOM_UPDATE_INVITE_CODE)
    BjyResult<Void> updateInviteCode(BjyPartnerInfo partnerInfo, UpdateInviteCodeReq req);

    /**
     * 分组课堂-分组白名单列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_LIST_GROUP_CODE_USER)
    BjyResult<Void> listGroupCodeUser(BjyPartnerInfo partnerInfo, ListGroupCodeUserReq req);

    /**
     * 分组课堂-分组白名单添加用户
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_ADD_GROUP_CODE_USER)
    BjyResult<Void> addGroupCodeUser(BjyPartnerInfo partnerInfo, AddGroupCodeUserReq req);

    /**
     * 分组课堂-分组白名单删除用户
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_REMOVE_GROUP_CODE_USER)
    BjyResult<Void> removeGroupCodeUser(BjyPartnerInfo partnerInfo, RemoveGroupCodeUserReq req);

    /**
     * 分组课堂-获取学生分组码列表
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 直播间id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_GET_STUDENT_GROUP_LIVE_CODES)
    BjyResult<Void> getStudentGroupLiveCodes(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * 获取小班课试听参加码
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 房间 ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_SHOW_AUDITION_CODE)
    BjyResult<Void> showAuditionCode(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * 上传图片
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_UPLOAD_IMAGE)
    BjyResult<UploadImageResp> uploadImage(BjyPartnerInfo partnerInfo, UploadImageReq req);

    /**
     * 设置房间分享地址等信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_SET_SHARE_INFO)
    BjyResult<Void> setShareInfo(BjyPartnerInfo partnerInfo, SetShareInfoReq req);

    /**
     * 查询直播未开始前的预热视频列表
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_GET_ROOM_VIDEO_ON_DEMAND_LIST)
    BjyResult<GetRoomVideoOnDemandListResp> getRoomVideoOnDemandList(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * 直播间广播购物订单
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_BROADCAST_SHOPPING_ORDER)
    BjyResult<BroadcastShoppingOrderResp> broadcastShoppingOrder(BjyPartnerInfo partnerInfo, BroadcastShoppingOrderReq req);

    /**
     * 获取当前用户信息
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_GET_CURRENT_USER)
    BjyResult<GetCurrentUserResp> getCurrentUser(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * 获取房间虚拟用户列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_GET_FAKE_NAME_AVATAR_LIST)
    BjyResult<TotalListResp<GetFakeNameAvatarListDto>> getFakeNameAvatarList(BjyPartnerInfo partnerInfo, GetFakeNameAvatarListReq req);

    /**
     * 编辑房间虚拟用户列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_EDIT_FAKE_NAME_AVATAR)
    BjyResult<Boolean> editFakeNameAvatar(BjyPartnerInfo partnerInfo, EditFakeNameAvatarReq req);

    /**
     * 一键绑定虚拟用户头像
     * @param partnerInfo 百家云合作者参数
     * @param roomId 教室ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_ONE_KEY_BIND_FAKE_NAME_AVATAR)
    BjyResult<Boolean> oneKeyBindFakeNameAvatar(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * 删除房间虚拟用户列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_DELETE_FAKE_NAME_AVATAR)
    BjyResult<Boolean> deleteFakeNameAvatar(BjyPartnerInfo partnerInfo, DeleteFakeNameAvatarReq req);

    /**
     * 导入虚拟用户
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_IMPORT_NICKNAME_FILE)
    BjyResult<Boolean> importNicknameFile(BjyPartnerInfo partnerInfo, ImportNicknameFileReq req);

    /**
     * 伪直播预设虚拟话术
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_SET_MOCK_PRESET_CHAT_ART)
    BjyResult<Boolean> setMockPresetChatArt(BjyPartnerInfo partnerInfo, SetMockPresetChatArtReq req);


    /**
     * 伪直播清空预设虚拟话术
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_CLEAR_MOCK_PRESET_CHAT_ART)
    BjyResult<Boolean> clearMockPresetChatArt(BjyPartnerInfo partnerInfo, SetMockPresetChatArtReq req);

    /**
     * 图片资源 - 保存图片
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_SAVE_PARTNER_IMAGE)
    BjyResult<SavePartnerImageResp> savePartnerImage(BjyPartnerInfo partnerInfo, SavePartnerImageReq req);

    /**
     * 图片资源 - 删除图片
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_DELETE_PARTNER_IMAGE)
    BjyResult<Boolean> deletePartnerImage(BjyPartnerInfo partnerInfo, DeletePartnerImageReq req);

    /**
     * 图片资源 - 图片列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_GET_PARTNER_IMAGE_LIST)
    BjyResult<TotalListResp<GetPartnerImageListDto>> getPartnerImageList(BjyPartnerInfo partnerInfo, RoomPageReq req);

    /**
     * 设置虚拟话术开关
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_SET_VIRTUAL_CHAT_ART_CONFIG)
    BjyResult<SetVirtualChatArtConfigResp> setVirtualChatArtConfig(BjyPartnerInfo partnerInfo, SetVirtualChatArtConfigReq req);

    /**
     * 虚拟话术列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_LIST_VIRTUAL_CHAT)
    BjyResult<TotalListResp<ListVirtualChatDto>> listVirtualChat(BjyPartnerInfo partnerInfo, RoomPageReq req);

    /**
     * 新增虚拟话术
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_ADD_VIRTUAL_CHAT)
    BjyResult<Boolean> addVirtualChat(BjyPartnerInfo partnerInfo, AddVirtualChatReq req);

    /**
     * 批量新增虚拟话术
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_BATCH_ADD_VIRTUAL_CHAT)
    BjyResult<Boolean> batchAddVirtualChat(BjyPartnerInfo partnerInfo, BatchAddVirtualChatReq req);

    /**
     * 编辑虚拟话术
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_EDIT_VIRTUAL_CHAT)
    BjyResult<Boolean> editVirtualChat(BjyPartnerInfo partnerInfo, EditVirtualChatReq req);

    /**
     * 批量导入虚拟话术
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_BATCH_IMPORT_VIRTUAL_CHAT)
    BjyResult<Boolean> batchImportVirtualChat(BjyPartnerInfo partnerInfo, BatchImportVirtualChatReq req);

    /**
     * 批量删除虚拟话术
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_BATCH_DELETE_VIRTUAL_CHAT)
    BjyResult<Boolean> batchDeleteVirtualChat(BjyPartnerInfo partnerInfo, BatchDeleteVirtualChatReq req);

    /**
     * 复制虚拟话术
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_COPY_VIRTUAL_CHAT_ART)
    BjyResult<CountResp> copyVirtualChatArt(BjyPartnerInfo partnerInfo, CopyVirtualChatArtReq req);

    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_PUSH_FLASH_SALE_ORDER)
    BjyResult<PushFlashSaleOrderResp> pushFlashSaleOrder(BjyPartnerInfo partnerInfo, PushFlashSaleOrderReq req);

    @Request(method = Request.Method.POST, path = BjyUrls.API_X_ROOM_PUSH_GOODS_SALE_ORDER)
    BjyResult<PushGoodsSaleOrderResp> pushGoodsSaleOrder(BjyPartnerInfo partnerInfo, PushGoodsSaleOrderReq req);
}