package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.TotalListResp;
import com.baijiayun.openapi.sdk.dto.playback.*;

/**
 * Auto generate interface of PlaybackApi.
 */
@BjyClient
public interface PlaybackApi {

    /**
     * API 87 : 获取大班课回放打点标记数据接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_87_PLAYBACK_GET_PLAYBACK_KEY_FRAME_DESC_LIST)
    BjyResult<Void> getPlaybackKeyFrameDescList(BjyPartnerInfo partnerInfo, GetPlaybackKeyFrameDescListReq req);

    /**
     * API 1 : 查询直播回放信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_1_PLAYBACK_GET_BASIC_INFO)
    BjyResult<Void> getBasicInfo(BjyPartnerInfo partnerInfo, GetBasicInfoReq req);

    /**
     * API 2 : 获取回放列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_2_PLAYBACK_GET_LIST)
    BjyResult<TotalListResp<GetListDto>> getList(BjyPartnerInfo partnerInfo, GetListReq req);

    /**
     * API 3: 获取回放token
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_3_PLAYBACK_GET_PLAYER_TOKEN)
    BjyResult<GetPlayerTokenResp> getPlayerToken(BjyPartnerInfo partnerInfo, GetPlayerTokenReq req);

    /**
     * API 4: 批量获取回放token
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_4_PLAYBACK_GET_PLAYER_TOKEN_BATCH)
    BjyResult<Void> getPlayerTokenBatch(BjyPartnerInfo partnerInfo, GetPlayerTokenBatchReq req);

    /**
     * API 5: 获取长期房间云录制的序列号列表
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 房间号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_5_PLAYBACK_GET_SESSION_LIST)
    BjyResult<Void> getSessionList(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 7: 设置回放发布状态
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_7_PLAYBACK_SET_PUBLISH_STATUS)
    BjyResult<Void> setPublishStatus(BjyPartnerInfo partnerInfo, SetPublishStatusReq req);

    /**
     * API 8 : 删除回放
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_8_PLAYBACK_DELETE)
    BjyResult<Void> delete(BjyPartnerInfo partnerInfo, DeleteReq req);

    /**
     * API 9 : 更新回放信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_9_PLAYBACK_UPDATE)
    BjyResult<Void> update(BjyPartnerInfo partnerInfo, UpdateReq req);

    /**
     * API 10 : 获取裁剪回放列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_10_PLAYBACK_GET_CROP_LIST)
    BjyResult<Void> getCropList(BjyPartnerInfo partnerInfo, GetCropListReq req);

    /**
     * API 11 : 设置回放主版本
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_11_PLAYBACK_SET_MAIN_VERSION)
    BjyResult<Void> setMainVersion(BjyPartnerInfo partnerInfo, SetMainVersionReq req);

    /**
     * API 12 : 获取ppt转成的pdf的路径列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_12_PLAYBACK_GET_PLAYBACK_PPT_URL_LIST)
    BjyResult<Void> getPlaybackPptUrlList(BjyPartnerInfo partnerInfo, GetPlaybackPptUrlListReq req);

    /**
     * API 13 : 获取ppt转成的pdf具体路径
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_13_PLAYBACK_GET_PLAYBACK_PPT_URL)
    BjyResult<Void> getPlaybackPptUrl(BjyPartnerInfo partnerInfo, GetPlaybackPptUrlReq req);

    /**
     * API 14 : 替换回放
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_14_PLAYBACK_REPLACE_PLAYBACK)
    BjyResult<Void> replacePlayback(BjyPartnerInfo partnerInfo, ReplacePlaybackReq req);

    /**
     * API 15 : 点播替换回放
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_15_PLAYBACK_REPLACE_PLAYBACK_BY_VIDEO)
    BjyResult<Void> replacePlaybackByVideo(BjyPartnerInfo partnerInfo, ReplacePlaybackByVideoReq req);

    /**
     * API 16 : 回放录制纯视频
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_16_PLAYBACK_GENERATE_PURE_VIDEO)
    BjyResult<Void> generatePureVideo(BjyPartnerInfo partnerInfo, GeneratePureVideoReq req);

    /**
     * API 17 : 回放记录分段裁剪
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_17_PLAYBACK_CROP_VIDEO)
    BjyResult<Void> cropVideo(BjyPartnerInfo partnerInfo, CropVideoReq req);

    /**
     * API 18: 查询直播间录制节点数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_18_PLAYBACK_GET_RECORD_OPERATION_TIME)
    BjyResult<Void> getRecordOperationTime(BjyPartnerInfo partnerInfo, GetRecordOperationTimeReq req);

    /**
     * API 19 : 回放录制纯视频（针对教室全部回放）
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_19_PLAYBACK_GENERATE_CLASS_PURE_VIDEO)
    BjyResult<Void> generateClassPureVideo(BjyPartnerInfo partnerInfo, GenerateClassPureVideoReq req);

    /**
     * API 20 : 获取回放转纯视频下载地址
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_20_PLAYBACK_GET_RECORD_VIDEO_URL)
    BjyResult<Void> getRecordVideoUrl(BjyPartnerInfo partnerInfo, GetRecordVideoUrlReq req);

    /**
     * API 22: 删除回放指定聊天数据接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_22_PLAYBACK_DELETE_PLAYBACK_CHAT)
    BjyResult<Void> deletePlaybackChat(BjyPartnerInfo partnerInfo, DeletePlaybackChatReq req);

    /**
     * API 29: 获取回放有效期数据接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_29_PLAYBACK_GET_PLAYBACK_VALID_DAY)
    BjyResult<Void> getPlaybackValidDay(BjyPartnerInfo partnerInfo, GetPlaybackValidDayReq req);

    /**
     * API 30: 设置回放有效期数据接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_30_PLAYBACK_SET_PLAYBACK_VALID_DAY)
    BjyResult<Void> setPlaybackValidDay(BjyPartnerInfo partnerInfo, SetPlaybackValidDayReq req);

    /**
     * API 31: 回放课件生成接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_31_PLAYBACK_START_PLAYBACK_PDF_TASK)
    BjyResult<Void> startPlaybackPdfTask(BjyPartnerInfo partnerInfo, StartPlaybackPdfTaskReq req);

    /**
     * API 32: 回放打点设置接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_32_PLAYBACK_SAVE_PLAYBACK_KEY_FRAME_DESC)
    BjyResult<Void> savePlaybackKeyFrameDesc(BjyPartnerInfo partnerInfo, SavePlaybackKeyFrameDescReq req);

    /**
     * API 33:获取回放 limited_token
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_33_PLAYBACK_GET_LIMITED_PLAYER_TOKEN)
    BjyResult<Void> getLimitedPlayerToken(BjyPartnerInfo partnerInfo, GetLimitedPlayerTokenReq req);

    /**
     * API 34: 获取回放课件数据接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_34_PLAYBACK_GET_PPT_PAGE_INFO)
    BjyResult<Void> getPptPageInfo(BjyPartnerInfo partnerInfo, GetPptPageInfoReq req);

    /**
     * API 35: 批量裁剪生成多段回放
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_35_PLAYBACK_BATCH_CROP_VIDEO)
    BjyResult<Void> batchCropVideo(BjyPartnerInfo partnerInfo, BatchCropVideoReq req);

    /**
     * API 14 : 推流录制异常日志记录
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_14_PLAYBACK_GET_PUSH_RECORD_ERROR_LOG)
    BjyResult<Void> getPushRecordErrorLog(BjyPartnerInfo partnerInfo, GetPushRecordErrorLogReq req);

    /**
     * API 4: 批量设置回放发布状态
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_4_PLAYBACK_SET_PUBLISH_STATUS_BATCH)
    BjyResult<Void> setPublishStatusBatch(BjyPartnerInfo partnerInfo, SetPublishStatusBatchReq req);

    /**
     * API 5: 回放播放量TOP10
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_5_PLAYBACK_GET_PLAY_COUNT_RANK)
    BjyResult<Void> getPlayCountRank(BjyPartnerInfo partnerInfo, GetPlayCountRankReq req);


    /**
     * API X: 回放分类列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_PLAYBACK_GET_CATEGORY_LIST)
    BjyResult<TotalListResp<PlaybackCategoryDto>> getCategoryList(BjyPartnerInfo partnerInfo, PlaybackCategoryListReq req);


    /**
     * API X: 添加回放分类
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_PLAYBACK_GET_CATEGORY_ADD)
    BjyResult<Void> addCategory(BjyPartnerInfo partnerInfo, PlaybackCategoryReq req);


    /**
     * API X: 编辑回放分类
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_PLAYBACK_GET_CATEGORY_EDIT)
    BjyResult<Void> editCategory(BjyPartnerInfo partnerInfo, PlaybackCategoryReq req);


    /**
     * API X: 删除回放分类
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_PLAYBACK_GET_CATEGORY_DELETE)
    BjyResult<Void> deleteCategory(BjyPartnerInfo partnerInfo, PlaybackCategoryReq req);


    /**
     * API X: 关联回放
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_PLAYBACK_GET_CATEGORY_RELATION)
    BjyResult<Void> addCategoryRelation(BjyPartnerInfo partnerInfo, PlaybackCategoryRelationReq req);
}