package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.TotalListResp;
import com.baijiayun.openapi.sdk.dto.newsub.*;

/**
 * Auto generate interface of NewSubApi.
 */
@BjyClient
public interface NewSubApi {

    /**
     * API 1 : 查询子账号列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_NEW_SUB_GET_SUB_ACCOUNT_LIST)
    BjyResult<TotalListResp<GetSubAccountListDto>> getSubAccountList(BjyPartnerInfo partnerInfo, GetSubAccountListReq req);

    /**
     * API 2 : 添加子账号
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_2_NEW_SUB_ADD_SUB_ACCOUNT)
    BjyResult<Void> addSubAccount(BjyPartnerInfo partnerInfo, AddSubAccountReq req);

    /**
     * API 3 : 获取账号信息
     * @param partnerInfo 百家云合作者参数
     * @param subPartnerId [必填] sub_partner_id 子账号partner_id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_3_NEW_SUB_GET_ACCOUNT_INFO)
    BjyResult<Void> getAccountInfo(BjyPartnerInfo partnerInfo, @RequestParam("sub_partner_id") Integer subPartnerId);

    /**
     * API 4 : 设置直播产品
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_4_NEW_SUB_SET_LIVE_ACCOUNT)
    BjyResult<Void> setLiveAccount(BjyPartnerInfo partnerInfo, SetLiveAccountReq req);

    /**
     * API 5 : 设置点播产品
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_5_NEW_SUB_SET_VIDEO_ACCOUNT)
    BjyResult<Void> setVideoAccount(BjyPartnerInfo partnerInfo, SetVideoAccountReq req);

    /**
     * API 6 : 设置信用额度
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_NEW_SUB_SET_CREDIT_MONEY)
    BjyResult<Void> setCreditMoney(BjyPartnerInfo partnerInfo, SetCreditMoneyReq req);

    /**
     * API 7 : 停用/启用账号
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_7_NEW_SUB_SET_ACCOUNT_STATUS)
    BjyResult<Void> setAccountStatus(BjyPartnerInfo partnerInfo, SetAccountStatusReq req);

    /**
     * API 8 : 更新子账号信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_8_NEW_SUB_UPDATE_SUB_ACCOUNT)
    BjyResult<Void> updateSubAccount(BjyPartnerInfo partnerInfo, UpdateSubAccountReq req);

    /**
     * API 9 : 查询子账号消费账单接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_9_NEW_SUB_GET_PARTNER_BILL_LIST)
    BjyResult<Void> getPartnerBillList(BjyPartnerInfo partnerInfo, GetPartnerBillListReq req);
}