package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.CountListResp;
import com.baijiayun.openapi.sdk.dto.PageSizeReq;
import com.baijiayun.openapi.sdk.dto.media.*;

import java.io.File;

/**
 * Auto generate interface of MediaApi.
 */
@BjyClient
public interface MediaApi {

    /**
     * API 1 : 上传图片素材
     * @param partnerInfo 百家云合作者参数
     * @param media [必填] media form-data中媒体文件标识
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_MEDIA_UPLOAD_IMG)
    BjyResult<UploadImgResp> uploadImg(BjyPartnerInfo partnerInfo, File media);

    /**
     * API 5 : 删除素材
     * @param partnerInfo 百家云合作者参数
     * @param mediaId [必填] media_id 素材id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_5_MEDIA_DEL_MEDIA)
    BjyResult<Void> delMedia(BjyPartnerInfo partnerInfo, @RequestParam("media_id") Integer mediaId);

    /**
     * API 6 : 获取图片列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_MEDIA_GET_IMG_LIST)
    BjyResult<CountListResp<GetImgListDto>> getImgList(BjyPartnerInfo partnerInfo, PageSizeReq req);
}