package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.*;
import com.baijiayun.openapi.sdk.dto.livesetting.*;

import java.io.File;
import java.util.List;

/**
 * Auto generate interface of LiveSettingApi.
 */
@BjyClient
public interface LiveSettingApi {

    /**
     * API 1 : 设置水印
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_LIVE_SETTING_SET_WATERMARK)
    BjyResult<WatermarkResp> setWatermark(BjyPartnerInfo partnerInfo, SetWatermarkReq req);

    /**
     * API 2 : 获取水印配置
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_2_LIVE_SETTING_GET_WATERMARK)
    BjyResult<WatermarkResp> getWatermark(BjyPartnerInfo partnerInfo, GetWatermarkReq req);

    /**
     * API 6 : 获取跑马灯设置
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_LIVE_SETTING_GET_LIVE_HORSE_LAMP)
    BjyResult<GetLiveHorseLampResp> getLiveHorseLamp(BjyPartnerInfo partnerInfo, GetLiveHorseLampReq req);

    /**
     * API 7 : 设置跑马灯设置
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_7_LIVE_SETTING_SET_LIVE_HORSE_LAMP)
    BjyResult<SetLiveHorseLampResp> setLiveHorseLamp(BjyPartnerInfo partnerInfo, SetLiveHorseLampReq req);

    /**
     * API 8 : 添加公告模板
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_8_LIVE_SETTING_ADD_NOTICE)
    BjyResult<IdResp> addNotice(BjyPartnerInfo partnerInfo, AddNoticeReq req);

    /**
     * API 9 : 获取公告列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_9_LIVE_SETTING_GET_NOTICE_LIST)
    BjyResult<TotalListResp<GetNoticeListDto>> getNoticeList(BjyPartnerInfo partnerInfo, GetNoticeListReq req);

    /**
     * API 10:全局设置-删除公告模板
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_10_LIVE_SETTING_DELETE_NOTICE_BATCH)
    BjyResult<Void> deleteNoticeBatch(BjyPartnerInfo partnerInfo, DeleteNoticeBatchReq req);

    /**
     * API 11 : 添加小测
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_11_LIVE_SETTING_ADD_QUIZ)
    BjyResult<IdResp> addQuiz(BjyPartnerInfo partnerInfo, AddQuizReq req);

    /**
     * API 12 : 获取小测模板
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_12_LIVE_SETTING_GET_QUIZ_LIST)
    BjyResult<TotalListResp<GetQuizListDto>> getQuizList(BjyPartnerInfo partnerInfo, GetQuizListReq req);

    /**
     * API 13 : 删除小测模板
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_13_LIVE_SETTING_DELETE_QUIZ)
    BjyResult<Void> deleteQuiz(BjyPartnerInfo partnerInfo, DeleteQuizReq req);

    /**
     * API 20 : 修改红包最大个数限制
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_20_LIVE_SETTING_SET_MAX_RED_PACKAGE_COUNT)
    BjyResult<SetMaxRedPackageCountResp> setMaxRedPackageCount(BjyPartnerInfo partnerInfo, SetMaxRedPackageCountReq req);

    /**
     * API 21 : 获取红包最大个数限制
     * @param partnerInfo 百家云合作者参数
     * @param productType 1:大班课，2，小班课，3：双师，4，企业直播（单一产品线账号不需要传此参数）
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_21_LIVE_SETTING_GET_MAX_RED_PACKAGE_COUNT)
    BjyResult<GetMaxRedPackageCountResp> getMaxRedPackageCount(BjyPartnerInfo partnerInfo, @RequestParam("product_type") Integer productType);

    /**
     * API 22 : 设置点播软水印配置
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_22_LIVE_SETTING_SET_VIDEO_WATERMARK)
    BjyResult<WatermarkResp> setVideoWatermark(BjyPartnerInfo partnerInfo, SetVideoWatermarkReq req);

    /**
     * API 23 : 获取点播软水印配置
     * @param partnerInfo 百家云合作者参数
     * @param categoryId 分类ID，传递该参数表示该点播分类水印配置，不传默认账号级配置
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_23_LIVE_SETTING_GET_VIDEO_WATERMARK)
    BjyResult<WatermarkResp> getVideoWatermark(BjyPartnerInfo partnerInfo, @RequestParam("category_id") Integer categoryId);

    /**
     * 获取免审词列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_X_LIVE_SETTING_GET_CHAT_EXEMPT_WORDS)
    BjyResult<TotalListResp<GetChatExemptWordsDto>> getChatExemptWords(BjyPartnerInfo partnerInfo, GetChatExemptWordsReq req);

    /**
     * 添加免审词
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SETTING_ADD_CHAT_EXEMPT_WORD)
    BjyResult<IdResp> addChatExemptWord(BjyPartnerInfo partnerInfo, AddChatExemptWordReq req);

    /**
     * 编辑免审词
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SETTING_EDIT_CHAT_EXEMPT_WORD)
    BjyResult<IdResp> editChatExemptWord(BjyPartnerInfo partnerInfo, EditChatExemptWordReq req);

    /**
     * 删除免审词
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SETTING_DELETE_CHAT_EXEMPT_WORD)
    BjyResult<Boolean> deleteChatExemptWord(BjyPartnerInfo partnerInfo, DeleteChatExemptWordReq req);

    /**
     * 批量添加免审词
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SETTING_BATCH_ADD_CHAT_EXEMPT_WORD)
    BjyResult<CountResp> batchAddChatExemptWord(BjyPartnerInfo partnerInfo, BatchAddChatExemptWordReq req);

    /**
     * API 2: 设置房间级别的自定义菜单(最多只能创建 4 个菜单)
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_2_LIVE_SETTING_SAVE_LIVE_CUSTOM_MENU)
    BjyResult<List<IdResp>> saveLiveCustomMenu(BjyPartnerInfo partnerInfo, SaveLiveCustomMenuReq req);

    /**
     * API 3: 保存菜单顺序
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_3_LIVE_SETTING_SORT_LIVE_CUSTOM_MENU)
    BjyResult<Void> sortLiveCustomMenu(BjyPartnerInfo partnerInfo, SortLiveCustomMenuReq req);

    /**
     * API 4: 获取菜单列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_4_LIVE_SETTING_GET_LIVE_CUSTOM_MENU)
    BjyResult<GetLiveCustomMenuResp> getLiveCustomMenu(BjyPartnerInfo partnerInfo, GetLiveCustomMenuReq req);

    /**
     * API 5: 删除菜单
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_5_LIVE_SETTING_DELETE_LIVE_CUSTOM_MENU)
    BjyResult<Void> deleteLiveCustomMenu(BjyPartnerInfo partnerInfo, DeleteLiveCustomMenuReq req);

    /**
     * API 6: 菜单绑定视频（菜单类型是音视频时，需要给菜单绑定视频）
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_LIVE_SETTING_BIND_VIDEO_CUSTOM_MENU)
    BjyResult<Void> bindVideoCustomMenu(BjyPartnerInfo partnerInfo, BindVideoCustomMenuReq req);

    /**
     * API 7: 保存视频顺序
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_7_LIVE_SETTING_SORT_VIDEO_CUSTOM_MENU)
    BjyResult<Void> sortVideoCustomMenu(BjyPartnerInfo partnerInfo, SortVideoCustomMenuReq req);

    /**
     * API 8: 删除视频菜单
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_8_LIVE_SETTING_REMOVE_VIDEO_CUSTOM_MENU)
    BjyResult<Void> removeVideoCustomMenu(BjyPartnerInfo partnerInfo, RemoveVideoCustomMenuReq req);

    /**
     * API 9: 获取视频菜单列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_9_LIVE_SETTING_GET_VIDEO_CUSTOM_MENU_LIST)
    BjyResult<TotalListResp<GetVideoCustomMenuListItem>> getVideoCustomMenuList(BjyPartnerInfo partnerInfo, GetVideoCustomMenuListReq req);

    /**
     * API 10: 更新视频菜单信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_10_LIVE_SETTING_UPDATE_VIDEO_CUSTOM_MENU)
    BjyResult<Void> updateVideoCustomMenu(BjyPartnerInfo partnerInfo, UpdateVideoCustomMenuReq req);

    /**
     * API 11: 批量保存教室级别自定义菜单视频
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_11_LIVE_SETTING_SAVE_VIDEO_CUSTOM_MENU)
    BjyResult<List<IdResp>> saveVideoCustomMenu(BjyPartnerInfo partnerInfo, SaveVideoCustomMenuReq req);


    /**
     * API 12: 批量保存系列
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_12_LIVE_SETTING_SAVE_SERIES_CUSTOM_MENU)
    BjyResult<CountResp> saveSeriesCustomMenu(BjyPartnerInfo partnerInfo, SaveSeriesCustomMenuReq req);


    /**
     * API 13: 系列列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_13_LIVE_SETTING_GET_SERIES_CUSTOM_MENU_LIST)
    BjyResult<SeriesCustomMenuResp> seriesCustomMenuList(BjyPartnerInfo partnerInfo, SeriesCustomMenuBaseReq req);


    /**
     * API 14: 批量删除系列
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_13_LIVE_SETTING_DELETE_SERIES_CUSTOM_MENU)
    BjyResult<CountResp> deleteSeriesCustomMenu(BjyPartnerInfo partnerInfo, SeriesCustomMenuDelReq req);



    /**
     * 查询可以选择的转播房间
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SETTING_GET_SELECT_BROADCAST_ROOM_LIST)
    BjyResult<TotalListResp<GetSelectBroadcastRoomListDto>> getSelectBroadcastRoomList(BjyPartnerInfo partnerInfo, GetSelectBroadcastRoomListReq req);

    /**
     * 开启/关闭 转播
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SETTING_AUTO_BROADCAST_ROOM)
    BjyResult<Void> autoBroadcastRoom(BjyPartnerInfo partnerInfo, AutoBroadcastRoomReq req);

    /**
     * API 88 : 大班课转播增加转播房间接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_88_LIVE_SETTING_ADD_BROADCAST_ROOM)
    BjyResult<Boolean> addBroadcastRoom(BjyPartnerInfo partnerInfo, AddBroadcastRoomReq req);

    /**
     * API 89 : 大班课转播房间查询接口
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_89_LIVE_SETTING_GET_BROADCAST_ROOM)
    BjyResult<CountListResp<GetBroadcastRoomDto>> getBroadcastRoom(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 90 : 大班课转播房间删除接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_90_LIVE_SETTING_DEL_BROADCAST_ROOM)
    BjyResult<Boolean> delBroadcastRoom(BjyPartnerInfo partnerInfo, DelBroadcastRoomReq req);

    /**
     * API 91 : 大班课开启&关闭转播接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_91_LIVE_SETTING_TRANSFER_BROADCAST_ROOM)
    BjyResult<Void> transferBroadcastRoom(BjyPartnerInfo partnerInfo, TransferBroadcastRoomReq req);

    /**
     * API 92 : 批量设置敏感词接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_92_LIVE_SETTING_ADD_SENSITIVE_WORD_BATCH)
    BjyResult<TotalResp> addSensitiveWordBatch(BjyPartnerInfo partnerInfo, AddSensitiveWordBatchReq req);

    /**
     * API 93 : 导入敏感词接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_93_LIVE_SETTING_IMPORT_SENSITIVE_WORD)
    BjyResult<Integer> importSensitiveWord(BjyPartnerInfo partnerInfo, ImportSensitiveWordReq req);

    /**
     * API 94 : 批量删除敏感词接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_94_LIVE_SETTING_DELETE_SENSITIVE_WORD_BATCH)
    BjyResult<Void> deleteSensitiveWordBatch(BjyPartnerInfo partnerInfo, DeleteSensitiveWordBatchReq req);

    /**
     * API 95 : 查询敏感词接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_95_LIVE_SETTING_GET_SENSITIVE_WORD)
    BjyResult<TotalListResp<GetSensitiveWordDto>> getSensitiveWord(BjyPartnerInfo partnerInfo, GetSensitiveWordReq req);

    /**
     * API 99 : 多平台推流地址增加接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_99_LIVE_SETTING_ADD_MULTI_PLATFORM_STREAMING)
    BjyResult<Void> addMultiPlatformStreaming(BjyPartnerInfo partnerInfo, AddMultiPlatformStreamingReq req);

    /**
     * API 100 : 多平台推流地址删除接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_100_LIVE_SETTING_DELETE_MULTI_PLATFORM_STREAMING)
    BjyResult<Void> deleteMultiPlatformStreaming(BjyPartnerInfo partnerInfo, DeleteMultiPlatformStreamingReq req);

    /**
     * API 101 : 多平台推流地址编辑接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_101_LIVE_SETTING_EDIT_MULTI_PLATFORM_STREAMING)
    BjyResult<Void> editMultiPlatformStreaming(BjyPartnerInfo partnerInfo, EditMultiPlatformStreamingReq req);

    /**
     * API 102 : 多平台推流地址查询接口
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_102_LIVE_SETTING_GET_MULTI_PLATFORM_STREAMING_LIST)
    BjyResult<Void> getMultiPlatformStreamingList(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * 全局虚拟成员列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_X_LIVE_SETTING_GET_FAKE_NAME_AVATAR_LIST)
    BjyResult<TotalListResp<GetFakeNameAvatarInfoResp>> getFakeNameAvatarList(BjyPartnerInfo partnerInfo, GetFakeNameAvatarListReq req);

    /**
     * 新增全局虚拟成员
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SETTING_BATCH_ADD_FAKE_NAME_AVATAR)
    BjyResult<CountResp> batchAddFakeNameAvatar(BjyPartnerInfo partnerInfo, BatchAddFakeNameAvatarReq req);

    /**
     * 编辑全局虚拟成员
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SETTING_EDIT_FAKE_NAME_AVATAR)
    BjyResult<IdResp> editFakeNameAvatar(BjyPartnerInfo partnerInfo, EditFakeNameAvatarReq req);

    /**
     * 删除全局虚拟成员
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SETTING_DELETE_FAKE_NAME_AVATAR)
    BjyResult<CountResp> deleteFakeNameAvatar(BjyPartnerInfo partnerInfo, DeleteFakeNameAvatarReq req);

    /**
     * 全局虚拟成员详情
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SETTING_GET_FAKE_NAME_AVATAR_INFO)
    BjyResult<GetFakeNameAvatarInfoResp> getFakeNameAvatarInfo(BjyPartnerInfo partnerInfo, GetFakeNameAvatarInfoReq req);

    /**
     * 新增全局头像
     * @param partnerInfo 百家云合作者参数
     * @param attachment 附件
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SETTING_SAVE_PARTNER_IMAGE)
    BjyResult<SavePartnerImageResp> savePartnerImage(BjyPartnerInfo partnerInfo, File attachment);

    /**
     * 设置直播自定义装饰
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SETTING_SET_LIVE_CUSTOM_DECORATE)
    BjyResult<Void> setLiveCustomDecorate(BjyPartnerInfo partnerInfo, SetLiveCustomDecorateReq req);

    /**
     * 批量添加黑名单
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SETTING_BATCH_ADD_LIVE_BLACKLIST)
    BjyResult<CountResp> batchAddLiveBlacklist(BjyPartnerInfo partnerInfo, BatchAddLiveBlacklistReq req);

    /**
     * 批量删除黑名单
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_LIVE_SETTING_BATCH_DELETE_LIVE_BLACKLIST)
    BjyResult<CountResp> batchDeleteLiveBlacklist(BjyPartnerInfo partnerInfo, BatchDeleteLiveBlacklistReq req);
}