package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.interactinfo.*;

/**
 * Auto generate interface of InteractInfoApi.
 */
@BjyClient
public interface InteractInfoApi {

    /**
     * API 1: 签到汇总数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_INTERACT_INFO_GET_INTERACT_LIST)
    BjyResult<Void> getInteractList(BjyPartnerInfo partnerInfo, GetInteractListReq req);

    /**
     * API 2: 签到明细数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_2_INTERACT_INFO_GET_INTERACT_DETAIL)
    BjyResult<Void> getInteractDetail(BjyPartnerInfo partnerInfo, GetInteractDetailReq req);
}