package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.interactdata.*;

/**
 * Auto generate interface of InteractDataApi.
 */
@BjyClient
public interface InteractDataApi {

    /**
     * API 1:双师人员数据保存
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_INTERACT_DATA_SAVE)
    BjyResult<Void> save(BjyPartnerInfo partnerInfo, SaveReq req);

    /**
     * API 2:根据签到id,获取签到信息
     * @param partnerInfo 百家云合作者参数
     * @param checkinId [必填] checkin_id 签到 id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_2_INTERACT_DATA_GET_CHECKIN_DATA)
    BjyResult<Void> getCheckinData(BjyPartnerInfo partnerInfo, @RequestParam("checkin_id") Integer checkinId);

    /**
     * API 3:删除班级、助教、学生信息
     * @param partnerInfo 百家云合作者参数
     * @param classIds [必填] class_ids 需要删除的班级第三方 id 列表
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_3_INTERACT_DATA_DELETE)
    BjyResult<Void> delete(BjyPartnerInfo partnerInfo, @RequestParam("class_ids") String classIds);

    /**
     * API 4:获取班级、助教、学生信息列表
     * @param partnerInfo 百家云合作者参数
     * @param classId [必填] class_id 第三方班级 id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_4_INTERACT_DATA_LIST)
    BjyResult<Void> list(BjyPartnerInfo partnerInfo, @RequestParam("class_id") Integer classId);

    /**
     * API 8:修改回调地址
     * @param partnerInfo 百家云合作者参数
     * @param callbackUrl [必填] callback_url 回调地址
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_8_INTERACT_DATA_UPDATE_CALLBACK_URL)
    BjyResult<Void> updateCallbackUrl(BjyPartnerInfo partnerInfo, @RequestParam("callback_url") String callbackUrl);

    /**
     * API 3: 获取班级投票数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_3_INTERACT_DATA_GET_CLASS_VOTE_DATA)
    BjyResult<Void> getClassVoteData(BjyPartnerInfo partnerInfo, GetClassVoteDataReq req);

    /**
     * API 4:获取班级红包数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_4_INTERACT_DATA_GET_RED_PACKAGE_DATA)
    BjyResult<Void> getRedPackageData(BjyPartnerInfo partnerInfo, GetRedPackageDataReq req);

    /**
     * API 5: 获取班级随机点名数据
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_5_INTERACT_DATA_GET_RANDOM_ASK_DATA)
    BjyResult<Void> getRandomAskData(BjyPartnerInfo partnerInfo, GetRandomAskDataReq req);

    /**
     * API 6: 获取AI班级数人数列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_INTERACT_DATA_GET_AI_USER_COUNT_DATA)
    BjyResult<Void> getAiUserCountData(BjyPartnerInfo partnerInfo, GetAiUserCountDataReq req);
}