package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.clazz.*;

/**
 * Auto generate interface of ClazzApi.
 */
@BjyClient
public interface ClazzApi {

    /**
     * 双师创建班级
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_CLASS_CREATE)
    BjyResult<Void> create(BjyPartnerInfo partnerInfo, CreateReq req);

    /**
     * 双师修改班级信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_CLASS_UPDATE)
    BjyResult<Void> update(BjyPartnerInfo partnerInfo, UpdateReq req);

    /**
     * 双师删除班级
     * @param partnerInfo 百家云合作者参数
     * @param classId [必填] class_id 第三方班级 id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_CLASS_DELETE)
    BjyResult<Void> delete(BjyPartnerInfo partnerInfo, @RequestParam("class_id") Integer classId);

    /**
     * 双师展示助教班级列表
     * @param partnerInfo 百家云合作者参数
     * @param teacherId [必填] teacher_id 第三方助教 id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_CLASS_LIST)
    BjyResult<Void> list(BjyPartnerInfo partnerInfo, @RequestParam("teacher_id") Integer teacherId);
}