package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.chat.*;

/**
 * Auto generate interface of ChatApi.
 */
@BjyClient
public interface ChatApi {

    /**
     * API 77: 获取教室聊天消息审核列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_77_CHAT_GET_ROOM_CHAT_LIST)
    BjyResult<Void> getRoomChatList(BjyPartnerInfo partnerInfo, GetRoomChatListReq req);

    /**
     * API 78 : 批量审核教室内的聊天消息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_78_CHAT_CHECK_CHAT)
    BjyResult<Void> checkChat(BjyPartnerInfo partnerInfo, CheckChatReq req);
}