package com.baijiayun.openapi.sdk;

/**
 * 百家云 OpenAPI
 * <p>命名格式: API_编号_URI大写，前缀 "API_编号" 用于快速查找官方文档。</p>
 * <p>若API编号不存在，则使用 "API_X" 作为前缀。</p>
 *
 * @author yanmaoyuan
 * @see <a href="https://dev.baijiayun.com/wiki/detail/83">开发者中心 > 直播文档 > 后台全局设置API接口</a>
 * @see <a href="https://dev.baijiayun.com/wiki/detail/98">开发者中心 > 直播文档 > 子账号相关API接口文档</a>
 * @see <a href="https://dev.baijiayun.com/wiki/detail/80">开发者中心 > 直播文档 > 企业直播服务端API接口</a>
 * @see <a href="https://dev.baijiayun.com/wiki/detail/79">开发者中心 > 直播文档 > 大班课直播服务端API接口</a>
 * @see <a href="https://dev.baijiayun.com/wiki/detail/78">开发者中心 > 直播文档 > 小班课直播服务端API接口</a>
 * @see <a href="https://dev.baijiayun.com/wiki/detail/4">开发者中心 > 点播文档 > 点播服务端API接口</a>
 * @see <a href="https://dev.baijiayun.com/wiki/detail/6">开发者中心 > 回放文档 > 回放服务端API接口</a>
 * @see <a href="https://dev.baijiayun.com/wiki/detail/84">开发者中心 > 双师文档 > 双师直播服务端API接口</a>
 */
public final class BjyUrls {
    private BjyUrls() {
    }

    public static final String WEB_ROOM_ENTER = "/web/room/enter";
    public static final String WEB_ROOM_QUICKENTER = "/web/room/quickenter";
    public static final String WEB_PLAYBACK_INDEX = "/web/playback/index";
    public static final String WEB_VIDEO_PLAYER = "/web/video/player";
    public static final String WEB_DXB_LIVE_CONTROL = "/web/dxb/liveControl";

    ///// 后台全局设置API接口 /////
    /**
     * API 1 : 设置水印
     */
    public static final String API_1_LIVE_SETTING_SET_WATERMARK = "/openapi/live_setting/setWatermark";
    /**
     * API 2 : 获取水印配置
     */
    public static final String API_2_LIVE_SETTING_GET_WATERMARK = "/openapi/live_setting/getWatermark";
    // API 3 ~ 5 为敏感词，见下面大班课 API 92 ~ 95
    /**
     * API 6 : 获取跑马灯设置
     */
    public static final String API_6_LIVE_SETTING_GET_LIVE_HORSE_LAMP = "/openapi/live_setting/getLiveHorseLamp";
    /**
     * API 7 : 设置跑马灯设置
     */
    public static final String API_7_LIVE_SETTING_SET_LIVE_HORSE_LAMP = "/openapi/live_setting/setLiveHorseLamp";
    /**
     * API 8 : 添加公告模板
     */
    public static final String API_8_LIVE_SETTING_ADD_NOTICE = "/openapi/live_setting/addNotice";
    /**
     * API 9 : 获取公告列表
     */
    public static final String API_9_LIVE_SETTING_GET_NOTICE_LIST = "/openapi/live_setting/getNoticeList";
    /**
     * API 10:全局设置-删除公告模板
     */
    public static final String API_10_LIVE_SETTING_DELETE_NOTICE_BATCH = "/openapi/live_setting/deleteNoticeBatch";
    /**
     * API 11 : 添加小测
     */
    public static final String API_11_LIVE_SETTING_ADD_QUIZ = "/openapi/live_setting/addQuiz";
    /**
     * API 12 : 获取小测模板
     */
    public static final String API_12_LIVE_SETTING_GET_QUIZ_LIST = "/openapi/live_setting/getQuizList";
    /**
     * API 13 : 删除小测模板
     */
    public static final String API_13_LIVE_SETTING_DELETE_QUIZ = "/openapi/live_setting/deleteQuiz";
    /**
     * API 14 : 小测关联直播间
     */
    public static final String API_14_QUIZ_ASSIGN_ROOM_PAPER = "/openapi/quiz/assignRoomPaper";
    /**
     * API 15 : 查看教室小测
     */
    public static final String API_15_QUIZ_GET_ROOM_QUIZ_LIST = "/openapi/quiz/getRoomQuizList";
    /**
     * API 16 : 删除教室小测
     */
    public static final String API_16_QUIZ_BATCH_DELETE_ROOM_PAPER = "/openapi/quiz/batchDeleteRoomPaper";
    /**
     * API 17 : 查看教室公告
     */
    public static final String API_17_NOTICE_GET_ROOM_NOTICE_LIST = "/openapi/notice/getRoomNoticeList";
    /**
     * API 18 : 绑定教室公告
     */
    public static final String API_18_NOTICE_ASSIGN_ROOM_NOTICE = "/openapi/notice/assignRoomNotice";
    /**
     * API 19 : 删除教室公告
     */
    public static final String API_19_NOTICE_BATCH_DELETE_ROOM_NOTICE = "/openapi/notice/batchDeleteRoomNotice";
    /**
     * API 20 : 修改红包最大个数限制
     */
    public static final String API_20_LIVE_SETTING_SET_MAX_RED_PACKAGE_COUNT = "/openapi/live_setting/setMaxRedPackageCount";
    /**
     * API 21 : 获取红包最大个数限制
     */
    public static final String API_21_LIVE_SETTING_GET_MAX_RED_PACKAGE_COUNT = "/openapi/live_setting/getMaxRedPackageCount";
    /**
     * API 22 : 设置点播软水印配置
     */
    public static final String API_22_LIVE_SETTING_SET_VIDEO_WATERMARK = "/openapi/live_setting/setVideoWatermark";
    /**
     * API 23 : 获取点播软水印配置
     */
    public static final String API_23_LIVE_SETTING_GET_VIDEO_WATERMARK = "/openapi/live_setting/getVideoWatermark";

    ///// 免审词 /////
    // https://ewiki.baijiashilian.com/%E7%99%BE%E5%AE%B6%E4%BA%91/%E7%AE%A1%E7%90%86%E5%90%8E%E5%8F%B0/%E5%85%8D%E5%AE%A1%E8%AF%8Dopenapi.md

    /**
     * 获取免审词列表
     */
    public static final String API_X_LIVE_SETTING_GET_CHAT_EXEMPT_WORDS = "/openapi/live_setting/getChatExemptWords";
    /**
     * 添加免审词
     */
    public static final String API_X_LIVE_SETTING_ADD_CHAT_EXEMPT_WORD = "/openapi/live_setting/addChatExemptWord";
    /**
     * 编辑免审词
     */
    public static final String API_X_LIVE_SETTING_EDIT_CHAT_EXEMPT_WORD = "/openapi/live_setting/editChatExemptWord";
    /**
     * 删除免审词
     */
    public static final String API_X_LIVE_SETTING_DELETE_CHAT_EXEMPT_WORD = "/openapi/live_setting/deleteChatExemptWord";
    /**
     * 批量添加免审词
     */
    public static final String API_X_LIVE_SETTING_BATCH_ADD_CHAT_EXEMPT_WORD = "/openapi/live_setting/batchAddChatExemptWord";

    ///// 全局菜单模板 /////

    /**
     * API 1 : 获取全局自定义菜单模版列表
     */
    public static final String API_1_H5_TEMPLATE_GET_TEMPLATE_LIST = "/openapi/h5_template/getTemplateList";
    /**
     * API 2 : 获取全局自定义菜单模版详情
     */
    public static final String API_2_H5_TEMPLATE_GET_TEMPLATE_INFO = "/openapi/h5_template/getTemplateInfo";
    /**
     * API 3 : 创建全局自定义菜单模版
     */
    public static final String API_3_H5_TEMPLATE_CREATE_TEMPLATE = "/openapi/h5_template/createTemplate";
    /**
     * API 4 : 更新全局自定义菜单模版
     */
    public static final String API_4_H5_TEMPLATE_UPDATE_TEMPLATE_INFO = "/openapi/h5_template/updateTemplateInfo";
    /**
     * API 5 : 设置使用全局自定义菜单模版
     */
    public static final String API_5_H5_TEMPLATE_SET_TEMPLATE_STATUS = "/openapi/h5_template/setTemplateStatus";
    /**
     * API 6: 删除全局自定义菜单模版
     */
    public static final String API_6_H5_TEMPLATE_DELETE_TEMPLATE = "/openapi/h5_template/deleteTemplate";
    /**
     * API 7 : 保存全局自定义菜单
     */
    public static final String API_7_H5_TEMPLATE_SAVE_MENU = "/openapi/h5_template/saveMenu";
    /**
     * API 8 : 保存全局自定义菜单顺序
     */
    public static final String API_8_H5_TEMPLATE_SORT_MENU = "/openapi/h5_template/sortMenu";
    /**
     * API 9 : 删除全局自定义菜单
     */
    public static final String API_9_H5_TEMPLATE_DELETE_MENU = "/openapi/h5_template/deleteMenu";
    /**
     * API 10 : 重置全局自定义菜单状态
     */
    public static final String API_10_H5_TEMPLATE_RESET = "/openapi/h5_template/reset";

    ///// 自定义菜单 /////

    /**
     * API 2: 设置房间级别的自定义菜单(最多只能创建 4 个菜单)
     */
    public static final String API_2_LIVE_SETTING_SAVE_LIVE_CUSTOM_MENU = "/openapi/live_setting/saveLiveCustomMenu";
    /**
     * API 3: 保存菜单顺序
     */
    public static final String API_3_LIVE_SETTING_SORT_LIVE_CUSTOM_MENU = "/openapi/live_setting/sortLiveCustomMenu";
    /**
     * API 4: 获取菜单列表
     */
    public static final String API_4_LIVE_SETTING_GET_LIVE_CUSTOM_MENU = "/openapi/live_setting/getLiveCustomMenu";
    /**
     * API 5: 删除菜单
     */
    public static final String API_5_LIVE_SETTING_DELETE_LIVE_CUSTOM_MENU = "/openapi/live_setting/deleteLiveCustomMenu";
    /**
     * API 6: 菜单绑定视频（菜单类型是音视频时，需要给菜单绑定视频）
     */
    public static final String API_6_LIVE_SETTING_BIND_VIDEO_CUSTOM_MENU = "/openapi/live_setting/bindVideoCustomMenu";
    /**
     * API 7: 保存视频顺序
     */
    public static final String API_7_LIVE_SETTING_SORT_VIDEO_CUSTOM_MENU = "/openapi/live_setting/sortVideoCustomMenu";
    /**
     * API 8: 删除视频菜单
     */
    public static final String API_8_LIVE_SETTING_REMOVE_VIDEO_CUSTOM_MENU = "/openapi/live_setting/removeVideoCustomMenu";
    /**
     * API 9: 获取视频菜单列表
     */
    public static final String API_9_LIVE_SETTING_GET_VIDEO_CUSTOM_MENU_LIST = "/openapi/live_setting/getVideoCustomMenuList";
    /**
     * API 10: 更新视频菜单信息
     */
    public static final String API_10_LIVE_SETTING_UPDATE_VIDEO_CUSTOM_MENU = "/openapi/live_setting/updateVideoCustomMenu";
    /**
     * API 11: 批量保存教室级别自定义菜单视频
     */
    public static final String API_11_LIVE_SETTING_SAVE_VIDEO_CUSTOM_MENU = "/openapi/live_setting/saveVideoCustomMenu";
    /**
     * API 12: 批量保存系列
     */
    public static final String API_12_LIVE_SETTING_SAVE_SERIES_CUSTOM_MENU = "/openapi/live_setting/saveSeriesCustomMenu";
    /**
     * API 13: 系列列表
     */
    public static final String API_13_LIVE_SETTING_GET_SERIES_CUSTOM_MENU_LIST = "/openapi/live_setting/getSeriesCustomMenuList";
    /**
     * API 14: 批量删除系列
     */
    public static final String API_13_LIVE_SETTING_DELETE_SERIES_CUSTOM_MENU = "/openapi/live_setting/deleteSeriesCustomMenu";

    ///// 子账号相关API接口文档 /////

    /**
     * API 1 : 查询子账号列表
     */
    public static final String API_1_NEW_SUB_GET_SUB_ACCOUNT_LIST = "/openapi/new_sub/getSubAccountList";
    /**
     * API 2 : 添加子账号
     */
    public static final String API_2_NEW_SUB_ADD_SUB_ACCOUNT = "/openapi/new_sub/addSubAccount";
    /**
     * API 3 : 获取账号信息
     */
    public static final String API_3_NEW_SUB_GET_ACCOUNT_INFO = "/openapi/new_sub/getAccountInfo";
    /**
     * API 4 : 设置直播产品
     */
    public static final String API_4_NEW_SUB_SET_LIVE_ACCOUNT = "/openapi/new_sub/setLiveAccount";
    /**
     * API 5 : 设置点播产品
     */
    public static final String API_5_NEW_SUB_SET_VIDEO_ACCOUNT = "/openapi/new_sub/setVideoAccount";
    /**
     * API 6 : 设置信用额度
     */
    public static final String API_6_NEW_SUB_SET_CREDIT_MONEY = "/openapi/new_sub/setCreditMoney";
    /**
     * API 7 : 停用/启用账号
     */
    public static final String API_7_NEW_SUB_SET_ACCOUNT_STATUS = "/openapi/new_sub/setAccountStatus";
    /**
     * API 8 : 更新子账号信息
     */
    public static final String API_8_NEW_SUB_UPDATE_SUB_ACCOUNT = "/openapi/new_sub/updateSubAccount";
    /**
     * API 9 : 查询子账号消费账单接口
     */
    public static final String API_9_NEW_SUB_GET_PARTNER_BILL_LIST = "/openapi/new_sub/getPartnerBillList";

    ///// 企业直播服务端API接口 /////
    // 企业直播的所有API均可在大班课直播API中找到相同接口

    ///// 大班课直播服务端API接口 /////
    // https://ewiki.baijiashilian.com/%E7%99%BE%E5%AE%B6%E4%BA%91/%E7%99%BE%E5%AE%B6%E4%BA%91%E5%B8%AE%E5%8A%A9%E4%B8%AD%E5%BF%83/%E4%BA%A7%E5%93%81%E6%96%87%E6%A1%A3/%E7%9B%B4%E6%92%AD%E6%8A%80%E6%9C%AF%E6%96%87%E6%A1%A3/%E5%A4%A7%E7%8F%AD%E8%AF%BE%E6%9C%8D%E5%8A%A1%E7%AB%AFAPI%E6%8E%A5%E5%8F%A3%E6%96%87%E6%A1%A3-new.md

    /**
     * API 1 : 获取/重置partner_key
     */
    public static final String API_1_PARTNER_CREATE_KEY = "/openapi/partner/createkey";
    /**
     * API 2 : 创建房间
     */
    public static final String API_2_ROOM_CREATE = "/openapi/room/create";
    /**
     * API 3 : 更新房间信息
     */
    public static final String API_3_ROOM_UPDATE = "/openapi/room/update";
    /**
     * API 4 : 删除房间
     */
    public static final String API_4_ROOM_DELETE = "/openapi/room/delete";
    /**
     * API 5 : 获取房间信息
     */
    public static final String API_5_ROOM_INFO = "/openapi/room/info";
    /**
     * API 6 : 生成用户参加码
     */
    public static final String API_6_ROOM_GET_CODE = "/openapi/room/getcode";
    /**
     * API 7 : 获取用户参加码信息
     */
    public static final String API_7_ROOM_GET_CODE_INFO = "/openapi/room/getCodeInfo";
    /**
     * API 8 : 获取已生成的参加码列表
     */
    public static final String API_8_ROOM_LIST_CODE = "/openapi/room/listcode";
    /**
     * API 9 : 获取房间列表
     */
    public static final String API_9_ROOM_LIST = "/openapi/room/list";
    /**
     * API 10 : 直播课件文档上传
     */
    public static final String API_10_DOC_UPLOAD_DOC = "/openapi/doc/uploadDoc";
    /**
     * API 11 : 关联文档到教室
     */
    public static final String API_11_DOC_BIND_DOC = "/openapi/doc/bindDoc";
    /**
     * API 12 : 获取指定教室内已上传的文档列表
     */
    public static final String API_12_DOC_LIST_DOC = "/openapi/doc/listDoc";
    /**
     * API 13 : 获取账号下上传的所有文档
     */
    public static final String API_13_DOC_LIST_ALL_DOC = "/openapi/doc/listAllDoc";
    /**
     * API 14 : 移除教室内文档
     */
    public static final String API_14_DOC_REMOVE_DOC = "/openapi/doc/removeDoc";
    /**
     * API 15 : 获取直播教室当前上课状态
     */
    public static final String API_15_LIVE_GET_LIVE_STATUS = "/openapi/live/getLiveStatus";
    /**
     * API 16 : 获取老师是否在教室状态
     */
    public static final String API_16_LIVE_GET_TEACHER_ONLINE_STATUS = "/openapi/live/getTeacherOnlineStatus";
    /**
     * API 17 : 获取当前时间教室人数
     */
    public static final String API_17_LIVE_GET_USER_COUNT = "/openapi/live/getUserCount";
    /**
     * API 18 : 导出教室聊天记录
     */
    public static final String API_18_ROOM_DATA_EXPORT_CHAT_MSG = "/openapi/room_data/exportChatMsg";
    /**
     * API 19 : 设置教室公告
     */
    public static final String API_19_LIVE_SET_NOTIFY = "/openapi/live/setNotify";
    /**
     * API 20 : 导出直播教室学员观看记录
     */
    public static final String API_20_ROOM_DATA_EXPORT_LIVE_REPORT = "/openapi/room_data/exportLiveReport";
    /**
     * API 21 : 获取指定日期所有的直播间人次和最高并发量
     */
    public static final String API_21_ROOM_DATA_GET_ALL_ROOM_USER_STAT = "/openapi/room_data/getAllRoomUserStat";
    /**
     * API 22 : 获取指定房间一段时间内的并发量
     */
    public static final String API_22_ROOM_DATA_GET_ROOM_PEAK_USER = "/openapi/room_data/getRoomPeakUser";
    /**
     * API 23 : 获取账号一天中每小时最高并发量
     */
    public static final String API_23_LIVE_ACCOUNT_GET_HOUR_PEAK_USER = "/openapi/live_account/getHourPeakUser";
    /**
     * API 24 : 查询账号一段时间内每天的最高并发量
     */
    public static final String API_24_LIVE_ACCOUNT_GET_DAY_PEAK_USER = "/openapi/live_account/getDayPeakUser";
    /**
     * API 25 : 获取教室聊天文件地址
     */
    public static final String API_25_ROOM_DATA_GET_CHAT_MSG_URL = "/openapi/room_data/getChatMsgUrl";
    /**
     * API 26 : 查询直播账号每天使用的人次/点数（请参考使用最新API 109）
     */
    public static final String API_26_LIVE_ACCOUNT_GET_PARTNER_DAILY_COST = "/openapi/live_account/getPartnerDailyCost";
    /**
     * API 27 : 查询直播账号指定日期中各教室使用的人次
     */
    public static final String API_27_LIVE_ACCOUNT_GET_ALL_ROOM_COST = "/openapi/live_account/getAllRoomCost";
    /**
     * API 28: 获取教室测试试题信息
     */
    public static final String API_28_ROOM_DATA_GET_ROOM_QUIZ = "/openapi/room_data/getRoomQuiz";
    /**
     * API 29 : 获取直播回放测验题目的学员答案信息
     */
    public static final String API_29_ROOM_DATA_GET_QUIZ_USER_ANSWER = "/openapi/room_data/getQuizUserAnswer";
    /**
     * API 30: 获取教室学员签到信息
     */
    public static final String API_30_ROOM_DATA_GET_USER_CHECKIN_INFO = "/openapi/room_data/getUserCheckinInfo";
    /**
     * API 31 : 创建分组直播参加码
     */
    public static final String API_31_ROOM_CREATE_GROUP_LIVE_CODES = "/openapi/room/createGroupLiveCodes";
    /**
     * API 32 : 获取分组直播参加码
     */
    public static final String API_32_ROOM_GET_GROUP_LIVE_CODES = "/openapi/room/getGroupLiveCodes";
    /**
     * API 33 : 获取推流直播的推流地址
     */
    public static final String API_33_ROOM_GET_PUSH_LIVE_URL = "/openapi/room/getPushLiveUrl";
    /**
     * API 34 : 获取教室举手连麦数据
     */
    public static final String API_34_ROOM_DATA_GET_ROOM_RAISE_DATA = "/openapi/room_data/getRoomRaiseData";
    /**
     * API 35 : 发送聊天消息接口
     */
    public static final String API_35_LIVE_SEND_CHAT_MESSAGE = "/openapi/live/sendChatMessage";
    /**
     * API 36 : 获取支持大小班的分组直播小班教室room_id
     */
    public static final String API_36_ROOM_GET_GROUP_SUB_ROOM_ID = "/openapi/room/getGroupSubRoomId";
    /**
     * API 37: 获取推流直播的拉流地址
     */
    public static final String API_37_ROOM_GET_PULL_STREAM_URL = "/openapi/room/getPullStreamUrl";
    /**
     * API 38 : 第三方教室中学生抢红包统计
     */
    public static final String API_38_ROOM_DATA_GET_ROOM_RED_PACKAGE = "/openapi/room_data/getRoomRedPackage";
    /**
     * API 39 : 获取教室抽奖数据
     */
    public static final String API_39_ROOM_DATA_EXPORT_AWARD_STAT = "/openapi/room_data/exportAwardStat";
    /**
     * API 40 : 获取教室问答数据
     */
    public static final String API_40_ROOM_DATA_EXPORT_QA_STAT = "/openapi/room_data/exportQaStat";
    /**
     * API 41 : 获取教室邀请函数据
     */
    public static final String API_41_ROOM_DATA_EXPORT_QUESTIONNAIRE_STAT = "/openapi/room_data/exportQuestionnaireStat";
    /**
     * API 42 : 获取教室答题器数据
     */
    public static final String API_42_ROOM_DATA_EXPORT_ANSWER_STAT = "/openapi/room_data/exportAnswerStat";
    /**
     * API 43 : 生成用户试听参加码
     */
    public static final String API_43_ROOM_GET_AUDITION_CODE = "/openapi/room/getAuditionCode";
    /**
     * API 44 : 停止直播教室的云端录制
     */
    public static final String API_44_LIVE_STOP_CLOUD_RECORD = "/openapi/live/stopCloudRecord";
    /**
     * API 45 : 直播教室的云端录制生成回放
     */
    public static final String API_45_LIVE_TRANS_CLOUD_RECORD = "/openapi/live/transCloudRecord";
    /**
     * API 46 : 直播设置插播回放
     */
    public static final String API_46_ROOM_SET_SPOT_VIDEO = "/openapi/room/setSpotVideo";
    /**
     * API 47 : 获取教室设置的插播回放
     */
    public static final String API_47_ROOM_GET_SPOT_VIDEO = "/openapi/room/getSpotVideo";
    /**
     * API 48 : 直播教室的点赞数据
     */
    public static final String API_48_ROOM_DATA_EXPORT_ROOM_PRAISE_STAT = "/openapi/room_data/exportRoomPraiseStat";
    /**
     * API 49 : 获取教室课后评价数据
     */
    public static final String API_49_ROOM_DATA_GET_EVALUATION_STAT = "/openapi/room_data/getEvaluationStat";
    /**
     * API 50 : 获取课后评价模板列表
     */
    public static final String API_50_EVALUATION_GET_EVALUATION_LIST = "/openapi/evaluation/getEvaluationList";
    /**
     * API 51 : 关联教室模板
     */
    public static final String API_51_EVALUATION_BIND_ROOM_EVALUATION = "/openapi/evaluation/bindRoomEvaluation";
    /**
     * API 52 : 更换教室模板
     */
    public static final String API_52_EVALUATION_UPDATE_ROOM_EVALUATION = "/openapi/evaluation/updateRoomEvaluation";
    /**
     * API 53 : 禁用/启用直播间
     */
    public static final String API_53_ROOM_SWITCH_ROOM_STATUS = "/openapi/room/switchRoomStatus";
    /**
     * API 54 : 获取直播带货点赞或礼物数据
     */
    public static final String API_54_ROOM_DATA_GET_LIVE_SELL_DATA = "/openapi/room_data/getLiveSellData";
    /**
     * API 55 : 查询账号大班课一段时间内拉流总时长(分钟)
     */
    public static final String API_55_LIVE_ACCOUNT_GET_DAY_MEDIA_LENGTH = "/openapi/live_account/getDayMediaLength";
    /**
     * API 56 : 查询指定日期内所有教室的拉流总时长(分钟)
     */
    public static final String API_56_LIVE_ACCOUNT_GET_ALL_ROOM_MEDIA_LENGTH = "/openapi/live_account/getAllRoomMediaLength";
    /**
     * API 57 : 直播带货创建进房记录
     */
    public static final String API_57_ROOM_CREATE_SELL_JOIN_RECORD = "/openapi/room/createSellJoinRecord";
    /**
     * API 58 : 直播带货创建购买记录
     */
    public static final String API_58_ROOM_CREATE_SELL_BUY_RECORD = "/openapi/room/createSellBuyRecord";
    /**
     * API 59: 设置虚拟人数与成员
     */
    public static final String API_59_ROOM_ADJUST_DISPLAY_USER = "/openapi/room/adjustDisplayUser";
    /**
     * API 60 : 创建课后评价模板
     */
    public static final String API_60_EVALUATION_CREATE_ROOM_EVALUATION = "/openapi/evaluation/createRoomEvaluation";
    /**
     * API 61 : 直播音视频课件上传
     */
    public static final String API_61_DOC_UPLOAD_VIDEO_DOC = "/openapi/doc/uploadVideoDoc";
    /**
     * API 62: 教室上课
     */
    public static final String API_62_LIVE_START_CLASS = "/openapi/live/startClass";
    /**
     * API 63: 教室下课
     */
    public static final String API_63_LIVE_STOP_CLASS = "/openapi/live/stopClass";
    /**
     * API 64 : 设置助教权限
     */
    public static final String API_64_LIVE_SET_ASSISTANT_PERMISSION = "/openapi/live/setAssistantPermission";
    /**
     * API 65 : 删除用户参加码
     */
    public static final String API_65_ROOM_DELETE_CODE = "/openapi/room/deleteCode";
    /**
     * API 66 : 获取参加码使用记录
     */
    public static final String API_66_ROOM_DATA_GET_CODE_USAGE_BATCH = "/openapi/room_data/getCodeUsageBatch";
    /**
     * API 67 : 获取专注度列表
     */
    public static final String API_67_LIVE_ACCOUNT_GET_ATTENTION_LIST = "/openapi/live_account/getAttentionList";
    /**
     * API 68 : 关联多个文档到教室
     */
    public static final String API_68_DOC_BIND_ROOM_MULTI = "/openapi/doc/bindRoomMulti";
    /**
     * API 69 : 获取主屏区公告ID
     */
    public static final String API_69_NOTICE_GET_ROLL_NOTICE_LIST = "/openapi/notice/getRollNoticeList";
    /**
     * API 70 : 切换主讲人
     */
    public static final String API_70_LIVE_SWITCH_SPEAKER = "/openapi/live/switchSpeaker";
    /**
     * API 71 : 根据日期获取教室等效分钟数
     */
    public static final String API_71_ROOM_DATA_GET_MEDIA_LENGTH_BY_DATE = "/openapi/room_data/getMediaLengthByDate";
    /**
     * API 72 : 获取大班课奖励数据
     */
    public static final String API_72_ROOM_DATA_GET_AWARD_DATA = "/openapi/room_data/getAwardData";
    /**
     * API 73 : 强制关闭教室
     */
    public static final String API_73_ROOM_ENFORCE_FORBID_ROOM = "/openapi/room/enforceForbidRoom";
    /**
     * API 74:获取设置隔离用户数据
     */
    public static final String API_74_ROOM_DIVIDE_USER_DATA = "/openapi/room/divideUserData";
    /**
     * API 75 : 获取教室内音视频课件
     */
    public static final String API_75_DOC_GET_ROOM_VIDEO_LIST = "/openapi/doc/getRoomVideoList";
    /**
     * API 76 : 创建文件夹
     */
    public static final String API_76_DOC_CREATE_DIRECTORY = "/openapi/doc/createDirectory";
    /**
     * API 77: 获取教室聊天消息审核列表
     */
    public static final String API_77_CHAT_GET_ROOM_CHAT_LIST = "/openapi/chat/getRoomChatList";
    /**
     * API 78 : 批量审核教室内的聊天消息
     */
    public static final String API_78_CHAT_CHECK_CHAT = "/openapi/chat/checkChat";
    /**
     * API 79 : 教室插播视频
     */
    public static final String API_79_ROOM_SET_ROOM_SPOT_LIVE = "/openapi/room/setRoomSpotLive";
    /**
     * API 80 : 清除教室插播视频
     */
    public static final String API_80_ROOM_CLEAR_ROOM_SPOT_LIVE = "/openapi/room/clearRoomSpotLive";
    /**
     * API 81 : 教室点播预热
     */
    public static final String API_81_ROOM_SET_ROOM_VIDEO_ON_DEMAND = "/openapi/room/setRoomVideoOnDemand";
    /**
     * API 82 : 清除教室内的点播预热视频
     */
    public static final String API_82_ROOM_CLEAR_ROOM_VIDEO_ON_DEMAND = "/openapi/room/clearRoomVideoOnDemand";
    /**
     * API 83 : 设置教室观看限制
     */
    public static final String API_83_ROOM_SET_ROOM_WATCH_LIMIT = "/openapi/room/setRoomWatchLimit";
    /**
     * API 85 : 自定义装修封面
     */
    public static final String API_85_VIDEO_SET_CUSTOMER_COVER = "/openapi/video/setCustomerCover";
    /**
     * API 86 : 撤回单条聊天消息接口
     */
    public static final String API_86_LIVE_REVOKE_CHAT_MESSAGE = "/openapi/live/revokeChatMessage";
    /**
     * API 87 : 获取大班课回放打点标记数据接口
     */
    public static final String API_87_PLAYBACK_GET_PLAYBACK_KEY_FRAME_DESC_LIST = "/openapi/playback/getPlaybackKeyFrameDescList";
    /**
     * API 88 : 大班课转播增加转播房间接口
     */
    public static final String API_88_LIVE_SETTING_ADD_BROADCAST_ROOM = "/openapi/live_setting/addBroadcastRoom";
    /**
     * API 89 : 大班课转播房间查询接口
     */
    public static final String API_89_LIVE_SETTING_GET_BROADCAST_ROOM = "/openapi/live_setting/getBroadcastRoom";
    /**
     * API 90 : 大班课转播房间删除接口
     */
    public static final String API_90_LIVE_SETTING_DEL_BROADCAST_ROOM = "/openapi/live_setting/delBroadcastRoom";
    /**
     * API 91 : 大班课开启&关闭转播接口
     */
    public static final String API_91_LIVE_SETTING_TRANSFER_BROADCAST_ROOM = "/openapi/live_setting/transferBroadcastRoom";
    /**
     * API 92 : 批量设置敏感词接口
     */
    public static final String API_92_LIVE_SETTING_ADD_SENSITIVE_WORD_BATCH = "/openapi/live_setting/addSensitiveWordBatch";
    /**
     * API 93 : 导入敏感词接口
     */
    public static final String API_93_LIVE_SETTING_IMPORT_SENSITIVE_WORD = "/openapi/live_setting/importSensitiveWord";
    /**
     * API 94 : 批量删除敏感词接口
     */
    public static final String API_94_LIVE_SETTING_DELETE_SENSITIVE_WORD_BATCH = "/openapi/live_setting/deleteSensitiveWordBatch";
    /**
     * API 95 : 查询敏感词接口
     */
    public static final String API_95_LIVE_SETTING_GET_SENSITIVE_WORD = "/openapi/live_setting/getSensitiveWord";
    /**
     * API 96 : 修改分组直播组名
     */
    public static final String API_96_ROOM_UPDATE_GROUP_NAME = "/openapi/room/updateGroupName";
    /**
     * API 97 : 上传分组直播分组logo
     */
    public static final String API_97_ROOM_SET_LIVE_ROOM_GROUP_LOGO = "/openapi/room/setLiveRoomGroupLogo";
    /**
     * API 98 : 获取已上传分组直播分组logo地址
     */
    public static final String API_98_ROOM_GET_LIVE_ROOM_GROUP_LOGO = "/openapi/room/getLiveRoomGroupLogo";
    /**
     * API 99 : 多平台推流地址增加接口
     */
    public static final String API_99_LIVE_SETTING_ADD_MULTI_PLATFORM_STREAMING = "/openapi/live_setting/addMultiPlatformStreaming";
    /**
     * API 100 : 多平台推流地址删除接口
     */
    public static final String API_100_LIVE_SETTING_DELETE_MULTI_PLATFORM_STREAMING = "/openapi/live_setting/deleteMultiPlatformStreaming";
    /**
     * API 101 : 多平台推流地址编辑接口
     */
    public static final String API_101_LIVE_SETTING_EDIT_MULTI_PLATFORM_STREAMING = "/openapi/live_setting/editMultiPlatformStreaming";
    /**
     * API 102 : 多平台推流地址查询接口
     */
    public static final String API_102_LIVE_SETTING_GET_MULTI_PLATFORM_STREAMING_LIST = "/openapi/live_setting/getMultiPlatformStreamingList";
    /**
     * API 103 : 获取账户收支明细
     */
    public static final String API_103_PAY_GET_REVENUE_LIST = "/openapi/pay/getRevenueList";
    /**
     * API 104 : 获取直播间点赞热度数据
     */
    public static final String API_104_ROOM_DATA_GET_ROOM_DATE_NEW_PRAISE_COUNT = "/openapi/room_data/getRoomDateNewPraiseCount";
    /**
     * API 105 : 获取直播间数据报表
     */
    public static final String API_105_ROOM_DATA_GET_LIVE_DATA_REPORT = "/openapi/room_data/getLiveDataReport";
    /**
     * API 106 : 通过url上传文件
     */
    public static final String API_106_DOC_UPLOAD_WITH_URL = "/openapi/doc/uploadWithUrl";
    /**
     * API 107 : 通过文件夹关联课件到教室
     */
    public static final String API_107_DOC_BIND_ROOM_DOC_WITH_FINDERS = "/openapi/doc/bindRoomDocWithFinders";
    /**
     * API 108 : 删除指定文件夹及文件夹中的文件
     */
    public static final String API_108_DOC_DELETE_DOC_FINDER = "/openapi/doc/deleteDocFinder";
    /**
     * API 109 : 获取账号直播人次统计数据
     */
    public static final String API_109_LIVE_ACCOUNT_GET_DATE_USER_COUNT = "/openapi/live_account/getDateUserCount";
    /**
     * API 110 : 获取教室回放录制状态接口
     */
    public static final String API_110_LIVE_GET_CLOUD_RECORD_STATUS = "/openapi/live/getCloudRecordStatus";
    /**
     * API 111 : 获取教室个人积分记录
     */
    public static final String API_111_ROOM_SCORE_GET_USER_SCORE_LIST = "/openapi/room_score/getUserScoreList";
    /**
     * API 112 : 获取教室学员签到次数列表
     */
    public static final String API_112_ROOM_DATA_GET_CHECKIN_SESSION_LIST = "/openapi/room_data/getCheckinSessionList";
    /**
     * API 113 : 获取教室学员单次签到列表
     */
    public static final String API_113_ROOM_DATA_GET_CHECKIN_SESSION_USER_LIST = "/openapi/room_data/getCheckinSessionUserList";
    /**
     * API 114 : 获取教室答题器题目列表
     */
    public static final String API_114_ROOM_DATA_GET_ROOM_QUESTION_LIST = "/openapi/room_data/getRoomQuestionList";
    /**
     * API 115: 获取教室学员单次答题器答案列表
     */
    public static final String API_115_ROOM_DATA_GET_ROOM_QUESTION_ANSWER_LIST = "/openapi/room_data/getRoomQuestionAnswerList";
    /**
     * API 116 : 按角色获取分组直播参加码接口
     */
    public static final String API_116_ROOM_GET_GROUP_LIVE_CODES_BY_USER_ROLE = "/openapi/room/getGroupLiveCodesByUserRole";
    /**
     * API 117 : 学生昵称支持客户自定义上传
     */
    public static final String API_117_ROOM_SET_RANDOM_NICKNAME = "/openapi/room/setRandomNickname";

    /**
     * 回放分类列表
     */
    public static final String API_X_PLAYBACK_GET_CATEGORY_LIST = "/openapi/playback/getCategoryList";

    /**
     * 添加回放分类
     */
    public static final String API_X_PLAYBACK_GET_CATEGORY_ADD = "/openapi/playback/addCategory";

    /**
     * 编辑回放分类
     */
    public static final String API_X_PLAYBACK_GET_CATEGORY_EDIT = "/openapi/playback/editCategory";

    /**
     * 删除回放分类
     */
    public static final String API_X_PLAYBACK_GET_CATEGORY_DELETE = "/openapi/playback/deleteCategory";


    /**
     * 关联回放
     */
    public static final String API_X_PLAYBACK_GET_CATEGORY_RELATION = "/openapi/playback/addCategoryRelation";


    ///// 设置直播上下课回调地址 /////

    /**
     * 设置直播上下课事件回调地址
     */
    public static final String API_X_LIVE_ACCOUNT_SET_CLASS_CALLBACK_URL = "/openapi/live_account/setClassCallbackUrl";
    /**
     * 查询直播上下课回调地址
     */
    public static final String API_X_LIVE_ACCOUNT_GET_CLASS_CALLBACK_URL = "/openapi/live_account/getClassCallbackUrl";

    ///// 后台用户管理与白名单 /////

    /**
     * API 1 : 添加用户
     */
    public static final String API_1_USER_ADD_USER = "/openapi/user/addUser";
    /**
     * API 2 : 获取用户列表
     */
    public static final String API_2_USER_GET_USER_LIST = "/openapi/user/getUserList";
    /**
     * API 3 : 批量删除用户
     */
    public static final String API_3_USER_BATCH_REMOVE_USER = "/openapi/user/batchRemoveUser";
    /**
     * API 4 : 给教室批量关联学员
     */
    public static final String API_4_USER_CLASS_BIND_STUDENT_BATCH = "/openapi/user/classBindStudentBatch";
    /**
     * API 5 : 给教室关联老师/助教
     */
    public static final String API_5_USER_CLASS_BIND_TEACHER = "/openapi/user/classBindTeacher";
    /**
     * API 6 : 获取教室关联的学员列表
     */
    public static final String API_6_USER_GET_CLASS_STUDENT = "/openapi/user/getClassStudent";
    /**
     * API 7 : 获取教室关联的老师和助教
     */
    public static final String API_7_USER_GET_CLASS_TEACHER = "/openapi/user/getClassTeacher";
    /**
     * API 8 : 批量移除教室内关联的学员
     */
    public static final String API_8_USER_CLASS_REMOVE_STUDENT_BATCH = "/openapi/user/classRemoveStudentBatch";
    /**
     * API 9 : 移除教室内关联的老师/助教
     */
    public static final String API_9_USER_CLASS_REMOVE_TEACHER = "/openapi/user/classRemoveTeacher";
    /**
     * API 10 : 通过手机号获取用户
     */
    public static final String API_10_USER_GET_USER_BY_PHONE_NUMBER = "/openapi/user/getUserByPhoneNumber";
    /**
     * API 11 : 修改用户信息
     */
    public static final String API_11_USER_EDIT_USER = "/openapi/user/editUser";
    /**
     * API 12 : 修改教室内关联助教水军角色为普通助教
     */
    public static final String API_12_USER_CLASS_RELATION_FAKE_ASSISTANT = "/openapi/user/classRelationFakeAssistant";
    /**
     * API 13 : 班级列表
     */
    public static final String API_13_USER_LIST_GROUP = "/openapi/user/listGroup";

    ///// 直播带货商品管理接口 /////

    /**
     * API 1 : 上传图片素材
     */
    public static final String API_1_MEDIA_UPLOAD_IMG = "/openapi/media/uploadImg";
    /**
     * API 2 : 直播带货模板的教室添加商品
     */
    public static final String API_2_CLASS_GOODS_ADD_GOODS = "/openapi/class_goods/addGoods";
    /**
     * API 3 : 直播带货模板的教室编辑商品
     */
    public static final String API_3_CLASS_GOODS_EDIT_GOODS = "/openapi/class_goods/editGoods";
    /**
     * API 4 : 直播带货模板的教室删除商品
     */
    public static final String API_4_CLASS_GOODS_DELETE_GOODS = "/openapi/class_goods/deleteGoods";
    /**
     * API 5 : 删除素材
     */
    public static final String API_5_MEDIA_DEL_MEDIA = "/openapi/media/delMedia";
    /**
     * API 6 : 获取图片列表
     */
    public static final String API_6_MEDIA_GET_IMG_LIST = "/openapi/media/getImgList";

    ///// 小班课直播服务端API接口 /////
    // 小班课直播 API 1 ~ 24 均可在大班课API中找到相同接口。
    /**
     * API 25 : 获取小班课账号每天消费记录
     */
    public static final String API_25_SMALL_COURSE_GET_DAILY_COST = "/openapi/small_course/getDailyCost";
    /**
     * API 26 : 获取小班课指定日期各教室消费记录
     */
    public static final String API_26_SMALL_COURSE_GET_ROOM_COST = "/openapi/small_course/getRoomCost";
    /**
     * API 27 : 获取小班课指定教室各学员消费详情
     */
    public static final String API_27_SMALL_COURSE_GET_USER_COST = "/openapi/small_course/getUserCost";
    // 小班课直播 API 28 ~ 32 均可在大班课直播API中找到相同接口
    /**
     * AIP 33 : 获取表情报告截取的表情图片
     */
    public static final String API_X_ROOM_DATA_GET_EXP_REPORT_LIST = "/openapi/room_data/getExpReportList";
    /**
     * API 35 : 使用url上传h5课件
     */
    public static final String API_35_DOC_UPLOAD_H5_BY_URL = "/openapi/doc/uploadH5ByUrl";
    /**
     * API 36 : 获取教室设备自检的信息
     */
    public static final String API_36_ROOM_DATA_GET_USER_DEVICE_INFO = "/openapi/room_data/getUserDeviceInfo";
    /**
     * API 37 : 按天获取课后评价数据
     */
    public static final String API_37_ROOM_DATA_GET_EVALUATION_LIST = "/openapi/room_data/getEvaluationList";
    /**
     * API 38 : 关联文档到多个教室
     */
    public static final String API_38_DOC_BIND_DOC_MULTI = "/openapi/doc/bindDocMulti";
    /**
     * API 40 : 监课接口
     */
    public static final String API_40_ROOM_DATA_GET_MONITOR_DATA = "/openapi/room_data/getMonitorData";
    /**
     * API 41 : 批量添加插播
     */
    public static final String API_41_ROOM_BATCH_ADD_SPOT_VIDEO = "/openapi/room/batchAddSpotVideo";
    /**
     * API 43 : 批量移除小班课中的插播
     */
    public static final String API_43_ROOM_BATCH_REMOVE_SPOT_VIDEO = "/openapi/room/batchRemoveSpotVideo";
    /**
     * API 44 : 获取小班课学情报告数据
     */
    public static final String API_44_ROOM_DATA_GET_STUDY_REPORT = "/openapi/room_data/getStudyReport";
    /**
     * API 45 : 小班课课件关联增加课件预览接口
     */
    public static final String API_45_DOC_GET_PREVIEW_INFO = "/openapi/doc/getPreviewInfo";
    /**
     * API 49 : 通过文档ID获取文档课件预览接口
     */
    public static final String API_49_DOC_GET_PREVIEW_INFO_BY_FID = "/openapi/doc/getPreviewInfoByFid";
    /**
     * API 50 : 获取账号下已上传的所有音视频课件接口
     */
    public static final String API_50_DOC_LIST_ALL_VIDEO_DOC = "/openapi/doc/listAllVideoDoc";
    /**
     * API 51 : 重命名课件接口
     */
    public static final String API_51_DOC_UPDATE_DOC = "/openapi/doc/updateDoc";
    /**
     * API 52 : 删除课件接口
     */
    public static final String API_52_DOC_DESTROY_DOC = "/openapi/doc/destroyDoc";
    /**
     * API 53 : 关联音视频文档到教室接口
     */
    public static final String API_53_DOC_BIND_VIDEO_DOC = "/openapi/doc/bindVideoDoc";
    /**
     * API 55 : 获取小班课录制费用
     */
    public static final String API_55_SMALL_COURSE_GET_PLAYBACK_DAILY_COST = "/openapi/small_course/getPlaybackDailyCost";
    /**
     * API 57 : 获取小班课黑板保存数据
     */
    public static final String API_57_ROOM_DATA_GET_DOWNLOAD_BLACKBOARD_IMG = "/openapi/room_data/getDownloadBlackboardImg";

    ///// 点播服务端API接口文档 /////

    /**
     * API-2: 获取视频上传地址
     */
    public static final String API_2_VIDEO_GET_UPLOAD_URL = "/openapi/video/getUploadUrl";
    /**
     * API-4: 获取断点续传地址
     */
    public static final String API_4_VIDEO_GET_RESUME_UPLOAD_URL = "/openapi/video/getResumeUploadUrl";
    /**
     * API-5: 查询视频转码状态
     */
    public static final String API_5_VIDEO_GET_STATUS = "/openapi/video/getStatus";
    /**
     * API-6: 获取指定ID视频信息
     */
    public static final String API_6_VIDEO_GET_INFO = "/openapi/video/getInfo";
    /**
     * API-7: 获取指定ID视频截图
     */
    public static final String API_7_VIDEO_GET_IMAGE = "/openapi/video/getImage";
    /**
     * API-8: 清除指定清晰度的转码文件
     */
    public static final String API_8_VIDEO_REMOVE_DEFINITION = "/openapi/video/removeDefinition";
    /**
     * API-9: 删除点播源文件
     */
    public static final String API_9_VIDEO_DELETE_ORIGIN_VIDEO = "/openapi/video/deleteOriginVideo";
    /**
     * API-10: 更新视频信息
     */
    public static final String API_10_VIDEO_UPDATE = "/openapi/video/update";
    /**
     * API-11: 删除视频
     */
    public static final String API_11_VIDEO_DELETE = "/openapi/video/delete";
    /**
     * API-12: 获取所有分类
     */
    public static final String API_12_VIDEO_GET_CATEGORY_LIST = "/openapi/video/getCategoryList";
    /**
     * API-13: 获取指定ID分类信息
     */
    public static final String API_13_VIDEO_GET_CATEGORY_INFO = "/openapi/video/getCategoryInfo";
    /**
     * API-14: 添加分类
     */
    public static final String API_14_VIDEO_ADD_CATEGORY = "/openapi/video/addCategory";
    /**
     * API-15: 删除分类
     */
    public static final String API_15_VIDEO_DELETE_CATEGORY = "/openapi/video/deleteCategory";
    /**
     * API-16: 获取指定分类下的视频
     */
    public static final String API_16_VIDEO_GET_CATEGORY_VIDEO = "/openapi/video/getCategoryVideo";
    /**
     * API-17: 设置视频分类
     */
    public static final String API_17_VIDEO_SET_VIDEO_CATEGORY = "/openapi/video/setVideoCategory";
    /**
     * API-18: 获取播放器token
     */
    public static final String API_18_VIDEO_GET_PLAYER_TOKEN = "/openapi/video/getPlayerToken";
    /**
     * API-19: 批量获取播放器token
     */
    public static final String API_19_VIDEO_GET_PLAYER_TOKEN_BATCH = "/openapi/video/getPlayerTokenBatch";
    /**
     * API-20: 获取账号套餐使用量
     */
    public static final String API_20_VIDEO_ACCOUNT_GET_ACCOUNT_INFO = "/openapi/video_account/getAccountInfo";
    /**
     * API-21: 查询指定ID视频一段时间内使用的流量
     */
    public static final String API_21_VIDEO_DATA_GET_USED_FLOW = "/openapi/video_data/getUsedFlow";
    /**
     * API-22: 查询账号一段时间内使用的流量
     */
    public static final String API_22_VIDEO_ACCOUNT_GET_USED_FLOW = "/openapi/video_account/getUsedFlow";
    /**
     * API-23: 获取转码后视频地址
     */
    public static final String API_23_VIDEO_GET_URL = "/openapi/video/getUrl";
    /**
     * API-24: 获取指定视频观看记录
     */
    public static final String API_24_VIDEO_DATA_GET_VIDEO_PLAY_RECORD = "/openapi/video_data/getVideoPlayRecord";
    /**
     * API-25: 获取账号所有视频观看记录
     */
    public static final String API_25_VIDEO_DATA_EXPORT_VIDEO_REPORT_BATCH = "/openapi/video_data/exportVideoReportBatch";
    /**
     * API 26: 设置视频发布状态
     */
    public static final String API_26_VIDEO_SET_PUBLISH_STATUS = "/openapi/video/setPublishStatus";
    /**
     * API-27: 获取视频分享地址
     */
    public static final String API_27_VIDEO_GET_SHARE_URL = "/openapi/video/getShareUrl";
    /**
     * API-28: 获取播放量排行
     */
    public static final String API_28_VIDEO_DATA_GET_VIDEO_PLAY_COUNT_RANK = "/openapi/video_data/getVideoPlayCountRank";
    /**
     * API-29: 获取指定ID视频播放量
     */
    public static final String API_29_VIDEO_DATA_GET_VIDEO_DAILY_PLAY_COUNT = "/openapi/video_data/getVideoDailyPlayCount";
    /**
     * API-30: 获取账号视频播放量
     */
    public static final String API_30_VIDEO_DATA_GET_PARTNER_DAILY_PLAY_COUNT = "/openapi/video_data/getPartnerDailyPlayCount";
    /**
     * API-31: 获取点播视频列表
     */
    public static final String API_31_VIDEO_GET_VIDEO_LIST = "/openapi/video/getVideoList";
    /**
     * API-32: 上传点播字幕文件
     */
    public static final String API_32_VIDEO_UPLOAD_SUBTITLE = "/openapi/video/uploadSubtitle";
    /**
     * 上传字幕链接
     */
    public static final String API_X_VIDEO_UPLOAD_SUBTITLE_BY_URL = "/openapi/video/uploadSubtitleByUrl";
    /**
     * API-33: 获取字幕文件列表
     */
    public static final String API_33_VIDEO_GET_SUBTITLE_LIST = "/openapi/video/getSubtitleList";
    /**
     * API-34: 更新点播字幕信息
     */
    public static final String API_34_VIDEO_UPDATE_SUBTITLE = "/openapi/video/updateSubtitle";
    /**
     * API-35: 设置字幕为默认字幕
     */
    public static final String API_35_VIDEO_SET_DEFAULT_SUBTITLE = "/openapi/video/setDefaultSubtitle";
    /**
     * API-36: 删除字幕文件
     */
    public static final String API_36_VIDEO_DELETE_SUBTITLE = "/openapi/video/deleteSubtitle";
    /**
     * API-37: 查询账号内一段时间内的流量并返回流量消耗明细
     */
    public static final String API_37_VIDEO_ACCOUNT_GET_USED_FLOW_DETAIL = "/openapi/video_account/getUsedFlowDetail";
    /**
     * API-38: 查询账号产品线下一天的视频流量使用明细
     */
    public static final String API_38_VIDEO_DATA_GET_USED_FLOW_DETAIL = "/openapi/video_data/getUsedFlowDetail";
    /**
     * API-39: 获取账号存储空间和流量使用统计
     */
    public static final String API_39_VIDEO_ACCOUNT_GET_STORGE_AND_FLOW_INFO = "/openapi/video_account/getStorgeAndFlowInfo";
    /**
     * API-41:设置滚动公告
     */
    public static final String API_41_NOTICE_SET_ROLL_NOTICE = "/openapi/notice/setRollNotice";
    /**
     * API-42:视频批量绑定公告
     */
    public static final String API_42_NOTICE_BATCH_SET_VIDEO_NOTICE = "/openapi/notice/batchSetVideoNotice";
    /**
     * API-43:获取点播弹题
     */
    public static final String API_43_VIDEO_QUIZ_GETLIST = "/openapi/video_quiz/getlist";
    /**
     * API-44: 编辑点播弹题接口
     */
    public static final String API_44_VIDEO_QUIZ_SAVE_QUES = "/openapi/video_quiz/saveQues";
    /**
     * API-45:删除点播弹题
     */
    public static final String API_45_VIDEO_QUIZ_DEL_QUES = "/openapi/video_quiz/delQues";
    /**
     * API-46:批量设置视频分类
     */
    public static final String API_46_VIDEO_SET_VIDEO_CATEGORY_BATCH = "/openapi/video/setVideoCategoryBatch";
    /**
     * API-47:设置三分屏信息
     */
    public static final String API_47_VIDEO_SET_TRIPARTITE_SCREEN = "/openapi/video/setTripartiteScreen";
    /**
     * API-48:点播设置打点接口
     */
    public static final String API_48_VIDEO_SET_VIDEO_KEY_FRAME = "/openapi/video/setVideoKeyFrame";
    /**
     * API-49:获取打点数据列表
     */
    public static final String API_49_VIDEO_LIST_VIDEO_KEY_FRAME = "/openapi/video/listVideoKeyFrame";
    /**
     * API-50:设置点播打点跳转功能接口
     */
    public static final String API_50_VIDEO_SET_VIDEO_JUMP = "/openapi/video/setVideoJump";
    /**
     * API-51:获取点播评论token接口
     */
    public static final String API_51_VIDEO_GET_LOGIN_TOKEN = "/openapi/video/getLoginToken";
    /**
     * API-52:获取点播已关联白名单班级列表接口
     */
    public static final String API_52_VIDEO_LIST_VIDEO_GROUP = "/openapi/video/listVideoGroup";
    /**
     * API-53:班级关联点播白名单接口
     */
    public static final String API_53_VIDEO_ADD_VIDEO_GROUP = "/openapi/video/addVideoGroup";
    /**
     * API-54:移除点播白名单已绑定班级
     */
    public static final String API_54_VIDEO_REMOVE_VIDEO_GROUP = "/openapi/video/removeVideoGroup";
    /**
     * API-55:获取点播已关联白名单用户列表接口
     */
    public static final String API_55_VIDEO_GET_VIDEO_WHITE_LIST = "/openapi/video/getVideoWhiteList";
    /**
     * API-56:学员关联点播白名单接口
     */
    public static final String API_56_VIDEO_ADD_VIDEO_WHITE_LIST = "/openapi/video/addVideoWhiteList";
    /**
     * API-57:移除点播白名单学员接口
     */
    public static final String API_57_VIDEO_DELETE_VIDEO_WHITE_LIST = "/openapi/video/deleteVideoWhiteList";
    /**
     * API-58:获取弹题的学生答题数据
     */
    public static final String API_58_VIDEO_QUIZ_GET_ANSWER_INFO = "/openapi/video_quiz/getAnswerInfo";
    /**
     * 视频二次转码
     */
    public static final String API_X_VIDEO_TRANSCODE_AGAIN = "/openapi/video/transcodeAgain";
    /**
     * 设置转码回调地址（点播和回放）
     */
    public static final String API_X_VIDEO_ACCOUNT_SET_TRANSCODE_CALLBACK_URL = "/openapi/video_account/setTranscodeCallbackUrl";
    /**
     * 查询转码回调地址（点播和回放）
     */
    public static final String API_X_VIDEO_ACCOUNT_GET_TRANSCODE_CALLBACK_URL = "/openapi/video_account/getTranscodeCallbackUrl";

    /**
     * 获取点播播放地址
     */
    public static final String API_VIDEO_GET_PLAY_URL = "/openapi/video/getPlayerUrl";

    ///// 回放服务端API文档 /////

    /**
     * API 1 : 查询直播回放信息
     */
    public static final String API_1_PLAYBACK_GET_BASIC_INFO = "/openapi/playback/getBasicInfo";
    /**
     * API 2 : 获取回放列表
     */
    public static final String API_2_PLAYBACK_GET_LIST = "/openapi/playback/getList";
    /**
     * API 3: 获取回放token
     */
    public static final String API_3_PLAYBACK_GET_PLAYER_TOKEN = "/openapi/playback/getPlayerToken";
    /**
     * API 4: 批量获取回放token
     */
    public static final String API_4_PLAYBACK_GET_PLAYER_TOKEN_BATCH = "/openapi/playback/getPlayerTokenBatch";
    /**
     * API 5: 获取长期房间云录制的序列号列表
     */
    public static final String API_5_PLAYBACK_GET_SESSION_LIST = "/openapi/playback/getSessionList";
    /**
     * API 6: 获取指定回放视频观看记录
     */
    public static final String API_6_VIDEO_DATA_GET_PLAYBACK_PLAY_RECORD = "/openapi/video_data/getPlaybackPlayRecord";
    /**
     * API 7: 设置回放发布状态
     */
    public static final String API_7_PLAYBACK_SET_PUBLISH_STATUS = "/openapi/playback/setPublishStatus";
    /**
     * API 8 : 删除回放
     */
    public static final String API_8_PLAYBACK_DELETE = "/openapi/playback/delete";
    /**
     * API 9 : 更新回放信息
     */
    public static final String API_9_PLAYBACK_UPDATE = "/openapi/playback/update";
    /**
     * API 10 : 获取裁剪回放列表
     */
    public static final String API_10_PLAYBACK_GET_CROP_LIST = "/openapi/playback/getCropList";
    /**
     * API 11 : 设置回放主版本
     */
    public static final String API_11_PLAYBACK_SET_MAIN_VERSION = "/openapi/playback/setMainVersion";
    /**
     * API 12 : 获取ppt转成的pdf的路径列表
     */
    public static final String API_12_PLAYBACK_GET_PLAYBACK_PPT_URL_LIST = "/openapi/playback/getPlaybackPptUrlList";
    /**
     * API 13 : 获取ppt转成的pdf具体路径
     */
    public static final String API_13_PLAYBACK_GET_PLAYBACK_PPT_URL = "/openapi/playback/getPlaybackPptUrl";
    /**
     * API 14 : 替换回放
     */
    public static final String API_14_PLAYBACK_REPLACE_PLAYBACK = "/openapi/playback/replacePlayback";
    /**
     * API 15 : 点播替换回放
     */
    public static final String API_15_PLAYBACK_REPLACE_PLAYBACK_BY_VIDEO = "/openapi/playback/replacePlaybackByVideo";
    /**
     * API 16 : 回放录制纯视频
     */
    public static final String API_16_PLAYBACK_GENERATE_PURE_VIDEO = "/openapi/playback/generatePureVideo";
    /**
     * API 17 : 回放记录分段裁剪
     */
    public static final String API_17_PLAYBACK_CROP_VIDEO = "/openapi/playback/cropVideo";
    /**
     * API 18: 查询直播间录制节点数据
     */
    public static final String API_18_PLAYBACK_GET_RECORD_OPERATION_TIME = "/openapi/playback/getRecordOperationTime";
    /**
     * API 19 : 回放录制纯视频（针对教室全部回放）
     */
    public static final String API_19_PLAYBACK_GENERATE_CLASS_PURE_VIDEO = "/openapi/playback/generateClassPureVideo";
    /**
     * API 20 : 获取回放转纯视频下载地址
     */
    public static final String API_20_PLAYBACK_GET_RECORD_VIDEO_URL = "/openapi/playback/getRecordVideoUrl";
    /**
     * API 22: 删除回放指定聊天数据接口
     */
    public static final String API_22_PLAYBACK_DELETE_PLAYBACK_CHAT = "/openapi/playback/deletePlaybackChat";
    /**
     * API 23: 单个回放白名单增加学员
     */
    public static final String API_23_USER_PLAYBACK_BIND_STUDENT_BATCH = "/openapi/user/playbackBindStudentBatch";
    /**
     * API 24: 单个回放删除白名单学员
     */
    public static final String API_24_USER_PLAYBACK_REMOVE_STUDENT_BATCH = "/openapi/user/playbackRemoveStudentBatch";
    /**
     * API 25: 查询单个回放绑定白名单
     */
    public static final String API_25_USER_GET_PLAYBACK_STUDENT = "/openapi/user/getPlaybackStudent";
    /**
     * API 26: 增加房间级别回放白名单学员
     */
    public static final String API_26_USER_ROOM_PLAYBACK_BIND_STUDENT_BATCH = "/openapi/user/roomPlaybackBindStudentBatch";
    /**
     * API 27: 查询房间回放白名单学员
     */
    public static final String API_27_USER_GET_ROOM_PLAYBACK_STUDENT = "/openapi/user/getRoomPlaybackStudent";
    /**
     * API 28: 删除房间回放白名单学员
     */
    public static final String API_28_USER_ROOM_PLAYBACK_REMOVE_STUDENT_BATCH = "/openapi/user/roomPlaybackRemoveStudentBatch";
    /**
     * API 29: 获取回放有效期数据接口
     */
    public static final String API_29_PLAYBACK_GET_PLAYBACK_VALID_DAY = "/openapi/playback/getPlaybackValidDay";
    /**
     * API 30: 设置回放有效期数据接口
     */
    public static final String API_30_PLAYBACK_SET_PLAYBACK_VALID_DAY = "/openapi/playback/setPlaybackValidDay";
    /**
     * API 31: 回放课件生成接口
     */
    public static final String API_31_PLAYBACK_START_PLAYBACK_PDF_TASK = "/openapi/playback/startPlaybackPdfTask";
    /**
     * API 32: 回放打点设置接口
     */
    public static final String API_32_PLAYBACK_SAVE_PLAYBACK_KEY_FRAME_DESC = "/openapi/playback/savePlaybackKeyFrameDesc";
    /**
     * API 33:获取回放 limited_token
     */
    public static final String API_33_PLAYBACK_GET_LIMITED_PLAYER_TOKEN = "/openapi/playback/getLimitedPlayerToken";
    /**
     * API 34: 获取回放课件数据接口
     */
    public static final String API_34_PLAYBACK_GET_PPT_PAGE_INFO = "/openapi/playback/getPptPageInfo";
    /**
     * API 35: 批量裁剪生成多段回放
     */
    public static final String API_35_PLAYBACK_BATCH_CROP_VIDEO = "/openapi/playback/batchCropVideo";

    ///// 双师设备管理&排课API接口文档 /////

    /**
     * API-1: 添加校区
     */
    public static final String API_1_DOUBLE_TEACHER_ADD_ZONE = "/openapi/double_teacher/addZone";
    /**
     * API-2: 获取校区列表
     */
    public static final String API_2_DOUBLE_TEACHER_LIST_ZONE = "/openapi/double_teacher/listZone";
    /**
     * API-3: 更新校区
     */
    public static final String API_3_DOUBLE_TEACHER_UPDATE_ZONE = "/openapi/double_teacher/updateZone";
    /**
     * API-4: 删除校区
     */
    public static final String API_4_DOUBLE_TEACHER_DELETE_ZONE = "/openapi/double_teacher/deleteZone";
    /**
     * API-5: 获取设备列表
     */
    public static final String API_5_DOUBLE_TEACHER_LIST_DEVICE = "/openapi/double_teacher/listDevice";
    /**
     * API-6: 更新双师设备信息
     */
    public static final String API_6_DOUBLE_TEACHER_UPDATE_DEVICE_INFO = "/openapi/double_teacher/updateDeviceInfo";
    /**
     * API-7: 给课程绑定设备
     */
    public static final String API_7_DOUBLE_TEACHER_BIND_DEVICE = "/openapi/double_teacher/bindDevice";
    /**
     * API-8: 批量给课程绑定听课设备
     */
    public static final String API_8_DOUBLE_TEACHER_BIND_STUDENT_DEVICE_BATCH = "/openapi/double_teacher/bindStudentDeviceBatch";
    /**
     * API-9: 设备绑定多个课程
     */
    public static final String API_9_DOUBLE_TEACHER_BIND_ROOM_BATCH = "/openapi/double_teacher/bindRoomBatch";
    /**
     * API-10: 解除课程与设备关联
     */
    public static final String API_10_DOUBLE_TEACHER_UNBIND_DEVICE = "/openapi/double_teacher/unbindDevice";
    /**
     * API-11: 批量解除课程与设备关联
     */
    public static final String API_11_DOUBLE_TEACHER_UNBIND_DEVICE_BATCH = "/openapi/double_teacher/unbindDeviceBatch";
    /**
     * API-12: 更新课程绑定的全部学生端
     */
    public static final String API_12_DOUBLE_TEACHER_SET_ALL_STUDENT_DEVICE = "/openapi/double_teacher/setAllStudentDevice";
    /**
     * API-13: 获取直播房间关联的设备信息
     */
    public static final String API_13_DOUBLE_TEACHER_GET_ROOM_DEVICE_INFO = "/openapi/double_teacher/getRoomDeviceInfo";
    /**
     * API-14: 获取设备最近一次激活记录
     */
    public static final String API_14_DOUBLE_TEACHER_GET_RECENT_ACTIVATE_RECORD = "/openapi/double_teacher/getRecentActivateRecord";
    /**
     * API-15: 获取加盟商信息
     */
    public static final String API_15_DOUBLE_TEACHER_GET_AFFILIATE_PARTNER = "/openapi/double_teacher/getAffiliatePartner";
    /**
     * 添加单个课节
     */
    public static final String API_X_DOUBLE_TEACHER_ADD_SCHEDULE = "/openapi/double_teacher/addSchedule";
    /**
     * 设置教室排课信息表
     */
    public static final String API_X_DOUBLE_TEACHER_SET_ROOM_SCHEDULES = "/openapi/double_teacher/setRoomSchedules";
    /**
     * API-15: 添加录播课程
     */
    public static final String API_15_DOUBLE_TEACHER_CREATE_RECORD_COURSE = "/openapi/double_teacher/createRecordCourse";
    /**
     * API-16: 录播课程添加视频
     */
    public static final String API_16_DOUBLE_TEACHER_ADD_COURSE_VIDEO = "/openapi/double_teacher/addCourseVideo";
    /**
     * API-17: 录播课程删除视频
     */
    public static final String API_17_DOUBLE_TEACHER_DELETE_COURSE_VIDEO = "/openapi/double_teacher/deleteCourseVideo";
    /**
     * API-18: 设备绑定录播课程
     */
    public static final String API_18_DOUBLE_TEACHER_BIND_DEVICE_COURSE = "/openapi/double_teacher/bindDeviceCourse";
    /**
     * API-19: 设备解绑录播课程
     */
    public static final String API_19_DOUBLE_TEACHER_UNBIND_DEVICE_COURSE = "/openapi/double_teacher/unbindDeviceCourse";

    ///// 双师课堂创建互动成员接口 /////

    /**
     * API 1:双师人员数据保存
     */
    public static final String API_1_INTERACT_DATA_SAVE = "/openapi/interact_data/save";
    /**
     * API 2:根据签到id,获取签到信息
     */
    public static final String API_2_INTERACT_DATA_GET_CHECKIN_DATA = "/openapi/interact_data/getCheckinData";
    /**
     * API 3:删除班级、助教、学生信息
     */
    public static final String API_3_INTERACT_DATA_DELETE = "/openapi/interact_data/delete";
    /**
     * API 4:获取班级、助教、学生信息列表
     */
    public static final String API_4_INTERACT_DATA_LIST = "/openapi/interact_data/list";
    /**
     * API 5:老师添加、修改接口
     */
    public static final String API_5_TEACHER_SAVE = "/openapi/teacher/save";
    /**
     * API 6:老师删除接口
     */
    public static final String API_6_TEACHER_DELETE = "/openapi/teacher/delete";
    /**
     * API 7:获取老师信息接口
     */
    public static final String API_7_TEACHER_LIST = "/openapi/teacher/list";
    /**
     * API 8:修改回调地址
     */
    public static final String API_8_INTERACT_DATA_UPDATE_CALLBACK_URL = "/openapi/interact_data/updateCallbackUrl";
    /**
     * 双师添加一个学生
     */
    public static final String API_X_STUDENT_CREATE = "/openapi/student/create";
    /**
     * 双师批量增加学生
     */
    public static final String API_X_STUDENT_CREATE_BATCH = "/openapi/student/createBatch";
    /**
     * 双师修改学生信息
     */
    public static final String API_X_STUDENT_UPDATE = "/openapi/student/update";
    /**
     * 双师删除学生
     */
    public static final String API_X_STUDENT_DELETE = "/openapi/student/delete";
    /**
     * 批量删除学生
     */
    public static final String API_X_STUDENT_DELETE_BATCH = "/openapi/student/deleteBatch";
    /**
     * 展示班级内有效学生信息
     */
    public static final String API_X_STUDENT_LIST = "/openapi/student/list";
    /**
     * 双师创建班级
     */
    public static final String API_X_CLASS_CREATE = "/openapi/class/create";
    /**
     * 双师修改班级信息
     */
    public static final String API_X_CLASS_UPDATE = "/openapi/class/update";
    /**
     * 双师删除班级
     */
    public static final String API_X_CLASS_DELETE = "/openapi/class/delete";
    /**
     * 双师展示助教班级列表
     */
    public static final String API_X_CLASS_LIST = "/openapi/class/list";

    ///// 双师课堂获取互动数据接口 /////

    /**
     * API 1: 签到汇总数据
     */
    public static final String API_1_INTERACT_INFO_GET_INTERACT_LIST = "/openapi/interact_info/getInteractList";
    /**
     * API 2: 签到明细数据
     */
    public static final String API_2_INTERACT_INFO_GET_INTERACT_DETAIL = "/openapi/interact_info/getInteractDetail";
    /**
     * API 3: 获取班级投票数据
     */
    public static final String API_3_INTERACT_DATA_GET_CLASS_VOTE_DATA = "/openapi/interact_data/getClassVoteData";
    /**
     * API 4:获取班级红包数据
     */
    public static final String API_4_INTERACT_DATA_GET_RED_PACKAGE_DATA = "/openapi/interact_data/getRedPackageData";
    /**
     * API 5: 获取班级随机点名数据
     */
    public static final String API_5_INTERACT_DATA_GET_RANDOM_ASK_DATA = "/openapi/interact_data/getRandomAskData";
    /**
     * API 6: 获取AI班级数人数列表
     */
    public static final String API_6_INTERACT_DATA_GET_AI_USER_COUNT_DATA = "/openapi/interact_data/getAiUserCountData";

    ///// 其它 /////

    ///// 教室内网页PPT /////
    // https://ewiki.baijiashilian.com/WebServer/%E6%8E%A5%E5%8F%A3%E6%96%87%E6%A1%A3/%E5%BC%80%E5%8F%91%E8%80%85API%E6%8E%A5%E5%8F%A3/%E8%AE%BE%E7%BD%AE%E6%95%99%E5%AE%A4webppt.md

    /**
     * API 1 : 设置教室内网页PPT
     */
    public static final String API_1_DOC_SET_WEB_PPT = "/openapi/doc/setWebPpt";
    /**
     * API 2 : 获取教室内设置的网页PPT
     */
    public static final String API_2_DOC_GET_WEB_PPT = "/openapi/doc/getWebPpt";
    /**
     * API 3 : 删除教室内设置的网页PPT
     */
    public static final String API_3_DOC_DELETE_WEB_PPT = "/openapi/doc/deleteWebPpt";

    ///// 直播课件下载API /////
    // https://ewiki.baijiashilian.com/WebServer/%E6%8E%A5%E5%8F%A3%E6%96%87%E6%A1%A3/%E5%BC%80%E5%8F%91%E8%80%85API%E6%8E%A5%E5%8F%A3/%E7%9B%B4%E6%92%AD%E8%AF%BE%E4%BB%B6%E4%B8%8B%E8%BD%BD%E6%8E%A5%E5%8F%A3.md

    /**
     * 获取课件下载地址
     */
    public static final String API_X_DOC_GET_ROOM_DOC_URL = "/openapi/doc/getRoomDocUrl";
    /**
     * 查询子账号列表
     */
    public static final String API_X_SUB_ACCOUNT_GET_SUB_ACCOUNT_LIST = "/openapi/sub_account/getSubAccountList";
    /**
     * 获取子账号信息
     */
    public static final String API_X_SUB_ACCOUNT_GET_SUB_ACCOUNT_INFO = "/openapi/sub_account/getSubAccountInfo";
    /**
     * API 24 : 查询直播账号信息
     */
    public static final String API_24_LIVE_ACCOUNT_GET_ACCOUNT_INFO = "/openapi/live_account/getAccountInfo";
    /**
     * 获取教室专注度检测详情
     */
    public static final String API_X_ROOM_DATA_EXPORT_ATTENTION_DETAIL = "/openapi/room_data/exportAttentionDetail";
    /**
     * API 59 : 获取教室一次点名的信息
     */
    public static final String API_59_ROOM_DATA_GET_CHECKIN_INFO = "/openapi/room_data/getCheckinInfo";
    /**
     * API 58 : 获取教室点名列表
     */
    public static final String API_58_ROOM_DATA_GET_CHECKIN_LIST = "/openapi/room_data/getCheckinList";
    /**
     * 获取直播间试卷列表
     */
    public static final String API_X_ROOM_DATA_GET_QUIZ_LIST = "/openapi/room_data/getQuizList";
    /**
     * 获取试卷的答案列表
     */
    public static final String API_X_ROOM_DATA_GET_ANSWER_LIST = "/openapi/room_data/getAnswerList";
    /**
     * API 20 : 小班课教室进出明细
     */
    public static final String API_20_ROOM_DATA_GET_ENTER_OR_OUT_CLASS_DETAIL = "/openapi/room_data/getEnterOrOutClassDetail";
    /**
     * API 1 : 获取最近 3 分钟直播间网络情况数据
     */
    public static final String API_1_FLUENCY_GET_NETWORK_DATA = "/openapi/fluency/getNetworkData";
    /**
     * API 3:openapi 视频加密
     */
    public static final String API_3_VIDEO_SET_VIDEO_PASSWORD = "/openapi/video/setVideoPassword";

    ///// 新东方API /////
    // https://ewiki.baijiashilian.com/WebServer/%E6%8E%A5%E5%8F%A3%E6%96%87%E6%A1%A3/%E5%BC%80%E5%8F%91%E8%80%85API%E6%8E%A5%E5%8F%A3/%E6%96%B0%E4%B8%9C%E6%96%B9API.md

    /**
     * API 1 : 新东方定制 - 批量关联文档到教室
     */
    public static final String API_1_DOC_BATCH_BIND_DOC = "/openapi/doc/batchBindDoc";
    /**
     * API 2 : 新东方定制 - 批量移除教室内文档
     */
    public static final String API_2_DOC_BATCH_REMOVE_DOC = "/openapi/doc/batchRemoveDoc";
    /**
     * API 6 : 新东方定制 - 查看指定id答题器数据
     */
    public static final String API_6_ROOM_DATA_GET_QUESTION_ANSWER = "/openapi/room_data/getQuestionAnswer";
    /**
     * API 7 : 新东方定制 - 批量创建线上双师分组
     */
    public static final String API_7_ROOM_BATCH_CREATE_SUB_LIVE_ROOM = "/openapi/room/batchCreateSubLiveRoom";
    /**
     * API 8 : 新东方定制 - 批量删除教室
     */
    public static final String API_8_ROOM_BATCH_DELETE = "/openapi/room/batchDelete";
    /**
     * API 13 : 失败率统计接口
     */
    public static final String API_13_STAT_GET_API_STAT = "/openapi/stat/getApiStat";
    /**
     * API 14 : 推流录制异常日志记录
     */
    public static final String API_14_PLAYBACK_GET_PUSH_RECORD_ERROR_LOG = "/openapi/playback/getPushRecordErrorLog";
    /**
     * API 1:获取用户进出记录下载地址
     */
    public static final String API_1_ROOM_DATA_GET_USER_EVENT_DOWNLOAD_URL = "/openapi/room_data/getUserEventDownloadUrl";
    /**
     * API:批量获取用户进出记录下载地址
     */
    public static final String API_ROOM_DATA_GET_USER_EVENT_DOWNLOAD_URL_BATCH = "/openapi/room_data/getUserEventDownloadUrlBatch";
    /**
     * API 70: 获取单次答题器记录
     */
    public static final String API_70_ROOM_DATA_EXPORT_ANSWER_BY_QUESTION_ID = "/openapi/room_data/exportAnswerByQuestionId";
    /**
     * API 71: 获取单次红包记录
     */
    public static final String API_71_ROOM_DATA_GET_RED_PACKAGE_RECORD_INFO = "/openapi/room_data/getRedPackageRecordInfo";
    /**
     * API 76 : 获取教室主讲老师的信息
     */
    public static final String API_76_ROOM_TEACHER_INFO = "/openapi/room/teacherInfo";
    /**
     * API-1:获取直播教室当前在线用户列表
     */
    public static final String API_1_LIVE_GET_USER_LIST = "/openapi/live/getUserList";
    /**
     * API 4 : 给教室批量关联学员
     */
    public static final String API_4_USER_CLASS_BIND_STUDENT_BATCH_ARRAY = "/openapi/user/classBindStudentBatchArray";
    /**
     * API 3 : 通过文档ID获取音视频课件预览接口
     */
    public static final String API_3_DOC_GET_VIDEO_PREVIEW_INFO_BY_FID = "/openapi/doc/getVideoPreviewInfoByFid";
    /**
     * 获取互动次数
     */
    public static final String API_X_ROOM_DATA_GET_ROOM_INTERACT_DATA = "/openapi/room_data/getRoomInteractData";
    /**
     * 获取直播间举手、互动数据
     */
    public static final String API_X_ROOM_DATA_EXPORT_DEVICE_INTERACT_STAT = "/openapi/room_data/exportDeviceInteractStat";
    /**
     * API 1 : 创建双师加大直播教室接口
     */
    public static final String API_1_ROOM_CREATE_DOUBLE_TEACHER_LIVE = "/openapi/room/createDoubleTeacherLive";

    ///// 教室时长统计接口 /////
    // https://ewiki.baijiashilian.com/WebServer/%E6%8E%A5%E5%8F%A3%E6%96%87%E6%A1%A3/%E5%BC%80%E5%8F%91%E8%80%85API%E6%8E%A5%E5%8F%A3/%E6%95%99%E5%AE%A4%E6%97%B6%E9%95%BF%E7%BB%9F%E8%AE%A1%E6%8E%A5%E5%8F%A3.md

    /**
     * API 1 : 获取进出教室下载地址
     */
    public static final String API_1_LIVE_GET_PARTNER_ROOM_INFO_URL = "/openapi/live/getPartnerRoomInfoUrl";
    /**
     * API 2 : 获取等效分钟数
     */
    public static final String API_2_ROOM_DATA_GET_MEDIA_LENGTH = "/openapi/room_data/getMediaLength";

    /**
     * 批量创建用户
     */
    public static final String API_X_USER_BATCH_ADD_STUDENT_USER = "/openapi/user/batchAddStudentUser";
    /**
     * 直播自定义信令通过api的方式来发送内容
     */
    public static final String API_X_LIVE_SEND_CUSTOM_CAST = "/openapi/live/sendCustomCast";
    /**
     * API 1 : 获取过滤的聊天内容
     */
    public static final String API_1_ROOM_DATA_GET_FILTERED_CHAT_MSG = "/openapi/room_data/getFilteredChatMsg";
    /**
     * API 22 : 获取账号配置项配置值
     */
    public static final String API_22_PARTNER_GET_PARTNER_CONFIG = "/openapi/partner/getPartnerConfig";
    /**
     * 获取教室维度的卡顿数据
     */
    public static final String API_X_FLUENCY_GET_ROOM_NETWORK_DATA = "/openapi/fluency/getRoomNetworkData";
    /**
     * API 77 : 获取推流直播的多个CDN推流地址
     */
    public static final String API_77_ROOM_GET_MULTI_PUSH_STREAM_URL = "/openapi/room/getMultiPushStreamUrl";
    /**
     * API 4: 批量设置回放发布状态
     */
    public static final String API_4_PLAYBACK_SET_PUBLISH_STATUS_BATCH = "/openapi/playback/setPublishStatusBatch";
    /**
     * API 5: 回放播放量TOP10
     */
    public static final String API_5_PLAYBACK_GET_PLAY_COUNT_RANK = "/openapi/playback/getPlayCountRank";
    /**
     * API 6:给教室设置观看密码
     */
    public static final String API_6_ROOM_SET_ROOM_PASSWORD = "/openapi/room/setRoomPassword";
    /**
     * API 105:获取直播间多平台推流配置开启状态
     */
    public static final String API_105_ROOM_DATA_GET_MULTI_PLATFORM_STREAMING_STATUS = "/openapi/room_data/getMultiPlatformStreamingStatus";
    /**
     * API 106:保存直播间多平台推流配置开启状态
     */
    public static final String API_106_ROOM_DATA_SAVE_MULTI_PLATFORM_STREAMING_STATUS = "/openapi/room_data/saveMultiPlatformStreamingStatus";
    /**
     * API 107:获取直播间多平台推流配置信息列表
     */
    public static final String API_107_ROOM_DATA_GET_MULTI_PLATFORM_STREAMING_LIST = "/openapi/room_data/getMultiPlatformStreamingList";
    /**
     * API 108:新增直播间多平台推流配置信息
     */
    public static final String API_108_ROOM_DATA_ADD_MULTI_PLATFORM_STREAMING = "/openapi/room_data/addMultiPlatformStreaming";
    /**
     * API 109:编辑直播间多平台推流配置信息
     */
    public static final String API_109_ROOM_DATA_EDIT_MULTI_PLATFORM_STREAMING = "/openapi/room_data/editMultiPlatformStreaming";
    /**
     * API 110:删除直播间多平台推流配置信息
     */
    public static final String API_110_ROOM_DATA_DELETE_MULTI_PLATFORM_STREAMING = "/openapi/room_data/deleteMultiPlatformStreaming";
    /**
     * API 14:发送自定义广播信令
     */
    public static final String API_14_LIVE_SEND_BROADCAST = "/openapi/live/sendBroadcast";
    /**
     * 紧急踢人
     */
    public static final String API_X_ROOM_KICK_OUT_USER = "/openapi/room/kickOutUser";
    /**
     * 移除黑名单
     */
    public static final String API_X_ROOM_REMOVE_BLACKLIST = "/openapi/room/removeBlacklist";
    /**
     * 批量踢人黑名单
     */
    public static final String API_X_ROOM_BATCH_KICK_OUT_USER = "/openapi/room/batchKickOutUser";
    /**
     * API 16:更新进入房间参加码
     */
    public static final String API_16_ROOM_UPDATE_INVITE_CODE = "/openapi/room/updateInviteCode";
    /**
     * 积分设置
     */
    public static final String API_X_ROOM_SCORE_SET_CONFIG = "/openapi/room_score/setConfig";
    /**
     * 积分查询
     */
    public static final String API_X_ROOM_SCORE_GET_CONFIG_LIST = "/openapi/room_score/getConfigList";
    /**
     * 分组课堂-分组白名单列表
     */
    public static final String API_X_ROOM_LIST_GROUP_CODE_USER = "/openapi/room/listGroupCodeUser";
    /**
     * 分组课堂-分组白名单添加用户
     */
    public static final String API_X_ROOM_ADD_GROUP_CODE_USER = "/openapi/room/addGroupCodeUser";
    /**
     * 分组课堂-分组白名单删除用户
     */
    public static final String API_X_ROOM_REMOVE_GROUP_CODE_USER = "/openapi/room/removeGroupCodeUser";
    /**
     * 分组课堂-获取学生分组码列表
     */
    public static final String API_X_ROOM_GET_STUDENT_GROUP_LIVE_CODES = "/openapi/room/getStudentGroupLiveCodes";
    /**
     * API 18:导出课后评价学生回答统计
     */
    public static final String API_18_EVALUATION_EXPORT_ANSWER = "/openapi/evaluation/exportAnswer";
    /**
     * API 27 : 设置超级账号回调地址配置
     */
    public static final String API_27_ACCOUNT_SET_CALLBACK_URL = "/openapi/account/setCallbackUrl";
    /**
     * API 26 : 查询超级账号回调地址配置
     */
    public static final String API_26_ACCOUNT_GET_CALLBACK_URL = "/openapi/account/getCallbackUrl";
    /**
     * API 99: 获取教室拉流flv地址接口
     */
    public static final String API_99_LIVE_GET_ROOM_PULL_FLV_URL = "/openapi/live/getRoomPullFlvUrl";
    /**
     * API 117: 获取App打赏手机号账号余额接口
     */
    public static final String API_117_REWARD_GET_PHONE_ACCOUNT_INFO = "/openapi/reward/getPhoneAccountInfo";
    /**
     * API 118: 获取App打赏手机号账号消费明细列表接口
     */
    public static final String API_118_REWARD_GET_PHONE_ACCOUNT_REWARD_LIST = "/openapi/reward/getPhoneAccountRewardList";
    /**
     * API 119: App打赏充值手机号账号接口
     */
    public static final String API_119_REWARD_RECHARGE_PHONE_ACCOUNT = "/openapi/reward/rechargePhoneAccount";
    /**
     * 根据客户提供的视频url来生成点播视频
     */
    public static final String API_X_VIDEO_UPLOAD_VIDEO_WITH_URL = "/openapi/video/uploadVideoWithUrl";
    /**
     * 每分钟在线学生人数
     */
    public static final String API_X_LIVE_GET_USER_COUNT_BY_MINUTE = "/openapi/live/getUserCountByMinute";
    /**
     * 学生在直播间的进出时间区间段
     */
    public static final String API_X_LIVE_GET_USER_IN_OUT_RECORD = "/openapi/live/getUserInOutRecord";
    /**
     * 学生每次观看回放去重记录（该接口用于获取指定回放视频一段时间内的的观看记录，以 fid、user_number、guid、client_type 为维度去重之后观看记录。）
     */
    public static final String API_X_VIDEO_DATA_GET_PLAYBACK_WATCH_RECORD_WITH_GUID = "/openapi/video_data/getPlaybackWatchRecordWithGuid";
    /**
     * 学生观看回放去重记录（该接口用于获取指定回放视频一段时间内的的观看记录，以 fid、user_number 为维度去重之后观看记录。）
     */
    public static final String API_X_VIDEO_DATA_GET_PLAYBACK_WATCH_RECORD = "/openapi/video_data/getPlaybackWatchRecord";
    /**
     * 开启云端录制
     */
    public static final String API_X_LIVE_START_CLOUD_RECORD = "/openapi/live/startCloudRecord";
    /**
     * 查询班级下的学员列表
     */
    public static final String API_X_USER_GET_GROUP_USER_LIST = "/openapi/user/getGroupUserList";
    /**
     * 获取回放观看和直播间观看时长汇总记录
     */
    public static final String API_X_VIDEO_DATA_GET_MERGE_PLAYBACK_WATCH_RECORD = "/openapi/video_data/getMergePlaybackWatchRecord";
    /**
     * 视频id不变的情况下替换视频内容
     */
    public static final String API_X_VIDEO_REPLACE_VIDEO_KEEP_ID = "/openapi/video/replaceVideoKeepId";
    /**
     * 获取小班课试听参加码
     */
    public static final String API_X_ROOM_SHOW_AUDITION_CODE = "/openapi/room/showAuditionCode";
    /**
     * 获取管理员所属的教室列表
     */
    public static final String API_X_USER_GET_BELONG_ROOM_LIST = "/openapi/user/getBelongRoomList";
    /**
     * 获取管理员所属的点播列表
     */
    public static final String API_X_USER_GET_BELONG_VIDEO_LIST = "/openapi/user/getBelongVideoList";
    /**
     * 商品链接埋点数据查询
     */
    public static final String API_X_REPORT_DATA_GET_PRODUCT_LINK_CLICK_LIST = "/openapi/report_data/getProductLinkClickList";
    /**
     * 关键词列表
     */
    public static final String API_X_LIVE_CHAT_KEYWORD_KEYWORD_LIST = "/openapi/live_chat_keyword/keywordList";
    /**
     * 关键词添加
     */
    public static final String API_X_LIVE_CHAT_KEYWORD_ADD_KEYWORD = "/openapi/live_chat_keyword/addKeyword";
    /**
     * 关键词批量添加
     */
    public static final String API_X_LIVE_CHAT_KEYWORD_BATCH_ADD_KEYWORD = "/openapi/live_chat_keyword/batchAddKeyword";
    /**
     * 关键词删除
     */
    public static final String API_X_LIVE_CHAT_KEYWORD_DEL_KEYWORD = "/openapi/live_chat_keyword/delKeyword";
    /**
     * 关键词批量删除
     */
    public static final String API_X_LIVE_CHAT_KEYWORD_BATCH_DELETE_KEYWORD = "/openapi/live_chat_keyword/batchDeleteKeyword";
    /**
     * 获取直播音视频课件上传地址
     */
    public static final String API_X_DOC_GET_VIDEO_DOC_UPLOAD_URL = "/openapi/doc/getVideoDocUploadUrl";
    /**
     * API 6 : 查询指定观看过的回放视频列表
     */
    public static final String API_6_VIDEO_DATA_GET_PLAYBACK_VIDEO_WATCHED_LIST = "/openapi/video_data/getPlaybackVideoWatchedList";

    /**
     * 点播观看数据实时查询
     */
    public static final String API_X_VIDEO_DATA_GET_PLAYBACK_REALTIME_RECORD = "/openapi/video_data/getPlaybackRealtimeRecord";
    /**
     * 批量发起点播生成字幕
     */
    public static final String API_X_VIDEO_BATCH_ADD_VIDEO_AUTO_SUBTITLE = "/openapi/video/batchAddVideoAutoSubtitle";
    /**
     * 批量发起回放生成字幕
     */
    public static final String API_X_VIDEO_BATCH_ADD_PLAYBACK_AUTO_SUBTITLE = "/openapi/video/batchAddPlaybackAutoSubtitle";
    /**
     * 字幕订单查询
     */
    public static final String API_X_VIDEO_GET_AUTO_SUBTITLE_ORDER_INFO = "/openapi/video/getAutoSubtitleOrderInfo";
    /**
     * 导出教室专注度检测列表
     */
    public static final String API_X_ROOM_DATA_EXPORT_ATTENTION_LIST = "/openapi/room_data/exportAttentionList";

    ///// 合并回放 /////
    // https://ewiki.baijiashilian.com/WebServer/%E6%8E%A5%E5%8F%A3%E6%96%87%E6%A1%A3/%E5%BC%80%E5%8F%91%E8%80%85API%E6%8E%A5%E5%8F%A3/openapi%E5%90%88%E5%B9%B6%E5%9B%9E%E6%94%BE.md

    /**
     * 获取合并回放列表
     */
    public static final String API_X_MIXED_PLAYBACK_GET_LIST = "/openapi/mixed_playback/getList";
    /**
     * 获取合并回放详情
     */
    public static final String API_X_MIXED_PLAYBACK_GET_DETAIL = "/openapi/mixed_playback/getDetail";
    /**
     * 删除合并回放
     */
    public static final String API_X_MIXED_PLAYBACK_DELETE = "/openapi/mixed_playback/delete";
    /**
     * 创建合并回放
     */
    public static final String API_X_MIXED_PLAYBACK_CREATE = "/openapi/mixed_playback/create";

    ///// 转播 /////

    /**
     * 查询直播未开始前的预热视频列表
     */
    public static final String API_X_ROOM_GET_ROOM_VIDEO_ON_DEMAND_LIST = "/openapi/room/getRoomVideoOnDemandList";
    /**
     * 自动转播
     */
    public static final String API_X_LIVE_SETTING_AUTO_BROADCAST_ROOM = "/openapi/live_setting/autoBroadcastRoom";
    /**
     * 获取转播房间列表
     */
    public static final String API_X_LIVE_SETTING_GET_SELECT_BROADCAST_ROOM_LIST = "/openapi/live_setting/getSelectBroadcastRoomList";

    ///// 分享 /////

    /**
     * 设置直播间分享信息
     */
    public static final String API_X_ROOM_SET_SHARE_INFO = "/openapi/room/setShareInfo";

    ///// 虚拟话术 /////

    /**
     * 设置虚拟话术开关
     */
    public static final String API_X_ROOM_SET_VIRTUAL_CHAT_ART_CONFIG = "/openapi/room/setVirtualChatArtConfig";
    /**
     * 虚拟话术列表
     */
    public static final String API_X_ROOM_LIST_VIRTUAL_CHAT = "/openapi/room/listVirtualChat";
    /**
     * 新增虚拟话术
     */
    public static final String API_X_ROOM_ADD_VIRTUAL_CHAT = "/openapi/room/addVirtualChat";
    /**
     * 批量新增虚拟话术
     */
    public static final String API_X_ROOM_BATCH_ADD_VIRTUAL_CHAT = "/openapi/room/batchAddVirtualChat";
    /**
     * 编辑虚拟话术
     */
    public static final String API_X_ROOM_EDIT_VIRTUAL_CHAT = "/openapi/room/editVirtualChat";
    /**
     * 批量导入虚拟话术
     */
    public static final String API_X_ROOM_BATCH_IMPORT_VIRTUAL_CHAT = "/openapi/room/batchImportVirtualChat";
    /**
     * 批量删除虚拟话术
     */
    public static final String API_X_ROOM_BATCH_DELETE_VIRTUAL_CHAT = "/openapi/room/batchDeleteVirtualChat";

    /**
     * 复制虚拟话术
     */
    public static final String API_X_ROOM_COPY_VIRTUAL_CHAT_ART = "/openapi/room/copyVirtualChatArt";

    ///// 全局头像库 /////
    public static final String API_X_LIVE_SETTING_SAVE_PARTNER_IMAGE = "/openapi/live_setting/savePartnerImage";

    /**
     * 图片资源 - 上传图片
     */
    public static final String API_X_ROOM_UPLOAD_IMAGE = "/openapi/room/uploadImage";

    /**
     * 图片资源 - 保存图片
     */
    public static final String API_X_ROOM_SAVE_PARTNER_IMAGE = "/openapi/room/savePartnerImage";

    /**
     * 图片资源 - 删除图片
     */
    public static final String API_X_ROOM_DELETE_PARTNER_IMAGE = "/openapi/room/deletePartnerImage";

    /**
     * 图片资源 - 图片列表
     */
    public static final String API_X_ROOM_GET_PARTNER_IMAGE_LIST = "/openapi/room/getPartnerImageList";

    /**
     * 广播购物订单
     * <a href="https://ewiki.baijiashilian.com/%E7%99%BE%E5%AE%B6%E4%BA%91/%E7%AE%A1%E7%90%86%E5%90%8E%E5%8F%B0/%E8%B4%AD%E7%89%A9%E8%AE%A2%E5%8D%95%E9%A3%98%E7%AA%97/%E5%B9%BF%E6%92%AD%E8%B4%AD%E7%89%A9%E8%AE%A2%E5%8D%95%E4%BF%A1%E4%BB%A4.md">订单场控推送订单消息</a>
     * <p>当直播间开启订单场控功能后，此接口用于触发订单飘屏。</p>
     */
    public static final String API_X_ROOM_BROADCAST_SHOPPING_ORDER = "/openapi/room/broadcastShoppingOrder";

    /**
     * 推送秒杀订单
     */
    public static final String API_X_ROOM_PUSH_FLASH_SALE_ORDER = "/openapi/room/pushFlashSaleOrder";

    /**
     * 推送商品已售数量
     * https://operate.baijiayun.com/doc-fe/#/doc/szklupfoywoiodtmqewiqtpwcnrwkmxg
     */
    public static final String API_X_ROOM_PUSH_GOODS_SALE_ORDER = "/openapi/room/pushGoodsSaleOrder";
    ///// 福袋/优惠券 /////
    /**
     * 直播间绑定优惠券
     */
    public static final String API_X_LUCKY_BAG_BATCH_BIND_COUPON_TO_ROOM = "/openapi/lucky_bag/batchBindCouponToRoom";

    /**
     * 直播间解绑优惠券
     */
    public static final String API_X_LUCKY_BAG_BATCH_UNBIND_COUPON_TO_ROOM = "/openapi/lucky_bag/batchUnbindCouponToRoom";

    /**
     * 新增优惠券
     */
    public static final String API_X_LUCKY_BAG_COUPON_CREATE = "/openapi/lucky_bag/couponCreate";

    /**
     * 更新优惠券
     */
    public static final String API_X_LUCKY_BAG_COUPON_UPDATE = "/openapi/lucky_bag/couponUpdate";
    /**
     * 删除优惠券
     */
    public static final String API_X_LUCKY_BAG_COUPON_DEL = "/openapi/lucky_bag/couponDel";

    /**
     * 优惠券事件通知
     */
    public static final String API_X_LUCKY_BAG_COUPON_STATE_CALLBACK = "openapi/lucky_bag/couponStateCallback";
    public static final String API_X_LUCKY_BAG_COUPON_DRAW_COUNT_CALLBACK = "openapi/lucky_bag/couponDrawCountCallback";

    ///// 直播间虚拟成员设置 /////
    public static final String API_X_ROOM_GET_CURRENT_USER = "/openapi/room/getCurrentUser";// 查询虚拟人数设置信息
    public static final String API_X_ROOM_GET_FAKE_NAME_AVATAR_LIST = "/openapi/room/getFakeNameAvatarList";// 虚拟成员列表
    public static final String API_X_ROOM_EDIT_FAKE_NAME_AVATAR = "/openapi/room/editFakeNameAvatar";// 编辑虚拟成员
    public static final String API_X_ROOM_ONE_KEY_BIND_FAKE_NAME_AVATAR = "/openapi/room/oneKeyBindFakeNameAvatar";// 一键关联头像
    public static final String API_X_ROOM_DELETE_FAKE_NAME_AVATAR = "/openapi/room/deleteFakeNameAvatar";// 删除虚拟成员
    public static final String API_X_ROOM_IMPORT_NICKNAME_FILE = "/openapi/room/importNicknameFile";// 导入虚拟成员

    /**
     * 伪直播预设话术
     */
    public static final String API_X_ROOM_SET_MOCK_PRESET_CHAT_ART = "/openapi/room/setMockPresetChatArt";

    /**
     * 伪直播清空预设话术
     */
    public static final String API_X_ROOM_CLEAR_MOCK_PRESET_CHAT_ART = "/openapi/room/clearRoomChatArt";


    ///// 全局虚拟成员设置 /////

    public static final String API_X_LIVE_SETTING_GET_FAKE_NAME_AVATAR_LIST = "/openapi/live_setting/getFakeNameAvatarList";// 全局虚拟成员列表
    public static final String API_X_LIVE_SETTING_BATCH_ADD_FAKE_NAME_AVATAR = "/openapi/live_setting/batchAddFakeNameAvatar";// 新增全局虚拟成员
    public static final String API_X_LIVE_SETTING_EDIT_FAKE_NAME_AVATAR = "/openapi/live_setting/editFakeNameAvatar";// 编辑全局虚拟成员
    public static final String API_X_LIVE_SETTING_DELETE_FAKE_NAME_AVATAR = "/openapi/live_setting/deleteFakeNameAvatar";// 删除全局虚拟成员
    public static final String API_X_LIVE_SETTING_GET_FAKE_NAME_AVATAR_INFO = "/openapi/live_setting/getFakeNameAvatarInfo";// 全局虚拟成员详情

    public static final String API_X_LIVE_SETTING_SET_LIVE_CUSTOM_DECORATE = "openapi/live_setting/setLiveCustomDecorate"; // 设置自定义装修

    // 批量添加黑名单
    public static final String API_X_LIVE_SETTING_BATCH_ADD_LIVE_BLACKLIST = "/openapi/live_setting/batchAddLiveBlacklist";
    // 删除黑名单
    public static final String API_X_LIVE_SETTING_BATCH_DELETE_LIVE_BLACKLIST = "/openapi/live_setting/batchDeleteLiveBlacklist";

    public static final String API_SMS = "/openapi";
}