package com.baijiayun.openapi.sdk;

import com.baijiayun.openapi.sdk.base.BjyClient;
import lombok.NonNull;
import lombok.Setter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/**
 * desc:
 *
 * @author yanmaoyuan
 */
@Setter
public class BjyClientPostProcessor implements BeanFactoryPostProcessor, EnvironmentAware {

    private String clientPackage;

    @Override
    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) throws BeansException {

        BjyClientFactory factory = new BjyClientFactory();
        Set<Class<?>> clientClazz = scanClients();
        for (Class<?> clazz: clientClazz){
            beanFactory.registerSingleton(clazz.getName(), factory.create(clazz));
        }
    }

    public Set<Class<?>> scanClients() {

        Set<Class<?>> classes = new HashSet<>();

        ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

        MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory(resourcePatternResolver);

        Resource[] resources = new Resource[0];
        try {
            String pattern = "classpath*:" + clientPackage.replaceAll("\\.", "/") + "/**/*.class";
            resources = resourcePatternResolver.getResources(pattern);
        } catch (IOException ignored) {
        }

        for (Resource resource : resources) {
            try {
                MetadataReader reader = metadataReaderFactory.getMetadataReader(resource);
                if (reader.getAnnotationMetadata().hasAnnotation(BjyClient.class.getName())) {
                    Class<?> cls = ClassUtils.forName(
                            reader.getClassMetadata().getClassName(),
                            this.getClass().getClassLoader());
                    classes.add(cls);
                }
            } catch (Exception ignored) {
            }
        }
        return classes;
    }

    @Override
    public void setEnvironment(@NonNull Environment environment) {
        // nothing to do
    }
}
