package com.baijiayun.openapi.sdk;

import com.baijiayun.openapi.sdk.base.BjyPartnerInfo;
import com.baijiayun.openapi.sdk.base.Request;
import com.baijiayun.openapi.sdk.base.BjyResult;
import com.baijiayun.openapi.sdk.utils.BjyServiceUtil;
import com.fasterxml.jackson.databind.JavaType;
import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.util.Map;

/**
 * desc:
 *
 * @author yanmaoyuan
 */
@Slf4j
public class BjyClientInvocationHandler implements InvocationHandler {

    @Override
    public Object invoke(Object proxy, java.lang.reflect.Method method, Object[] args) throws Throwable {
        log.debug("Invoke {}#{}", method.getDeclaringClass().getCanonicalName(), method.getName());
        BjyCallContext context = BjyCallContext.from(method, args);

        BjyPartnerInfo base = context.getBaseReqDto();

        String url = BjyServiceUtil.getUrl(base.getPrivateDomain(), context.getPath());

        Map<String, String> paramMap = BjyServiceUtil.beanToMap(context.getParams());
        BjyServiceUtil.sign(paramMap, base);// 生成签名

        // 发送请求
        String resultJson = null;
        try {
            log.info("{} ---> {}:{}", base.getPrivateDomain(), context.getMethod(), context.getPath());
            if (log.isDebugEnabled()) {
                log.debug("request data:{}", paramMap);
            }
            long start = System.currentTimeMillis();
            if (context.getMethod() == Request.Method.GET) {
                resultJson = BjyServiceUtil.doGet(url, paramMap, null);
            } else if (context.getMethod() == Request.Method.POST) {
                // 是否有文件？
                Map<String, File> fileMap = BjyServiceUtil.beanToFileMap(context.getParams());
                if (fileMap.isEmpty()) {
                    resultJson = BjyServiceUtil.doPost(url, paramMap, null, null);
                } else {
                    resultJson = BjyServiceUtil.doPost(url, paramMap, fileMap, null);
                }
            }
            long cost = System.currentTimeMillis() - start;
            if (log.isDebugEnabled()) {
                log.debug("Result {}", resultJson);
            }
            log.info("{} {}:{} <--- {}ms", base.getPrivateDomain(), context.getMethod(), context.getPath(), cost);
        } catch (Exception e) {
            log.error("invoke method failed, path:{}, params:{}", context.getPath(), paramMap, e);
            return BjyResult.error(BjyResult.CODE_EXCEPTION, "接口调用异常");
        }

        try {
            // 反序列化
            JavaType javaType = BjyServiceUtil.constructType(method.getGenericReturnType());
            return BjyServiceUtil.str2Obj(resultJson, javaType);
        } catch (Exception e) {
            log.error("parse resultJson failed, result:{}", resultJson, e);
            return BjyResult.error(BjyResult.CODE_EXCEPTION, "获取接口数据失败");
        }
    }
}