package com.baijiayun.openapi.sdk;

import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

/**
 * desc:
 *
 * @author yanmaoyuan
 */
@Slf4j
public class BjyClientFactory {
    private final Map<Class<?>, Object> cache;
    private final BjyClientInvocationHandler handler;

    public BjyClientFactory() {
        handler = new BjyClientInvocationHandler();
        cache = new HashMap<>();
    }

    @SuppressWarnings("unchecked")
    public <T> T create(Class<T> clazz) {
        if (cache.containsKey(clazz)) {
            return (T) cache.get(clazz);
        }
        T client = (T) Proxy.newProxyInstance(
                this.getClass().getClassLoader(),
                new Class[]{clazz},
                handler
        );

        cache.put(clazz, client);

        if (log.isDebugEnabled()) {
            log.debug("create client: {}", clazz.getName());
        }
        return client;
    }
}
