package com.baijiayun.openapi.sdk.base;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface Request {

    Method method();

    String path();

    /**
     * 百家云OpenAPI的请求只支持 POST 和 GET。POST 仅支持 form 表单。
     *
     * @author yanmaoyuan
     * @date 2024/6/28
     */
    enum Method {
        POST, GET
    }
}
