package com.baijiayun.openapi.sdk.base;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.io.Serializable;

@Data
public class BjySmsResult<T> implements Serializable {

    private static final long serialVersionUID = -1L;

    public static final int CODE_SUCCESS = 200;// 成功
    public static final int CODE_NOT_FOUNT = 20001;// 账户未开通
    public static final int CODE_SEND_FAIL = 20002;// 短信发送失败
    public static final int CODE_AUTH_ERROR = 20003;// 账户已被禁用
    public static final int CODE_MSG_ID_REQUIRED = 20004;// msg_id必填
    public static final int CODE_MOBILE_REQUIRED = 20005;// 手机号必填
    public static final int CODE_MSG_REQUIRED = 20006;// 发送内容不能为空
    public static final int CODE_SIGN_REQUIRED = 20007;// 签名不能为空
    public static final int CODE_NATION_CODE_ERROR = 20008;// 国家代码暂不支持发送
    public static final int CODE_MOBILE_INVALID = 20009;// 验证手机号失败
    public static final int CODE_EXCEPTION = 30000;// 请求接口异常

    private int code;
    @JsonAlias("result")
    private T data;
    private String msg;
    private Long ts;

    public static <T> BjySmsResult<T> error(int code, String msg) {
        BjySmsResult<T> res = new BjySmsResult<>();
        res.code = code;
        res.msg = msg;
        return res;
    }

    @JsonIgnore
    public boolean isSuccess() {
        return code == BjySmsResult.CODE_SUCCESS;
    }

    @JsonIgnore
    public boolean isFail() {
        return code != BjySmsResult.CODE_SUCCESS;
    }

    @JsonIgnore
    public boolean isDataValid() {
        return isSuccess() && data != null;
    }
}
