package com.baijiayun.openapi.sdk.base;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.io.Serializable;

@Data
public class BjyResult<T> implements Serializable {

    private static final long serialVersionUID = -1L;

    public static final int CODE_SUCCESS = 0;// 成功
    public static final int CODE_FAIL = 1;// 普通错误（没有明确 code 码的错误）
    public static final int CODE_NOT_FOUNT = 404;// 请求路径不存在
    public static final int CODE_PARAM_ERROR = 1001;// 参数错误
    public static final int CODE_SIGN_ERROR = 1002;// 签名计算错误
    public static final int CODE_PARTNER_ERROR = 2001;// 账号不存在
    public static final int CODE_AUTH_ERROR = 2002;// 账号权限错误
    public static final int CODE_SERVICE_ERROR = 2003;// 直播账号未开或服务停止
    public static final int CODE_ROOM_ERROR = 3001;// 房间号不存在
    public static final int CODE_ROOM_DELETED = 3002;// 该房间已删除
    public static final int CODE_UPLOAD_ERROR = 4001;// 文件上传失败
    public static final int CODE_EXCEPTION = 30000;// 请求接口异常

    private int code;
    @JsonAlias("result")
    private T data;
    private String msg;
    private Long ts;

    public static <T> BjyResult<T> error(int code, String msg) {
        BjyResult<T> res = new BjyResult<>();
        res.code = code;
        res.msg = msg;
        return res;
    }

    @JsonIgnore
    public boolean isSuccess() {
        return code == BjyResult.CODE_SUCCESS;
    }

    @JsonIgnore
    public boolean isFail() {
        return code != BjyResult.CODE_SUCCESS;
    }

    @JsonIgnore
    public boolean isDataValid() {
        return isSuccess() && data != null;
    }
}
