/*
 * Decompiled with CFR 0.152.
 */
package com.baijiahulian.pandora.shadow.fiend.logger.api.impl;

import com.baijiahulian.pandora.shadow.fiend.logger.api.AspWalker;
import com.baijiahulian.pandora.shadow.fiend.proto.AdvProto;
import com.baijiahulian.pandora.shadow.fiend.util.TransferUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspPbWalker
implements AspWalker {
    private static final Logger logger = LoggerFactory.getLogger(AspPbWalker.class);
    private static final AspPbWalker instance = new AspPbWalker();

    private AspPbWalker() {
    }

    public static AspPbWalker getInstance() {
        return instance;
    }

    @Override
    public void write(AdvProto.SfAdSearch sfAdSearch) {
        try {
            byte[] buf = sfAdSearch.toByteArray();
            byte[] length = TransferUtil.int2byte(buf.length);
            byte[] final_buf = TransferUtil.byteMerge(length, buf);
            File file = new File(AspPbWalker.generateFileName());
            FileOutputStream fos = new FileOutputStream(file, true);
            fos.write(final_buf);
            fos.close();
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private static String generateFileName() {
        String path = "/apps/synlog/bigdata/adserver";
        String date = AspPbWalker.generateDate();
        String prefix = path + "/" + date + "/";
        File file = new File(prefix);
        if (!file.exists()) {
            if (file.mkdirs()) {
                logger.info("ShadowFiend mkdirs success dir[" + prefix + "]");
            } else {
                logger.error("ShadowFiend mkdirs failed dir[" + prefix + "]");
            }
        }
        String name = "asp-pb-log";
        String suffix = "." + date + "." + Thread.currentThread().getId();
        String filename = prefix + name + suffix;
        return filename;
    }

    private static String generateDate() {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(date);
    }
}

