/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.wechat.util;

import com.baijia.wedo.sal.wechat.dto.WechatApiResponse;
import com.baijia.wedo.sal.wechat.helper.WechatRemoteCallHelper;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatWebAuthCaller {
    private static final Logger log = LoggerFactory.getLogger(WechatWebAuthCaller.class);

    public static WechatApiResponse getWebAuthorization(String appId, String code, String secret) {
        try {
            String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + appId + "&secret=" + secret + "&code=" + code + "&grant_type=authorization_code";
            return WechatRemoteCallHelper.get(url, true);
        }
        catch (Exception e) {
            log.warn("getWebAuthorization - exception - appId:{},code:{}", (Object)appId, (Object)code);
            return null;
        }
    }

    public static WechatApiResponse getUserInfoByWebAuth(String webAuthAccessToken, String openId) {
        try {
            String url = "https://api.weixin.qq.com/sns/userinfo";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("access_token", webAuthAccessToken);
            params.put("openid", openId);
            params.put("lang", "zh_CN");
            return WechatRemoteCallHelper.get(url, params);
        }
        catch (Exception e) {
            log.warn("getUserInfoByWebAuth - exception - accessToken:{},openId:{},e:{}", new Object[]{webAuthAccessToken, openId, e});
            return null;
        }
    }
}

