/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.wechat.util;

import com.baijia.wedo.common.errorcode.CommonErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.util.HttpClientUtils;
import com.baijia.wedo.sal.wechat.dto.OpenPlatformInfoDto;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatUtils {
    private static final Logger log = LoggerFactory.getLogger(WechatUtils.class);

    public static void disableCache(HttpServletResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
    }

    public static String getToken(OpenPlatformInfoDto dto) {
        String api = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + dto.getAppId() + "&secret=" + dto.getAppSecret();
        String response = HttpClientUtils.doGet((String)api, null);
        log.info("Get accessToken wechat, param:{}, response:{}", (Object)dto, (Object)response);
        JSONObject json = JSONObject.fromObject((Object)response);
        if (json.containsKey((Object)"access_token") && json.containsKey((Object)"expires_in")) {
            return json.getString("access_token");
        }
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "get wechat access token failed");
    }

    public static String getTicket(String accessToken) {
        String api = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=" + accessToken + "&type=jsapi";
        String response = HttpClientUtils.doGet((String)api, null);
        log.info("Get js ticket from wechat, param:{}, response:{}", (Object)accessToken, (Object)response);
        JSONObject json = JSONObject.fromObject((Object)response);
        if (json.containsKey((Object)"errcode") && json.containsKey((Object)"errmsg")) {
            int errcode = json.getInt("errcode");
            String errmsg = json.getString("errmsg");
            if (errcode == 0 && "ok".equalsIgnoreCase(errmsg)) {
                return json.getString("ticket");
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "get js ticket failed");
        }
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "get js ticket failed");
    }
}

