/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.wechat.util;

import com.baijia.wedo.common.enums.WedoErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.util.JacksonUtil;
import com.baijia.wedo.common.util.encrypt.EncryptUtils;
import com.baijia.wedo.sal.wechat.dto.RequestToken;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class CookieUtils {
    public static RequestToken getToken(HttpServletRequest request, String key) throws JsonParseException, JsonMappingException, IOException {
        String decodeStr;
        String cookieVal = CookieUtils.searchCookie(request, key);
        RequestToken token = null;
        if (StringUtils.isNotBlank((CharSequence)cookieVal)) {
            decodeStr = EncryptUtils.strDecode((String)cookieVal);
            if (!StringUtils.isNotBlank((CharSequence)decodeStr)) {
                throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARSE_TOKEN_FAILED, "\u65e0\u6cd5\u8bc6\u522b\u7528\u6237\u8eab\u4efd");
            }
        } else {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.TOKEN_ERROR, "\u65e0\u6cd5\u8bc6\u522b\u7528\u6237\u8eab\u4efd");
        }
        token = (RequestToken)JacksonUtil.str2Obj((String)decodeStr, RequestToken.class);
        return token;
    }

    public static RequestToken getTokenQuietly(String cookie, String key) {
        RequestToken token = null;
        if (StringUtils.isNotBlank((CharSequence)cookie)) {
            try {
                String decodeStr = EncryptUtils.strDecode((String)cookie);
                if (StringUtils.isNotBlank((CharSequence)decodeStr)) {
                    token = (RequestToken)JacksonUtil.str2Obj((String)decodeStr, RequestToken.class);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return token;
    }

    public static String searchCookie(HttpServletRequest request, String key) {
        if (null != request.getCookies()) {
            for (Cookie cookie : request.getCookies()) {
                if (!cookie.getName().equals(key)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static String getParamStr(HttpServletRequest request, String key) throws JsonParseException, JsonMappingException, IOException {
        String cookieVal = CookieUtils.searchCookie(request, key);
        if (StringUtils.isNotBlank((CharSequence)cookieVal)) {
            String decodeStr = EncryptUtils.strDecode((String)cookieVal);
            if (StringUtils.isNotBlank((CharSequence)decodeStr)) {
                return decodeStr;
            }
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARSE_TOKEN_FAILED);
        }
        throw new BusinessException((UniverseErrorCode)WedoErrorCode.TOKEN_ERROR);
    }
}

