/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.wechat.service.impl;

import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.wedo.dal.wechat.po.AuthorizationInfo;
import com.baijia.wedo.sal.wechat.dto.OpenPlatformInfoDto;
import com.baijia.wedo.sal.wechat.dto.WechatJsSignDto;
import com.baijia.wedo.sal.wechat.service.WechatService;
import com.baijia.wedo.sal.wechat.util.WechatProperties;
import com.baijia.wedo.sal.wechat.util.WechatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatServiceImpl
implements WechatService {
    private static final Logger log = LoggerFactory.getLogger(WechatServiceImpl.class);
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;

    @Override
    public String getToken() {
        OpenPlatformInfoDto dto = WechatProperties.getOpenPlatformInfo();
        return WechatUtils.getToken(dto);
    }

    @Override
    public String getTicket() {
        OpenPlatformInfoDto dto = WechatProperties.getOpenPlatformInfo();
        String accessToken = WechatUtils.getToken(dto);
        return WechatUtils.getTicket(accessToken);
    }

    @Override
    public WechatJsSignDto getJsSign(String url) {
        OpenPlatformInfoDto opiInfodto = WechatProperties.getOpenPlatformInfo();
        String appId = opiInfodto.getAppId();
        AuthorizationInfo data = this.authorizationInfoDao.getByAuthorizerAppId(opiInfodto.getAppId());
        log.info("Load wechat authorizationInfo from db:{}", (Object)data);
        String noncestr = BaseUtils.getRandomString((int)10);
        String ticket = "";
        ticket = data != null && !data.isAccessTokenExpired() ? data.getTicket() : this.getTicket();
        long timestamp = System.currentTimeMillis() / 1000L;
        String signature = null;
        StringBuilder builder = new StringBuilder();
        builder.append("jsapi_ticket=").append(ticket);
        builder.append("&noncestr=").append(noncestr);
        builder.append("&timestamp=").append(timestamp);
        builder.append("&url=").append(url);
        signature = BaseUtils.SHA1((String)builder.toString());
        WechatJsSignDto jsSign = new WechatJsSignDto();
        jsSign.setAppId(appId);
        jsSign.setNonceStr(noncestr);
        jsSign.setTimestamp(timestamp);
        jsSign.setSignature(signature);
        return jsSign;
    }
}

