/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.wechat.service.impl;

import com.baijia.wedo.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.wedo.dal.wechat.po.Fans;
import com.baijia.wedo.sal.wechat.dto.OpenPlatformInfoDto;
import com.baijia.wedo.sal.wechat.dto.WebAuthDto;
import com.baijia.wedo.sal.wechat.dto.WebAuthorizationDto;
import com.baijia.wedo.sal.wechat.enums.WebAuthScope;
import com.baijia.wedo.sal.wechat.helper.WechatWebAuthHelper;
import com.baijia.wedo.sal.wechat.helper.WechatWebAuthLinkBuilder;
import com.baijia.wedo.sal.wechat.service.WebAuthService;
import com.baijia.wedo.sal.wechat.util.WechatProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WebAuthServiceImpl
implements WebAuthService {
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;

    @Override
    @Transactional(readOnly=true)
    public Fans getWechatUserByWebAuthCode(WebAuthDto webAuthDto) {
        Fans fans = null;
        OpenPlatformInfoDto platformInfo = WechatProperties.getOpenPlatformInfo();
        WebAuthorizationDto webAuthorizationDto = WechatWebAuthHelper.getWebAuthorization(webAuthDto.getAppid(), webAuthDto.getCode(), platformInfo.getAppSecret());
        if (webAuthorizationDto != null) {
            fans = WechatWebAuthHelper.getUserInfoByWebAuth(webAuthorizationDto.getAccessToken(), webAuthorizationDto.getOpenid());
        }
        return fans;
    }

    @Override
    @Transactional(readOnly=true)
    public WebAuthorizationDto getWebAuthorizationDtoByWebAuthCode(WebAuthDto webAuthDto) {
        OpenPlatformInfoDto platformInfo = WechatProperties.getOpenPlatformInfo();
        return WechatWebAuthHelper.getWebAuthorization(webAuthDto.getAppid(), webAuthDto.getCode(), platformInfo.getAppSecret());
    }

    @Override
    @Transactional(readOnly=true)
    public String getFansinfoLink(String appId, String landingPage) {
        return WechatWebAuthLinkBuilder.fansinfo(WebAuthScope.BASE, appId, landingPage);
    }

    @Override
    @Transactional(readOnly=true)
    public String getFansinfoLink4UserInfoScope(String appId, String landingPage) {
        return WechatWebAuthLinkBuilder.fansinfo(WebAuthScope.USERINFO, appId, landingPage);
    }
}

