/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.wechat.service.impl;

import com.baijia.wedo.common.exception.wechat.MsgSendException;
import com.baijia.wedo.dal.wechat.po.AuthorizationInfo;
import com.baijia.wedo.sal.wechat.dto.OpenPlatformInfoDto;
import com.baijia.wedo.sal.wechat.dto.SendMsgRequest;
import com.baijia.wedo.sal.wechat.dto.WechatApiResponse;
import com.baijia.wedo.sal.wechat.helper.TemplateMsgHelper;
import com.baijia.wedo.sal.wechat.service.AuthorizationInfoService;
import com.baijia.wedo.sal.wechat.service.MsgSendService;
import com.baijia.wedo.sal.wechat.service.WechatMsgRenderService;
import com.baijia.wedo.sal.wechat.util.WechatProperties;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MsgSendServiceImpl
implements MsgSendService {
    private static final Logger log = LoggerFactory.getLogger(MsgSendServiceImpl.class);
    @Resource
    private WechatMsgRenderService wechatMsgSenderService;
    @Resource
    private AuthorizationInfoService authorizationInfoService;

    @Override
    public boolean sendMsg(SendMsgRequest request) throws MsgSendException {
        boolean sendResult = false;
        log.info("try to send msg by request:{}", (Object)request);
        String templateId = request.getTemplateType().getTemplateId();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{request.getWeixinOpenId()}) && StringUtils.isNotBlank((CharSequence)templateId)) {
            log.info("try to send msg by wechat:{}", request.getParams());
            try {
                request.getParams().put("touser", request.getWeixinOpenId());
                OpenPlatformInfoDto dto = WechatProperties.getOpenPlatformInfo();
                AuthorizationInfo authorizationInfo = this.authorizationInfoService.getByAuthorizerAppId(dto.getAppId());
                JSONObject json = (JSONObject)this.wechatMsgSenderService.render(templateId, request.getParams());
                WechatApiResponse result = TemplateMsgHelper.sendTemplateMsg(authorizationInfo.getAuthorizerAccessToken(), json.toString());
                log.info("sendMsg.result.{}", (Object)result);
            }
            catch (Exception e) {
                log.warn("send by wechat catch error:", (Throwable)e);
            }
        }
        return sendResult;
    }
}

