/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.wechat.service.impl;

import com.baijia.wedo.common.enums.WedoErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.exception.wechat.WechatException;
import com.baijia.wedo.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.wedo.dal.wechat.dao.FansDao;
import com.baijia.wedo.dal.wechat.po.AuthorizationInfo;
import com.baijia.wedo.dal.wechat.po.Fans;
import com.baijia.wedo.sal.wechat.helper.FansServiceApiHelper;
import com.baijia.wedo.sal.wechat.service.AuthorizationInfoService;
import com.baijia.wedo.sal.wechat.service.FansService;
import com.baijia.wedo.sal.wechat.util.WechatProperties;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FansServiceImpl
implements FansService {
    private static final Logger log = LoggerFactory.getLogger(FansServiceImpl.class);
    @Autowired
    private FansDao fansDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;

    @Override
    public Fans getFansDetail(String openId) {
        return this.fansDao.getByOpenId(openId);
    }

    @Override
    public void batchSaveFans(List<Fans> fansList) {
        this.fansDao.saveAll(fansList, new String[0]);
    }

    @Override
    public void saveOrUpdateFans(Fans fans) {
        this.fansDao.saveOrUpdate((Object)fans, new String[0]);
    }

    @Override
    public Fans getFans(String openId) {
        return this.fansDao.getByOpenId(openId);
    }

    @Override
    public Fans getAndSaveFans(String openId) {
        String authorizerAppId = WechatProperties.getOpenAppId();
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.getByAuthorizerAppId(authorizerAppId);
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        Fans fans = FansServiceApiHelper.getFansInfo(accessToken, openId);
        if (fans != null) {
            fans.setAuthorizerAppId(authorizerAppId);
            this.fansDao.save((Object)fans, new String[0]);
            return fans;
        }
        throw new BusinessException((UniverseErrorCode)WedoErrorCode.BUSINESS_ERROR, "\u8bf7\u5148\u5173\u6ce8\u5fae\u4fe1\u516c\u4f17\u53f7");
    }

    @Override
    public void syncFans(String authorizerAppId) {
        log.info("wechat - FansService - syncFans - start - authorizerAppId:{}", (Object)authorizerAppId);
        int fansNum = 0;
        int failNum = 0;
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.getByAuthorizerAppId(authorizerAppId);
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        List<String> openIds = FansServiceApiHelper.getAllFansOpenIdList(accessToken);
        int openIdSize = openIds == null ? 0 : openIds.size();
        log.info("wechat - FansService - syncFans - start - openIds size:{}", (Object)openIdSize);
        if (openIds != null && !openIds.isEmpty()) {
            fansNum = openIds.size();
            List<Object> tempOpendIds = Lists.newArrayList();
            for (int i = 0; i < openIds.size(); ++i) {
                tempOpendIds.add(openIds.get(i));
                if ((i == 0 || i % 100 != 0) && i != openIds.size() - 1) continue;
                Map openIdMap = this.fansDao.mapKeyOpenIdValueFans((List)tempOpendIds);
                ArrayList fansList = Lists.newArrayList();
                Fans fans = null;
                for (String tempOpenId : tempOpendIds) {
                    try {
                        fans = FansServiceApiHelper.getFansInfo(accessToken, tempOpenId);
                    }
                    catch (WechatException e) {
                        log.error("wechat - FansServiceImpl - syncFans - getFansInfo WechatException(all fail) - authorizerAppId:{},e:{}", (Object)authorizerAppId, (Object)e);
                        throw e;
                    }
                    catch (WebServiceException e) {
                        log.warn("wechat - FansServiceImpl - syncFans - getFansInfo Exception - authorizerAppId:{},openId:{},e:{}", new Object[]{authorizerAppId, tempOpenId, e});
                        ++failNum;
                        continue;
                    }
                    catch (Exception e) {
                        log.error("wechat - FansServiceImpl - syncFans - getFansInfo Exception - authorizerAppId:{},openId:{},e:{}", new Object[]{authorizerAppId, tempOpenId, e});
                        ++failNum;
                        continue;
                    }
                    if (fans == null) continue;
                    Fans dbFans = (Fans)openIdMap.get(tempOpenId);
                    if (dbFans == null) {
                        fans.initBasicAttribute();
                        fans.setAuthorizerAppId(authorizerAppId);
                        fans.setLastCommunicationTime(new Date(0L));
                        fansList.add(fans);
                        continue;
                    }
                    if (!(dbFans.getNick().equals(fans.getNick()) && dbFans.getHeadImgUrl().equals(fans.getHeadImgUrl()) && dbFans.getSubscribe().equals(fans.getSubscribe()))) {
                        fans.setId(dbFans.getId());
                        fans.setLastCommunicationTime(dbFans.getLastCommunicationTime());
                        fans.setSubscribe(Integer.valueOf(1));
                        fans.setUpdateTime(new Date());
                        this.fansDao.update((Object)fans, new String[0]);
                        continue;
                    }
                    Fans oldFans = this.fansDao.getByOpenId(tempOpenId);
                    if (oldFans.getSubscribe() != 0) continue;
                    oldFans.setSubscribe(Integer.valueOf(1));
                    oldFans.setUpdateTime(new Date());
                    this.fansDao.update((Object)oldFans, new String[0]);
                }
                try {
                    this.batchSaveFans(fansList);
                }
                catch (Exception e) {
                    log.warn("wechat - FansServiceImpl - fans batch insert fail", (Throwable)e);
                }
                tempOpendIds = Collections.emptyList();
            }
        }
        log.info("wechat - FansService - syncFans - end - authorizerAppId:{}, fansNum:{}, failNum:{}", new Object[]{authorizerAppId, fansNum, failNum});
    }
}

