/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.wechat.helper;

import com.baijia.wedo.dal.wechat.po.Fans;
import com.baijia.wedo.sal.wechat.dto.WebAuthorizationDto;
import com.baijia.wedo.sal.wechat.dto.WechatApiResponse;
import com.baijia.wedo.sal.wechat.util.WechatWebAuthCaller;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatWebAuthHelper {
    private static final Logger log = LoggerFactory.getLogger(WechatWebAuthHelper.class);

    public static WebAuthorizationDto getWebAuthorization(String appId, String code, String secret) {
        WebAuthorizationDto dto = null;
        WechatApiResponse result = WechatWebAuthCaller.getWebAuthorization(appId, code, secret);
        if (!result.isError()) {
            dto = WebAuthorizationDto.fromJson(result.getJsonStr());
        } else {
            log.warn("wechat - getWebAuthorizationDtoByWebAuthCode - fail - json:{}", (Object)result);
        }
        return dto;
    }

    public static Fans getUserInfoByWebAuth(String webAuthAccessToken, String openId) {
        Fans fans = null;
        WechatApiResponse result = WechatWebAuthCaller.getUserInfoByWebAuth(webAuthAccessToken, openId);
        if (!result.isError()) {
            fans = new Fans();
            JSONObject rootNode = result.getRootJSONObj();
            fans.setOpenId(rootNode.getString("openid"));
            fans.setNick(rootNode.optString("nickname", ""));
            fans.setHeadImgUrl(rootNode.optString("headimgurl", ""));
            fans.setSex(Integer.valueOf(rootNode.optInt("sex", 0)));
            fans.setCity(rootNode.optString("city", ""));
            fans.setProvince(rootNode.optString("province", ""));
            fans.setCountry(rootNode.optString("country", ""));
        } else {
            log.warn("wechat - getWechatUserByWebAuthCode - fail - json:{}", (Object)result);
        }
        return fans;
    }
}

