/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.wechat.helper;

import com.baijia.wedo.common.util.DateUtil;
import com.baijia.wedo.dal.wechat.po.Fans;
import com.baijia.wedo.sal.wechat.dto.WechatApiResponse;
import com.baijia.wedo.sal.wechat.helper.FansServiceApiCaller;
import com.baijia.wedo.sal.wechat.helper.WechatRemoteCallHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class FansServiceApiHelper {
    public static Fans getFansInfo(String accessToken, String openId) {
        HashMap<String, Object> params;
        Fans fans = new Fans();
        String url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=" + accessToken + "&openid=" + openId + "&lang=zh_CN";
        WechatApiResponse response = WechatRemoteCallHelper.postJson(url, params = new HashMap<String, Object>());
        JSONObject rootNode = response.getRootJSONObj();
        if (rootNode.getInt("subscribe") == 0) {
            return null;
        }
        fans.setCity(rootNode.optString("city", ""));
        fans.setCountry(rootNode.optString("country", ""));
        fans.setGroupId(Integer.valueOf(rootNode.optInt("groupid", -1)));
        fans.setHeadImgUrl(rootNode.optString("headimgurl", ""));
        fans.setLanguage(rootNode.optString("language", ""));
        fans.setNick(rootNode.optString("nickname", ""));
        fans.setOpenId(rootNode.getString("openid"));
        fans.setProvince(rootNode.optString("province", ""));
        fans.setRemark(rootNode.optString("remark", ""));
        fans.setSex(Integer.valueOf(rootNode.optInt("sex", 1)));
        fans.setSubscribe(Integer.valueOf(rootNode.getInt("subscribe")));
        fans.setSubscribeTime(DateUtil.UnixTimestamp2Date((long)rootNode.getLong("subscribe_time")));
        return fans;
    }

    public static List<String> getAllFansOpenIdList(String accessToken) {
        int i;
        ArrayList<String> openIds = new ArrayList<String>();
        WechatApiResponse response = FansServiceApiCaller.getFansOpenIdList(accessToken, null);
        JSONObject rootNode = response.getRootJSONObj();
        String nextOpenId = rootNode.optString("next_openid");
        if (StringUtils.isBlank((CharSequence)nextOpenId)) {
            return openIds;
        }
        JSONObject data = rootNode.getJSONObject("data");
        JSONArray openIdArray = data.getJSONArray("openid");
        if (openIdArray != null && openIdArray.size() > 0) {
            for (i = 0; i < openIdArray.size(); ++i) {
                openIds.add(openIdArray.getString(i));
            }
        }
        while (StringUtils.isNotBlank((CharSequence)nextOpenId) && !StringUtils.isBlank((CharSequence)(nextOpenId = (rootNode = (response = FansServiceApiCaller.getFansOpenIdList(accessToken, nextOpenId)).getRootJSONObj()).optString("next_openid")))) {
            data = rootNode.getJSONObject("data");
            openIdArray = data.getJSONArray("openid");
            if (openIdArray == null || openIdArray.size() <= 0) continue;
            for (i = 0; i < openIdArray.size(); ++i) {
                openIds.add(openIdArray.getString(i));
            }
        }
        return openIds;
    }

    public static WechatApiResponse remark(String accessToken, String openId, String remark) {
        return FansServiceApiCaller.remark(accessToken, openId, remark);
    }

    public static int getFansCount(String accessToken) {
        WechatApiResponse response = FansServiceApiCaller.getFansOpenIdList(accessToken, null);
        JSONObject rootNode = response.getRootJSONObj();
        return rootNode.optInt("total", 0);
    }
}

