/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.upload.service.impl;

import com.baijia.wedo.common.cache.CacheClient;
import com.baijia.wedo.common.enums.AutoAllocClueType;
import com.baijia.wedo.common.enums.OpRecordType;
import com.baijia.wedo.common.enums.ShowInfoType;
import com.baijia.wedo.common.errorcode.CommonErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.model.BaseLoginUser;
import com.baijia.wedo.common.model.IdAndNameDto;
import com.baijia.wedo.common.model.UploadResult;
import com.baijia.wedo.common.util.JacksonUtil;
import com.baijia.wedo.common.util.LoginUtil;
import com.baijia.wedo.common.util.upload.ExcelExporterUtils;
import com.baijia.wedo.common.util.upload.FileUploadUtils;
import com.baijia.wedo.common.util.upload.StorageUtil;
import com.baijia.wedo.dal.system.dao.SchoolDao;
import com.baijia.wedo.dal.upload.dao.UploadRecordDao;
import com.baijia.wedo.dal.upload.po.UploadRecord;
import com.baijia.wedo.sal.oprecord.service.OpRecordService;
import com.baijia.wedo.sal.upload.dto.TaskStatus;
import com.baijia.wedo.sal.upload.service.ImportDataProcessService;
import com.baijia.wedo.sal.upload.service.UploadFileReaderService;
import com.baijia.wedo.sal.upload.service.UploadService;
import com.baijia.wedo.sal.upload.service.impl.CsvUploadFileReaderServiceImpl;
import com.baijia.wedo.sal.upload.service.impl.ExcelUploadFileReaderServiceImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UploadServiceImpl
implements UploadService,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(UploadServiceImpl.class);
    private Map<Integer, ImportDataProcessService> dataProcessServiceMap;
    private ApplicationContext context;
    @Resource
    private CacheClient cacheClient;
    @Autowired
    private OpRecordService opRecordService;
    private ExecutorService uploadTaskExecutor = Executors.newFixedThreadPool(10, new ThreadFactory(){
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "UPLOAD_TASK_" + this.threadNumber.getAndIncrement());
            return t;
        }
    });
    @Resource
    private UploadRecordDao uploadRecordsDao;
    @Resource
    private SchoolDao schoolDao;

    @Override
    public long uploadFile(final Long schoolId, final Long marketId, final Integer autoAllocClueType, final int uploadType, MultipartFile file) throws IOException {
        Preconditions.checkArgument((schoolId != null && schoolId > 0L ? 1 : 0) != 0, (Object)"schoolId is illegal");
        Preconditions.checkNotNull((Object)uploadType, (Object)"upload type can not be null");
        Preconditions.checkArgument((file != null && !file.isEmpty() ? 1 : 0) != 0, (Object)"upload file is null");
        BaseLoginUser currentUser = LoginUtil.getCurrentUser();
        final Long operatorId = currentUser.getUserId();
        final UploadRecord uploadRecord = new UploadRecord();
        uploadRecord.setFileName(file.getOriginalFilename());
        uploadRecord.setStatus(0);
        uploadRecord.setOperatorId(operatorId);
        uploadRecord.setUploadType(uploadType);
        this.uploadRecordsDao.save((Object)uploadRecord, new String[0]);
        final IdAndNameDto opUser = new IdAndNameDto(operatorId, currentUser.getUserName());
        final Long taskId = uploadRecord.getId();
        final UploadFileReaderService service = this.getUploadFileService(file);
        this.uploadTaskExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                log.info("start to execute upload task:{}", (Object)taskId);
                ImportDataProcessService processService = (ImportDataProcessService)UploadServiceImpl.this.dataProcessServiceMap.get(uploadType);
                TaskStatus taskStatus = new TaskStatus();
                UploadServiceImpl.this.storeCache(taskId, taskStatus);
                try {
                    if (UploadServiceImpl.this.schoolDao.querySchoolById(schoolId.longValue(), new String[0]) == null) {
                        taskStatus.setException((Exception)((Object)new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6821\u533a\u4e0d\u5b58\u5728")));
                    }
                    if (autoAllocClueType != null && AutoAllocClueType.get((int)autoAllocClueType) == null) {
                        taskStatus.setException((Exception)((Object)new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6570\u636e\u5bfc\u5165\u6d41\u8f6c\u65b9\u5f0f\u4e0d\u5b58\u5728")));
                    }
                    processService.initialData();
                    List headers = UploadServiceImpl.this.tranHeader(service.readData());
                    taskStatus.setHeaders(headers);
                    taskStatus.setTotalCount(service.getDataLength());
                    log.debug("procesService:{},map:{},headers:{}", new Object[]{processService, UploadServiceImpl.this.dataProcessServiceMap, headers});
                    if (CollectionUtils.isEmpty((Collection)headers) || !processService.validateHeader(headers)) {
                        taskStatus.setException((Exception)((Object)new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0a\u4f20\u6587\u4ef6\u7684\u8868\u5934\u4fe1\u606f\u4e0d\u6b63\u786e!")));
                        log.warn("upload file header:{} is invalidate", (Object)taskStatus);
                        UploadServiceImpl.this.storeCache(taskId, taskStatus);
                        return;
                    }
                    Object[] lineData = null;
                    ImportDataProcessService.SingleSaveErrorResult saveResult = null;
                    ArrayList failDatas = Lists.newArrayList();
                    ArrayList repeatDatas = Lists.newArrayList();
                    int i = 0;
                    while ((lineData = service.readData()) != null) {
                        Object[] eData;
                        try {
                            saveResult = processService.saveSingleData(schoolId, marketId, autoAllocClueType, headers, lineData, operatorId);
                            if (saveResult == null || StringUtils.isBlank((CharSequence)saveResult.getErrorMsg()) || saveResult.isSuccess()) {
                                taskStatus.increaseSuccessCount();
                            } else {
                                taskStatus.increaseFailCount();
                                failDatas.add(lineData);
                            }
                        }
                        catch (BusinessException e) {
                            log.warn("save data:{} ,catch error:{}", (Object)ToStringBuilder.reflectionToString((Object)lineData), (Object)e.getMessage());
                            eData = UploadServiceImpl.this.arrayCopy(lineData, e.getMessage());
                            failDatas.add(eData);
                            log.error("save data catch error:", (Throwable)e);
                            taskStatus.increaseFailCount();
                        }
                        catch (Exception e) {
                            log.warn("save data:{} ,catch error:{}", (Object)ToStringBuilder.reflectionToString((Object)lineData), (Object)e.getMessage());
                            eData = UploadServiceImpl.this.arrayCopy(lineData, "\u672a\u77e5");
                            failDatas.add(eData);
                            log.error("save data catch error:", (Throwable)e);
                            taskStatus.increaseFailCount();
                        }
                        if (++i % 10 == 0 && taskStatus.getCompleteCount() < taskStatus.getTotalCount()) {
                            UploadServiceImpl.this.processResultStore(uploadRecord, taskStatus, null, false);
                        }
                        UploadServiceImpl.this.storeCache(taskId, taskStatus);
                    }
                    if (taskStatus.getCompleteCount() == 0) {
                        taskStatus.setException((Exception)((Object)new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6587\u4ef6\u6570\u636e\u4e3a\u7a7a")));
                    }
                    log.info("upload.totalCount:{}", (Object)taskStatus.getCompleteCount());
                    try {
                        if (taskStatus.getCompleteCount() > 0 && uploadType == ShowInfoType.CLUE.getCode()) {
                            UploadServiceImpl.this.addImportOpRecord(OpRecordType.IMPORT_CLUE, taskStatus.getCompleteCount(), opUser);
                        }
                    }
                    catch (Exception e) {
                        log.warn("save import clue op record failed");
                    }
                    taskStatus.setTotalCount(taskStatus.getCompleteCount());
                    headers.add("\u9519\u8bef\u539f\u56e0");
                    UploadServiceImpl.this.processResultStore(uploadRecord, taskStatus, UploadServiceImpl.this.generateErrorExcel(operatorId, headers, repeatDatas, failDatas), true);
                }
                catch (Exception e) {
                    log.warn("read data catch error:", (Throwable)e);
                    taskStatus.setException((Exception)((Object)new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfb\u53d6\u6587\u4ef6\u9519\u8bef")));
                }
                finally {
                    UploadServiceImpl.this.storeCache(taskId, taskStatus);
                    service.close();
                }
            }
        });
        return taskId;
    }

    Object[] arrayCopy(Object[] lineData, String addData) {
        Object[] eData = new Object[lineData.length + 1];
        System.arraycopy(lineData, 0, eData, 0, lineData.length);
        eData[lineData.length] = addData;
        return eData;
    }

    void addImportOpRecord(OpRecordType opType, int totalCount, IdAndNameDto opUser) {
        String content = String.format(opType.getContent(), totalCount);
        log.info("addImportOpRecord.opUser:{}, opType:{}, content:{}", new Object[]{opUser, opType, content});
        this.opRecordService.addOpRecord(Long.valueOf(0L), opType, content, opUser);
    }

    private void storeCache(Long taskId, TaskStatus taskStatus) {
        try {
            this.cacheClient.set(taskId.toString(), (Object)JacksonUtil.obj2Str((Object)taskStatus));
        }
        catch (Exception e) {
            log.warn("store cache catch error:{}", (Throwable)e);
        }
    }

    private String generateErrorExcel(Long operatorId, List<String> headers, List<Object[]> repeatDatas, List<Object[]> failDatas) throws IOException {
        String string;
        if (CollectionUtils.isEmpty(repeatDatas) && CollectionUtils.isEmpty(failDatas)) {
            return "";
        }
        SXSSFWorkbook workBook = null;
        FileOutputStream os = null;
        File excelFile = null;
        try {
            File execelFolder;
            Sheet sheet;
            workBook = new SXSSFWorkbook(100);
            HashMap cellStyleMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(repeatDatas)) {
                sheet = workBook.createSheet("\u91cd\u590d\u4fe1\u606f\u8868");
                ExcelExporterUtils.fillSheet((Sheet)sheet, headers, repeatDatas, (Map)cellStyleMap);
            }
            if (CollectionUtils.isNotEmpty(failDatas)) {
                sheet = workBook.createSheet("\u9519\u8bef\u4fe1\u606f\u8868");
                ExcelExporterUtils.fillSheet((Sheet)sheet, headers, failDatas, (Map)cellStyleMap);
            }
            if (!(execelFolder = new File("/tmp/tianxiao-export")).exists()) {
                execelFolder.mkdirs();
            }
            excelFile = new File(execelFolder, System.currentTimeMillis() + ".xlsx");
            excelFile.createNewFile();
            os = new FileOutputStream(excelFile);
            workBook.write((OutputStream)os);
            UploadResult.UploadFile uploadFile = FileUploadUtils.uploadToRemote((Long)operatorId, (File)excelFile, (boolean)false);
            string = StorageUtil.constructUrl((String)uploadFile.getUrl());
        }
        catch (IOException e) {
            try {
                log.error("write error data to excel catch error:", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                IOUtils.closeQuietly((Closeable)workBook);
                if (excelFile != null) {
                    excelFile.deleteOnExit();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((Closeable)workBook);
        if (excelFile != null) {
            excelFile.deleteOnExit();
        }
        return string;
    }

    private void processResultStore(UploadRecord uploadRecord, TaskStatus taskStatus, String fileUrl, boolean isComplete) {
        uploadRecord.setFailCount(taskStatus.getFailCount());
        uploadRecord.setRepeatCount(taskStatus.getRepeatCount());
        uploadRecord.setSuccessCount(taskStatus.getSuccessCount());
        uploadRecord.setTotalCount(taskStatus.getTotalCount() - 1);
        if (isComplete) {
            String errorFileUrl = fileUrl == null ? "" : fileUrl;
            uploadRecord.setErrorFileUrl(errorFileUrl);
            taskStatus.setErrorFileUrl(errorFileUrl);
            uploadRecord.setStatus(1);
        }
        this.uploadRecordsDao.update((Object)uploadRecord, new String[0]);
    }

    private List<String> tranHeader(Object[] headerObjs) {
        Preconditions.checkArgument((boolean)ArrayUtils.isNotEmpty((Object[])headerObjs), (Object)"\u5934\u4fe1\u606f\u4e3a\u7a7a");
        ArrayList headers = Lists.newArrayList();
        for (Object obj : headerObjs) {
            if (obj != null) {
                headers.add(obj.toString());
                continue;
            }
            headers.add("-");
        }
        return headers;
    }

    private UploadFileReaderService getUploadFileService(MultipartFile file) {
        UploadFileReaderService service = null;
        String fileName = file.getOriginalFilename();
        if (fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsx")) {
            service = new ExcelUploadFileReaderServiceImpl(file);
        } else if (fileName.toLowerCase().endsWith(".csv")) {
            service = new CsvUploadFileReaderServiceImpl(file, false);
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, fileName + "\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301,\u53ea\u652f\u6301CSV\u548cexcel\u6587\u4ef6");
        }
        return service;
    }

    @Override
    public TaskStatus getUploadStatus(Long taskId) {
        Preconditions.checkArgument((taskId != null && taskId > 0L ? 1 : 0) != 0, (Object)"taskId is illegal");
        String value = (String)this.cacheClient.get(taskId.toString());
        if (StringUtils.isBlank((CharSequence)value)) {
            return new TaskStatus(null, 0);
        }
        TaskStatus taskStatus = null;
        try {
            taskStatus = (TaskStatus)JacksonUtil.str2Obj((String)value, TaskStatus.class);
            taskStatus.getCompleteRate();
        }
        catch (IOException e) {
            log.error("deserilize error:", (Throwable)e);
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
        }
        return taskStatus;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.dataProcessServiceMap = Maps.newHashMap();
        Map serviceMap = this.context.getBeansOfType(ImportDataProcessService.class);
        for (ImportDataProcessService service : serviceMap.values()) {
            this.dataProcessServiceMap.put(service.getProcessType().getCode(), service);
        }
    }

    @Override
    public String getErrorFileUrl(Long taskId) {
        Preconditions.checkArgument((taskId != null && taskId > 0L ? 1 : 0) != 0, (Object)"taskId is illegal");
        UploadRecord uploadRecord = (UploadRecord)this.uploadRecordsDao.getById((Serializable)taskId, new String[]{"errorFileUrl"});
        return uploadRecord.getErrorFileUrl();
    }
}

