/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.upload.service.impl;

import com.baijia.wedo.common.enums.MIMEType;
import com.baijia.wedo.common.model.UploadResult;
import com.baijia.wedo.common.util.FileUtil;
import com.baijia.wedo.common.util.upload.FileUploadUtils;
import com.baijia.wedo.common.util.upload.StorageUtil;
import com.baijia.wedo.dal.upload.dao.StorageDao;
import com.baijia.wedo.dal.upload.po.Storage;
import com.baijia.wedo.sal.upload.dto.UploadResultDto;
import com.baijia.wedo.sal.upload.service.StorageService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StorageServiceImpl
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(StorageServiceImpl.class);
    @Autowired
    private StorageDao storageDao;

    @Override
    public List<UploadResultDto> storage(Map<String, File> files, Long uid, boolean watermark) {
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(files), (Object)"files is null");
        Preconditions.checkArgument((uid != null ? 1 : 0) != 0, (Object)"uid is null");
        UploadResult uploadResult = FileUploadUtils.uploadFiles((Long)uid, files, (boolean)watermark);
        if (CollectionUtils.isNotEmpty((Collection)uploadResult.getFiles())) {
            ArrayList result = Lists.newArrayList();
            for (UploadResult.UploadFile uploadFile : uploadResult.getFiles()) {
                String extension = FileUtil.getFormatedExtension((String)uploadFile.getUrl());
                MIMEType mimeType = MIMEType.getType((String)extension);
                result.add(this.saveToStorage(uploadFile, mimeType));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public UploadResultDto storage(File file, Long uid, boolean watermark) {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"file is null");
        Preconditions.checkArgument((uid != null ? 1 : 0) != 0, (Object)"uid is null");
        String extension = FileUtil.getFormatedExtension((String)file.getName());
        MIMEType mimeType = MIMEType.getType((String)extension);
        Preconditions.checkArgument((mimeType != null ? 1 : 0) != 0, (String)"can not get mimetype from file %s", (Object[])new Object[]{file.getName()});
        UploadResult.UploadFile uploadFile = FileUploadUtils.uploadToRemote((Long)uid, (File)file, (boolean)watermark);
        if (uploadFile == null) {
            log.warn("upload fail result is empty");
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519.");
        }
        return this.saveToStorage(uploadFile, mimeType);
    }

    private UploadResultDto saveToStorage(UploadResult.UploadFile uploadFile, MIMEType mimeType) {
        UploadResultDto result = new UploadResultDto();
        Storage storage = new Storage();
        storage.setCreateTime(new Date());
        storage.setFid(uploadFile.getFid());
        storage.setSize(Integer.valueOf(uploadFile.getSize()));
        storage.setSn(uploadFile.getSn());
        storage.setMimetype(mimeType.getCode());
        storage.setUpdateTime(new Date());
        this.storageDao.save((Object)storage, new String[0]);
        log.info("success save upload result:{}", (Object)storage);
        result.setStorageId((long)storage.getId());
        result.setUrl(StorageUtil.constructUrl((String)uploadFile.getFid(), (String)uploadFile.getSn(), (MIMEType)mimeType));
        return result;
    }
}

