/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.student.service.impl;

import com.baijia.wedo.common.enums.WedoErrorCode;
import com.baijia.wedo.common.enums.YesOrNoType;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.model.BaseLoginUser;
import com.baijia.wedo.common.util.LoginUtil;
import com.baijia.wedo.dal.student.dao.StudentDao;
import com.baijia.wedo.dal.student.dao.TeachGoalDao;
import com.baijia.wedo.dal.student.po.Student;
import com.baijia.wedo.dal.student.po.StudentTeachGoal;
import com.baijia.wedo.sal.student.dto.teach.TeachGoalBase;
import com.baijia.wedo.sal.student.dto.teach.TeachGoalResp;
import com.baijia.wedo.sal.student.service.TeachGoalService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TeachGoalServiceImpl
implements TeachGoalService {
    @Autowired
    private TeachGoalDao teachGoaldDao;
    @Autowired
    private StudentDao studentDao;

    @Override
    @Transactional(readOnly=true)
    public TeachGoalResp getStudentTeachGoal(long studentId) {
        StudentTeachGoal teachGoal = this.teachGoaldDao.getTeachGoalByStudent(studentId);
        TeachGoalResp studentTeachGoalResp = new TeachGoalResp();
        if (teachGoal != null) {
            TeachGoalResp.toDto(teachGoal, studentTeachGoalResp);
            if (studentTeachGoalResp.getIsAssure().intValue() == YesOrNoType.YES.getType()) {
                studentTeachGoalResp.setIsAssureStr("\u5df2\u7ecf\u53c2\u52a0\u4fdd\u5206\u534f\u8bae");
            } else {
                studentTeachGoalResp.setIsAssureStr("\u672a\u53c2\u52a0\u4fdd\u5206\u534f\u8bae");
            }
        } else {
            return null;
        }
        return studentTeachGoalResp;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long addStudentTeachGoal(TeachGoalBase teachGoal) {
        BaseLoginUser user = LoginUtil.getCurrentUser();
        if (teachGoal.getStudentId() == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u5b66\u5458\u4e3a\u7a7a");
        }
        Student student = this.studentDao.getStudentById(teachGoal.getStudentId().longValue());
        if (student == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u5b66\u5458\u4e0d\u5b58\u5728");
        }
        StudentTeachGoal studentTeachGoal = this.teachGoaldDao.getTeachGoalByStudent(student.getId().longValue());
        if (studentTeachGoal == null) {
            studentTeachGoal = new StudentTeachGoal();
            TeachGoalBase.toTeachGoal(studentTeachGoal, teachGoal);
            studentTeachGoal.setCreateTime(new Date());
            studentTeachGoal.setUpdateTime(new Date());
            studentTeachGoal.setCreatorId(user.getUserId().longValue());
            this.teachGoaldDao.save((Object)studentTeachGoal, new String[0]);
        } else {
            TeachGoalBase.toTeachGoal(studentTeachGoal, teachGoal);
            studentTeachGoal.setUpdateTime(new Date());
            this.teachGoaldDao.update((Object)studentTeachGoal, new String[0]);
        }
        return studentTeachGoal.getId();
    }
}

