/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.student.service.impl;

import com.baijia.wedo.common.errorcode.CommonErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.util.JacksonUtil;
import com.baijia.wedo.dal.student.dao.StudentExamPlanDao;
import com.baijia.wedo.dal.student.po.StudentExamPlan;
import com.baijia.wedo.sal.student.service.StudentExamPlanService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StudentExamPlanServiceImpl
implements StudentExamPlanService {
    @Autowired
    private StudentExamPlanDao studentExamPlanDao;

    @Override
    public Long saveOrUpdate(StudentExamPlan plan) {
        if (plan != null) {
            Long id = plan.getId();
            if (id != null && id > 0L) {
                this.studentExamPlanDao.delById((Serializable)id);
            }
            plan.setId(null);
            plan.setContent(JacksonUtil.obj2Str((Object)plan.getPlans()));
            plan.setCreateTime(new Date());
            this.studentExamPlanDao.save((Object)plan, new String[0]);
            return plan.getId();
        }
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u586b\u5199\u5b66\u4e60\u8ba1\u5212");
    }

    @Override
    public StudentExamPlan getExamPlanDetail(long id) {
        StudentExamPlan plan = (StudentExamPlan)this.studentExamPlanDao.getById((Serializable)Long.valueOf(id), new String[0]);
        if (plan != null) {
            StudentExamPlan.toDto((StudentExamPlan)plan);
        }
        return plan;
    }

    @Override
    public List<StudentExamPlan> getStudentExamPlans(long studentId) {
        List plans = this.studentExamPlanDao.getStudentExamPlans(Long.valueOf(studentId));
        if (CollectionUtils.isNotEmpty((Collection)plans)) {
            for (StudentExamPlan plan : plans) {
                StudentExamPlan.toDto((StudentExamPlan)plan);
            }
        }
        return plans;
    }
}

