/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.student.service.impl;

import com.baijia.component.permission.enums.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.wedo.common.enums.ApplyType;
import com.baijia.wedo.common.enums.AuditStatus;
import com.baijia.wedo.common.enums.ChannelType;
import com.baijia.wedo.common.enums.ClueStatus;
import com.baijia.wedo.common.enums.ClueType;
import com.baijia.wedo.common.enums.ConsultStatus;
import com.baijia.wedo.common.enums.GenderType;
import com.baijia.wedo.common.enums.OceanClueType;
import com.baijia.wedo.common.enums.OpRecordType;
import com.baijia.wedo.common.enums.RelationType;
import com.baijia.wedo.common.enums.StudyPhase;
import com.baijia.wedo.common.enums.UserRole;
import com.baijia.wedo.common.enums.WedoErrorCode;
import com.baijia.wedo.common.enums.YesOrNoType;
import com.baijia.wedo.common.errorcode.CommonErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.model.BaseLoginUser;
import com.baijia.wedo.common.model.IdAndNameDto;
import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.common.util.DateUtil;
import com.baijia.wedo.common.util.LoginUtil;
import com.baijia.wedo.dal.edu.dao.course.SubjectDao;
import com.baijia.wedo.dal.edu.po.Subject;
import com.baijia.wedo.dal.message.dao.AuditRecordDao;
import com.baijia.wedo.dal.message.po.AuditRecord;
import com.baijia.wedo.dal.student.dao.ClueDao;
import com.baijia.wedo.dal.student.dao.StudentCommentDao;
import com.baijia.wedo.dal.student.dao.StudentDao;
import com.baijia.wedo.dal.student.po.Student;
import com.baijia.wedo.dal.system.dao.BackLogDao;
import com.baijia.wedo.dal.system.dao.BackLogUserListDao;
import com.baijia.wedo.dal.system.dao.SchoolDao;
import com.baijia.wedo.dal.system.po.School;
import com.baijia.wedo.dal.user.dao.UserDao;
import com.baijia.wedo.dal.user.po.User;
import com.baijia.wedo.dal.wechat.dao.WechatMobileDao;
import com.baijia.wedo.dal.wechat.po.WechatMobile;
import com.baijia.wedo.sal.oprecord.service.OpRecordService;
import com.baijia.wedo.sal.student.dto.CallMobileRespDto;
import com.baijia.wedo.sal.student.dto.ClueAuditDetailDto;
import com.baijia.wedo.sal.student.dto.ClueListReqDto;
import com.baijia.wedo.sal.student.dto.ClueMergeBaseReq;
import com.baijia.wedo.sal.student.dto.ClueMergeMapDto;
import com.baijia.wedo.sal.student.dto.ClueMergeReqDto;
import com.baijia.wedo.sal.student.dto.ClueMergeRespDto;
import com.baijia.wedo.sal.student.dto.RepeatClueRespDto;
import com.baijia.wedo.sal.student.dto.StudentBaseDto;
import com.baijia.wedo.sal.student.dto.StudentListReqDto;
import com.baijia.wedo.sal.student.dto.StudentListResponseDto;
import com.baijia.wedo.sal.student.service.StudentCommonService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StudentCommonServiceImpl
implements StudentCommonService {
    private static final Logger log = LoggerFactory.getLogger(StudentCommonServiceImpl.class);
    @Autowired
    private ClueDao clueDao;
    @Autowired
    private StudentDao studentDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private SchoolDao schoolDao;
    @Autowired
    private SubjectDao subjectDao;
    @Autowired
    private StudentCommentDao studentCommentDao;
    @Autowired
    private BackLogDao backLogDao;
    @Autowired
    private BackLogUserListDao backLogUserListDao;
    @Autowired
    private OpRecordService opRecordService;
    @Autowired
    private AuditRecordDao auditRecordDao;
    @Autowired
    private WechatMobileDao wechatMobileDao;

    @Override
    public void checkClueOrStudentRepeat(List<StudentListResponseDto> dtos) {
        HashSet mobiles = Sets.newHashSet();
        for (StudentBaseDto studentBaseDto : dtos) {
            mobiles.add(studentBaseDto.getMobile());
            if (StringUtils.isNotBlank((CharSequence)studentBaseDto.getContacts2Mobile())) {
                mobiles.add(studentBaseDto.getContacts2Mobile());
            }
            if (!StringUtils.isNotBlank((CharSequence)studentBaseDto.getContactsMobile())) continue;
            mobiles.add(studentBaseDto.getContactsMobile());
        }
        Map mobileCountMap = this.clueDao.getCountByMobiles((Set)mobiles);
        for (StudentBaseDto studentBaseDto : dtos) {
            if (StringUtils.isNotBlank((CharSequence)studentBaseDto.getMobile()) && (Integer)mobileCountMap.get(studentBaseDto.getMobile()) > 1) {
                studentBaseDto.setHasRepeat(true);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)studentBaseDto.getContactsMobile()) && (Integer)mobileCountMap.get(studentBaseDto.getContactsMobile()) > 1) {
                studentBaseDto.setHasRepeat(true);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)studentBaseDto.getContacts2Mobile()) || (Integer)mobileCountMap.get(studentBaseDto.getContacts2Mobile()) <= 1) continue;
            studentBaseDto.setHasRepeat(true);
        }
    }

    @Override
    public List<StudentListResponseDto> getClueListByParams(ClueListReqDto dto, PageDto page) {
        List students;
        HashMap params = Maps.newHashMap();
        if (dto.getChannelType() != null) {
            params.put("channelType", dto.getChannelType());
        }
        if (dto.getConsultStatus() != null) {
            params.put("consultStatus", dto.getConsultStatus());
        }
        if (dto.getMobile() != null) {
            params.put("mobile", dto.getMobile());
        }
        if (dto.getName() != null) {
            params.put("name", dto.getName());
        }
        if (dto.getStudyPhase() != null) {
            params.put("studyPhase", dto.getStudyPhase());
        }
        if (dto.getTmkId() != null) {
            params.put("tmkId", dto.getTmkId());
        }
        if (dto.getAdviserId() != null) {
            params.put("adviserId", dto.getAdviserId());
        }
        if (dto.getSchoolId() != null) {
            params.put("schoolId", dto.getSchoolId());
        }
        if (CollectionUtils.isNotEmpty(dto.getUserSchoolIds())) {
            params.put("userSchoolIds", dto.getUserSchoolIds());
        }
        if (dto.getOceanClueType() != null) {
            params.put("oceanClueType", dto.getOceanClueType());
        }
        if (CollectionUtils.isNotEmpty(dto.getUserIds())) {
            params.put("userIds", dto.getUserIds());
        }
        if (dto.getStatus() != null) {
            params.put("status", dto.getStatus());
        }
        if (dto.getClueType() != null) {
            params.put("clueType", dto.getClueType());
        }
        if (dto.getMarketId() != null) {
            params.put("marketId", dto.getMarketId());
        }
        if (dto.getCanRecommend() != null) {
            params.put("canRecommend", dto.getCanRecommend());
        }
        if (dto.getHasIntermediary() != null) {
            params.put("hasIntermediary", dto.getHasIntermediary());
        }
        if (dto.getStartTime() != null && dto.getEndTime() != null) {
            params.put("startTime", dto.getStartTime());
            params.put("endTime", dto.getEndTime());
        }
        if (CollectionUtils.isEmpty((Collection)(students = this.clueDao.getClueListParams((Map)params, page)))) {
            return Lists.newArrayList();
        }
        return this.wrapResult(students);
    }

    @Override
    public List<StudentListResponseDto> getWechatClueListByParams(ClueListReqDto dto, PageDto page) {
        HashMap params = Maps.newHashMap();
        if (dto.getName() != null) {
            params.put("name", dto.getName());
        }
        if (CollectionUtils.isNotEmpty(dto.getUserIds())) {
            params.put("userIds", dto.getUserIds());
        }
        params.put("status", dto.getStatus());
        params.put("clueType", dto.getClueType());
        List students = this.clueDao.getWechatClueListParams((Map)params, page);
        if (CollectionUtils.isEmpty((Collection)students)) {
            return Lists.newArrayList();
        }
        return this.wrapResult(students);
    }

    @Override
    public List<StudentListResponseDto> getStudentListByParams(StudentListReqDto dto, PageDto page) {
        List students;
        HashMap params = Maps.newHashMap();
        if (dto.getMobile() != null) {
            params.put("mobile", dto.getMobile());
        }
        if (dto.getName() != null) {
            params.put("name", dto.getName());
        }
        if (dto.getAssistantId() != null) {
            params.put("assistantId", dto.getAssistantId());
        }
        if (dto.getSchoolId() != null) {
            params.put("schoolId", dto.getSchoolId());
        }
        if (dto.getBrowseType() != null) {
            params.put("browseType", dto.getBrowseType());
        }
        if (CollectionUtils.isNotEmpty(dto.getUserSchoolIds())) {
            params.put("userSchoolIds", dto.getUserSchoolIds());
        }
        if (CollectionUtils.isNotEmpty(dto.getUserIds())) {
            params.put("userIds", dto.getUserIds());
        }
        if (dto.getBindWechat() != null) {
            params.put("bindWechat", dto.getBindWechat());
        }
        if (dto.getCanRecommend() != null) {
            params.put("canRecommend", dto.getCanRecommend());
        }
        if (dto.getHasIntermediary() != null) {
            params.put("hasIntermediary", dto.getHasIntermediary());
        }
        if (dto.getMarketId() != null) {
            params.put("marketId", dto.getMarketId());
        }
        if (dto.getAdviserId() != null) {
            params.put("adviserId", dto.getAdviserId());
        }
        if (dto.getStartTime() != null && dto.getEndTime() != null) {
            params.put("startTime", dto.getStartTime());
            params.put("endTime", dto.getEndTime() + 86400000L);
        }
        if (CollectionUtils.isEmpty((Collection)(students = this.studentDao.getStudentListParams((Map)params, page)))) {
            return Lists.newArrayList();
        }
        return this.wrapResult(students);
    }

    @Override
    public List<StudentListResponseDto> getWechatStudentListByParams(Map<String, Object> params, PageDto page) {
        List students = this.studentDao.getWechatStudentListParams(params, page);
        if (CollectionUtils.isEmpty((Collection)students)) {
            return Lists.newArrayList();
        }
        return this.wrapResult(students);
    }

    @Override
    public List<StudentListResponseDto> wrapResult(List<Student> students) {
        HashSet userIds = Sets.newHashSet();
        userIds.addAll(BaseUtils.getPropertiesList(students, (String)"creatorId"));
        userIds.addAll(BaseUtils.getPropertiesList(students, (String)"tmkId"));
        userIds.addAll(BaseUtils.getPropertiesList(students, (String)"assistantId"));
        userIds.addAll(BaseUtils.getPropertiesList(students, (String)"adviserId"));
        userIds.addAll(BaseUtils.getPropertiesList(students, (String)"marketId"));
        Set schoolIds = BaseUtils.getPropertiesList(students, (String)"schoolId");
        Set subjectIds = BaseUtils.getPropertiesList(students, (String)"subjectId");
        Map<Long, User> userMap = this.getUsersMap(userIds);
        Map<Long, School> schoolMap = this.getSchoolsMap(schoolIds);
        Map<Long, Subject> sujectMap = this.getSubjectsMap(subjectIds);
        ArrayList dtos = Lists.newArrayList();
        for (Student student : students) {
            StudentListResponseDto clueTmkResponseDto = new StudentListResponseDto();
            StudentListResponseDto.toDto(student, clueTmkResponseDto);
            clueTmkResponseDto.setTmkName(userMap.get(student.getTmkId()) == null ? null : userMap.get(student.getTmkId()).getName());
            clueTmkResponseDto.setCreatorName(userMap.get(student.getCreatorId()) == null ? null : userMap.get(student.getCreatorId()).getName());
            clueTmkResponseDto.setAdviserName(userMap.get(student.getAdviserId()) == null ? null : userMap.get(student.getAdviserId()).getName());
            clueTmkResponseDto.setSchoolName(schoolMap.get(student.getSchoolId()) == null ? null : schoolMap.get(student.getSchoolId()).getName());
            clueTmkResponseDto.setSubjectName(sujectMap.get(student.getSubjectId()) == null ? null : sujectMap.get(student.getSubjectId()).getName());
            clueTmkResponseDto.setAssistantName(userMap.get(student.getAssistantId()) == null ? null : userMap.get(student.getAssistantId()).getName());
            clueTmkResponseDto.setMarketName(userMap.get(student.getMarketId()) == null ? null : userMap.get(student.getMarketId()).getName());
            dtos.add(clueTmkResponseDto);
        }
        return dtos;
    }

    @Override
    @Transactional(readOnly=true)
    public ClueMergeRespDto getClueMergeInfo(long clueOne, long clueAnother) {
        User user;
        Subject subject;
        School school;
        ClueMergeRespDto dto = new ClueMergeRespDto();
        Student clue1 = this.clueDao.getClueById(clueOne);
        if (clue1 == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        Student clue2 = this.clueDao.getClueById(clueAnother);
        if (clue2 == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        List<ClueMergeMapDto> listOne = ClueMergeMapDto.toClueMerMap(clue1);
        List<ClueMergeMapDto> listAnother = ClueMergeMapDto.toClueMerMap(clue2);
        for (ClueMergeMapDto mergeDto : listOne) {
            if (mergeDto.getName().endsWith("schoolId")) {
                school = this.schoolDao.querySchoolById(((Long)mergeDto.getValue()).longValue(), new String[]{"name"});
                mergeDto.setDisplayValue(school == null ? null : school.getName());
            }
            if (mergeDto.getName().endsWith("subjectId")) {
                subject = this.subjectDao.getSujectById(((Long)mergeDto.getValue()).longValue());
                mergeDto.setDisplayValue(subject == null ? null : subject.getName());
            }
            if (!mergeDto.getName().endsWith("adviserId") && !mergeDto.getName().endsWith("tmkId")) continue;
            user = this.userDao.getNormalUserById(((Long)mergeDto.getValue()).longValue());
            mergeDto.setDisplayValue(user == null ? null : user.getName());
        }
        for (ClueMergeMapDto mergeDto : listAnother) {
            if (mergeDto.getName().endsWith("schoolId")) {
                school = this.schoolDao.querySchoolById(((Long)mergeDto.getValue()).longValue(), new String[]{"name"});
                mergeDto.setDisplayValue(school == null ? null : school.getName());
            }
            if (mergeDto.getName().endsWith("subjectId")) {
                subject = this.subjectDao.getSujectById(((Long)mergeDto.getValue()).longValue());
                mergeDto.setDisplayValue(subject == null ? null : subject.getName());
            }
            if (!mergeDto.getName().endsWith("adviserId") && !mergeDto.getName().endsWith("tmkId")) continue;
            user = this.userDao.getNormalUserById(((Long)mergeDto.getValue()).longValue());
            mergeDto.setDisplayValue(user == null ? null : user.getName());
        }
        dto.setClueAnother(listAnother);
        dto.setClueOne(listOne);
        dto.setClueOneId(clue1.getId());
        dto.setClueOneName(clue1.getName());
        dto.setClueAnotherId(clue2.getId());
        dto.setClueAnotherName(clue2.getName());
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long mergeClueInfo(ClueMergeReqDto dto) {
        Student clue1 = this.clueDao.getClueById(dto.getPrimaryClueId());
        if (clue1 == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        Student clue2 = this.clueDao.getClueById(dto.getMinorClueId());
        if (clue2 == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        this.studentCommentDao.transferCommentsToClue(clue2.getId().longValue(), clue1.getId().longValue());
        List minorbackLogs = this.backLogUserListDao.getBackLogByUserIds((Collection)Sets.newHashSet((Object[])new Long[]{dto.getMinorClueId()}), 1);
        List majorbackLogs = this.backLogUserListDao.getBackLogByUserIds((Collection)Sets.newHashSet((Object[])new Long[]{dto.getPrimaryClueId()}), 1);
        if (CollectionUtils.isNotEmpty((Collection)minorbackLogs) && CollectionUtils.isNotEmpty((Collection)majorbackLogs)) {
            Set minorBackLogIds = BaseUtils.getPropertiesList((Collection)minorbackLogs, (String)"backLogId");
            Set majorBackLogIds = BaseUtils.getPropertiesList((Collection)majorbackLogs, (String)"backLogId");
            minorBackLogIds.retainAll(majorBackLogIds);
            if (CollectionUtils.isNotEmpty((Collection)minorBackLogIds)) {
                HashMap params = Maps.newHashMap();
                params.put("backLogId", minorBackLogIds);
                params.put("userId", dto.getMinorClueId());
                params.put("type", 1);
                this.backLogUserListDao.delByCondition((Map)params);
            }
        }
        this.backLogDao.transferBackLogToClue(clue2.getId().longValue(), clue1.getId().longValue());
        String fromName = clue1.getName();
        String targetName = clue2.getName();
        ClueMergeBaseReq.merMapToStudent(dto.getValues(), clue1);
        if (clue1.getAdviserId() == 0L && clue1.getTmkId() == 0L) {
            clue1.setClueType(ClueType.OCEAN.getType());
            if (clue1.getOceanClueType() == 0) {
                clue1.setOceanClueType(OceanClueType.CLAIM.getType());
            }
        } else if (clue1.getAdviserId() != 0L) {
            clue1.setClueType(ClueType.PRIVATE.getType());
            clue1.setStatus(ClueStatus.CLUE.getStatus());
            if (clue1.getAdviserAllocateTime() == null) {
                clue1.setAdviserAllocateTime(new Date());
            }
        } else {
            clue1.setClueType(ClueType.PRIVATE.getType());
            clue1.setStatus(ClueStatus.TMK.getStatus());
            if (clue1.getTmkAllocateTime() == null) {
                clue1.setTmkAllocateTime(new Date());
            }
        }
        clue1.setUpdateTime(new Date());
        this.clueDao.update((Object)clue1, Boolean.valueOf(true), new String[0]);
        clue2.setIsDel(DeleteStatus.DELETED.getValue());
        clue2.setUpdateTime(new Date());
        this.clueDao.update((Object)clue2, new String[]{"isDel", "updateTime"});
        this.addOpRecord(clue1.getId(), fromName, targetName, clue1.getName(), clue1.getMobile());
        return clue1.getId();
    }

    void addOpRecord(Long id, String fromName, String targetName, String toName, String toMobile) {
        BaseLoginUser user = LoginUtil.getCurrentUser();
        IdAndNameDto opUser = new IdAndNameDto(user.getUserId(), user.getUserName());
        String content = String.format(OpRecordType.MERGE_CLUE.getContent(), fromName, targetName, toName, toMobile);
        this.opRecordService.addOpRecord(id, OpRecordType.MERGE_CLUE, content, opUser);
    }

    @Override
    @Transactional(readOnly=true)
    public List<RepeatClueRespDto> getRepeatClueList(String mobile, String name) {
        List mobileStudents = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            mobileStudents = this.clueDao.getRepeatCluesByMobiles((Collection)Lists.newArrayList((Object[])new String[]{mobile}));
        }
        HashSet hasSutdents = Sets.newHashSet();
        ArrayList students = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)mobileStudents)) {
            for (Student mobileStudent : mobileStudents) {
                if (hasSutdents.contains(mobileStudent.getId())) continue;
                students.add(mobileStudent);
                hasSutdents.add(mobileStudent.getId());
            }
        }
        ArrayList dtos = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)students)) {
            return dtos;
        }
        for (Student repeatStudent : students) {
            RepeatClueRespDto dto = new RepeatClueRespDto();
            dto.setId(repeatStudent.getId());
            dto.setName(repeatStudent.getName());
            dto.setContactsName(repeatStudent.getContactsName());
            dto.setContacts2Name(repeatStudent.getContacts2Name());
            dto.setMobile(repeatStudent.getMobile());
            dto.setContactsMobile(repeatStudent.getContactsMobile());
            dto.setContacts2Mobile(repeatStudent.getContacts2Mobile());
            dto.setCreateTime(repeatStudent.getCreateTime() == null ? 0L : repeatStudent.getCreateTime().getTime());
            if (repeatStudent.getStatus() == ClueStatus.STUDENT.getStatus()) {
                dto.setStatusStr(ClueStatus.STUDENT.getLabel());
            } else {
                if (repeatStudent.getClueType() == ClueType.INVALID.getType()) {
                    dto.setStatusStr(ClueStatus.get((int)repeatStudent.getStatus()).getLabel() + "\u65e0\u6548\u7ebf\u7d22");
                }
                if (repeatStudent.getClueType() == ClueType.OCEAN.getType()) {
                    dto.setStatusStr(ClueStatus.get((int)repeatStudent.getStatus()).getLabel() + "\u516c\u6d77\u7ebf\u7d22");
                }
                if (repeatStudent.getClueType() == ClueType.PRIVATE.getType()) {
                    dto.setStatusStr(ClueStatus.get((int)repeatStudent.getStatus()).getLabel() + "\u6709\u6548\u7ebf\u7d22");
                }
            }
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    @Transactional(readOnly=true)
    public List<RepeatClueRespDto> getRepeatClueList(long id) {
        Student student = this.studentDao.getStudentAndClueById(id);
        if (student == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        HashSet mobiles = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)student.getMobile())) {
            mobiles.add(student.getMobile());
        }
        if (StringUtils.isNotBlank((CharSequence)student.getContacts2Mobile())) {
            mobiles.add(student.getContacts2Mobile());
        }
        if (StringUtils.isNotBlank((CharSequence)student.getContactsMobile())) {
            mobiles.add(student.getContactsMobile());
        }
        List mobileStudents = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)mobiles)) {
            mobileStudents = this.clueDao.getRepeatCluesByMobiles((Collection)mobiles);
        }
        HashSet hasSutdents = Sets.newHashSet();
        ArrayList students = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)mobileStudents)) {
            for (Student mobileStudent : mobileStudents) {
                if (hasSutdents.contains(mobileStudent.getId())) continue;
                students.add(mobileStudent);
                hasSutdents.add(mobileStudent.getId());
            }
        }
        ArrayList dtos = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)students)) {
            return dtos;
        }
        Set creatorIds = BaseUtils.getPropertiesList((Collection)students, (String)"creatorId");
        Set tmkIds = BaseUtils.getPropertiesList((Collection)students, (String)"tmkId");
        Set adviserIds = BaseUtils.getPropertiesList((Collection)students, (String)"adviserId");
        Map<Long, User> creatorMap = this.getUsersMap(creatorIds);
        Map<Long, User> tmkMap = this.getUsersMap(tmkIds);
        Map<Long, User> adviserMap = this.getUsersMap(adviserIds);
        for (Student repeatStudent : students) {
            RepeatClueRespDto dto = new RepeatClueRespDto();
            dto.setId(repeatStudent.getId());
            dto.setName(repeatStudent.getName());
            dto.setContactsName(repeatStudent.getContactsName());
            dto.setContacts2Name(repeatStudent.getContacts2Name());
            dto.setMobile(repeatStudent.getMobile());
            dto.setContactsMobile(repeatStudent.getContactsMobile());
            dto.setContacts2Mobile(repeatStudent.getContacts2Mobile());
            dto.setCreateTime(repeatStudent.getCreateTime() == null ? 0L : repeatStudent.getCreateTime().getTime());
            dto.setTmkName(tmkMap.get(repeatStudent.getTmkId()) == null ? null : tmkMap.get(repeatStudent.getTmkId()).getName());
            dto.setCreatorName(creatorMap.get(repeatStudent.getCreatorId()) == null ? null : creatorMap.get(repeatStudent.getCreatorId()).getName());
            dto.setAdviserName(adviserMap.get(repeatStudent.getAdviserId()) == null ? null : adviserMap.get(repeatStudent.getAdviserId()).getName());
            if (repeatStudent.getStatus() == ClueStatus.STUDENT.getStatus()) {
                dto.setStatusStr(ClueStatus.STUDENT.getLabel());
            } else {
                if (repeatStudent.getClueType() == ClueType.INVALID.getType()) {
                    dto.setStatusStr(ClueStatus.get((int)repeatStudent.getStatus()).getLabel() + "\u65e0\u6548\u7ebf\u7d22");
                }
                if (repeatStudent.getClueType() == ClueType.OCEAN.getType()) {
                    dto.setStatusStr(ClueStatus.get((int)repeatStudent.getStatus()).getLabel() + "\u516c\u6d77\u7ebf\u7d22");
                }
                if (repeatStudent.getClueType() == ClueType.PRIVATE.getType()) {
                    dto.setStatusStr(ClueStatus.get((int)repeatStudent.getStatus()).getLabel() + "\u6709\u6548\u7ebf\u7d22");
                }
            }
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public void saveBefore(StudentBaseDto dto) {
        if (dto.getName() == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getMobile() == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getSchoolId() == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u6821\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.schoolDao.querySchoolById(dto.getSchoolId().longValue(), new String[0]) == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u6821\u533a\u4e0d\u5b58\u5728");
        }
        if (dto.getChannelType() == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u6765\u6e90\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ChannelType.get((int)dto.getChannelType()) == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u6765\u6e90\u6e20\u9053\u4e0d\u5b58\u5728");
        }
        if (dto.getSourceDetail() == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u6765\u6e90\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getRelationType() != null && dto.getRelationType() != 0 && RelationType.get((int)dto.getRelationType()) == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u7528\u6237\u5173\u7cfb\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (dto.getContacts2RelationType() != null && dto.getContacts2RelationType() != 0 && RelationType.get((int)dto.getContacts2RelationType()) == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u7528\u6237\u5173\u7cfb\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (dto.getContactsRelationType() != null && dto.getContactsRelationType() != 0 && RelationType.get((int)dto.getContactsRelationType()) == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u7528\u6237\u5173\u7cfb\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (dto.getCanRecommend() != null && dto.getCanRecommend() != 0 && YesOrNoType.get((int)dto.getCanRecommend()) == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u662f\u5426\u53ef\u63a8\u8350\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (dto.getHasDeposite() != null && dto.getHasDeposite() != 0 && YesOrNoType.get((int)dto.getHasDeposite()) == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u662f\u5426\u7f34\u7eb3\u5b9a\u91d1\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (dto.getGender() != null && dto.getGender() != 0 && GenderType.get((int)dto.getGender()) == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u6027\u522b\u4e0d\u5b58\u5728");
        }
        if (dto.getSubjectId() != null && dto.getSubjectId() != 0L && this.subjectDao.getSujectById(dto.getSubjectId().longValue()) == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u9884\u671f\u8bfe\u7a0b\u4e0d\u5b58\u5728");
        }
        if (dto.getHasIntermediary() != null && dto.getHasIntermediary() != 0 && YesOrNoType.get((int)dto.getHasIntermediary()) == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u65e2\u5b9a\u4e2d\u4ecb\u4e0d\u5b58\u5728");
        }
        if (dto.getConsultStatus() != null && dto.getConsultStatus() != 0 && ConsultStatus.get((int)dto.getConsultStatus()) == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u8ddf\u8fdb\u72b6\u6001\u4e0d\u5b58\u5728");
        }
        if (dto.getStudyPhase() != null && dto.getStudyPhase() != 0 && StudyPhase.get((int)dto.getStudyPhase()) == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u610f\u5411\u7ea7\u522b\u4e0d\u5b58\u5728");
        }
        if (dto.getTakeExam() != null && dto.getTakeExam() != 0 && YesOrNoType.get((int)dto.getTakeExam()) == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u662f\u5426\u53c2\u52a0\u8003\u8bd5\u4e0d\u5b58\u5728");
        }
    }

    @Override
    public List<CallMobileRespDto> getStudentMobiles(long studentId) {
        CallMobileRespDto dto;
        Student student = this.studentDao.getStudentAndClueById(studentId);
        if (student == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u5b66\u5458\u4e0d\u5b58\u5728");
        }
        ArrayList dtos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)student.getMobile())) {
            dto = new CallMobileRespDto();
            dto.setMobile(student.getMobile());
            dto.setName(student.getName());
            dto.setRelationType(student.getRelationType());
            dto.setRelationTypeStr(RelationType.get((int)student.getRelationType()) == null ? null : RelationType.get((int)student.getRelationType()).getLabel());
            dtos.add(dto);
        }
        if (StringUtils.isNotBlank((CharSequence)student.getContactsMobile())) {
            dto = new CallMobileRespDto();
            dto.setMobile(student.getContactsMobile());
            dto.setName(student.getContactsName());
            dto.setRelationType(student.getContactsRelationType());
            dto.setRelationTypeStr(RelationType.get((int)student.getContactsRelationType()) == null ? null : RelationType.get((int)student.getContactsRelationType()).getLabel());
            dtos.add(dto);
        }
        if (StringUtils.isNotBlank((CharSequence)student.getContacts2Mobile())) {
            dto = new CallMobileRespDto();
            dto.setMobile(student.getContacts2Mobile());
            dto.setName(student.getContacts2Name());
            dto.setRelationType(student.getContacts2RelationType());
            dto.setRelationTypeStr(RelationType.get((int)student.getContacts2RelationType()) == null ? null : RelationType.get((int)student.getContacts2RelationType()).getLabel());
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public List<Student> getStudentByOpenId(String openId) {
        Set studentId;
        List students;
        if (StringUtils.isBlank((CharSequence)openId)) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u5fae\u4fe1\u8ba4\u8bc1\u5931\u8d25");
        }
        List wechatMobiles = this.wechatMobileDao.getWechatMobilesByOpenId(openId, Integer.valueOf(UserRole.STUDENT.getRole()));
        if (CollectionUtils.isNotEmpty((Collection)wechatMobiles) && CollectionUtils.isNotEmpty((Collection)(students = this.studentDao.getStudentByIds(studentId = BaseUtils.getPropertiesList((Collection)wechatMobiles, (String)"userId"))))) {
            return students;
        }
        return Lists.newArrayList();
    }

    @Override
    public List<Student> getStudentParentByOpenId(String openId) {
        Set studentId;
        List students;
        if (StringUtils.isBlank((CharSequence)openId)) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u5fae\u4fe1\u8ba4\u8bc1\u5931\u8d25");
        }
        List wechatMobiles = this.wechatMobileDao.getWechatMobilesByOpenId(openId, Integer.valueOf(UserRole.PARENT.getRole()));
        if (CollectionUtils.isNotEmpty((Collection)wechatMobiles) && CollectionUtils.isNotEmpty((Collection)(students = this.studentDao.getStudentByIds(studentId = BaseUtils.getPropertiesList((Collection)wechatMobiles, (String)"userId"))))) {
            return students;
        }
        return Lists.newArrayList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Student> getAndUpdateStudent(String mobile, String openId) {
        List students = this.studentDao.getWechatStudentListByMobile(mobile);
        ArrayList wechatMobiles = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)students)) {
            for (Student student : students) {
                student.setWeixinOpenId(openId);
                student.setUpdateTime(new Date());
                this.studentDao.update((Object)student, new String[]{"updateTime", "weixinOpenId"});
                WechatMobile wechatMobile = new WechatMobile();
                wechatMobile.setMobile(mobile);
                wechatMobile.setUserId(student.getId().longValue());
                wechatMobile.setUserRole(UserRole.STUDENT.getRole());
                wechatMobile.setWeixinOpenId(openId);
                wechatMobile.setCreateTime(new Date());
                wechatMobiles.add(wechatMobile);
            }
            this.wechatMobileDao.saveAll((List)wechatMobiles, new String[0]);
        }
        return students;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Student> getAndUpdateStudentParent(String mobile, String openId) {
        List students = this.studentDao.getWechatStudentParentListByMobile(mobile);
        ArrayList wechatMobiles = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)students)) {
            for (Student student : students) {
                List oldStudents = this.wechatMobileDao.getWechatMobiles(mobile, student.getId(), Integer.valueOf(UserRole.PARENT.getRole()));
                if (CollectionUtils.isNotEmpty((Collection)oldStudents)) {
                    this.wechatMobileDao.delByIds((Collection)BaseUtils.getPropertiesList((Collection)oldStudents, (String)"id"));
                }
                WechatMobile wechatMobile = new WechatMobile();
                wechatMobile.setMobile(mobile);
                wechatMobile.setUserId(student.getId().longValue());
                wechatMobile.setUserRole(UserRole.PARENT.getRole());
                wechatMobile.setWeixinOpenId(openId);
                wechatMobile.setCreateTime(new Date());
                wechatMobiles.add(wechatMobile);
            }
            this.wechatMobileDao.saveAll((List)wechatMobiles, new String[0]);
        }
        return students;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindWechat(long id, String mobile) {
        List wechatMobiles = this.wechatMobileDao.getWechatMobiles(mobile, Long.valueOf(id), Integer.valueOf(UserRole.STUDENT.getRole()));
        if (CollectionUtils.isNotEmpty((Collection)wechatMobiles)) {
            Set wechatMobileIds = BaseUtils.getPropertiesList((Collection)wechatMobiles, (String)"id");
            Set studentIds = BaseUtils.getPropertiesList((Collection)wechatMobiles, (String)"userId");
            this.wechatMobileDao.delByIds((Collection)wechatMobileIds);
            Map studentCountMap = this.wechatMobileDao.getStudentWechatCountMap((Collection)studentIds);
            List students = this.studentDao.getStudentByIds(studentIds);
            if (CollectionUtils.isNotEmpty((Collection)students)) {
                for (Student student : students) {
                    Integer count = (Integer)studentCountMap.get(student.getId());
                    if (count != null && count != NumberUtils.INTEGER_ZERO) continue;
                    student.setWeixinOpenId(null);
                    this.studentDao.update((Object)student, Boolean.valueOf(true), new String[]{"weixinOpenId"});
                }
            }
        }
    }

    @Override
    public void unbindParentWechat(long userId, int userRole, String openId) {
        HashMap params = Maps.newHashMap();
        params.put("userId", userId);
        params.put("userRole", userRole);
        params.put("weixinOpenId", openId);
        log.info("unbindParentWechat.userId:{}, userRole:{}, openId:{}", new Object[]{userId, userRole, openId});
        this.wechatMobileDao.delByCondition((Map)params);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyHeadImg(long id, String url) {
        Student student = this.studentDao.getStudentById(id);
        if (student == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u5b66\u5458\u4e0d\u5b58\u5728");
        }
        student.setPic(url);
        student.setUpdateTime(new Date());
        this.studentDao.update((Object)student, new String[]{"pic", "updateTime"});
    }

    @Override
    public long getClueCountByUserId(long userId) {
        User user = this.userDao.getNormalUserById(userId);
        if (user == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u7528\u6237\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u88ab\u7981\u7528");
        }
        long count = this.clueDao.getClueCountByUserId(userId);
        return count;
    }

    private Map<Long, User> getUsersMap(Collection<Long> userIds) {
        List users = this.userDao.getNoDelUsersByIds(userIds, new String[]{"id", "name"});
        if (CollectionUtils.isEmpty((Collection)users)) {
            return Maps.newHashMap();
        }
        return BaseUtils.listToMap((List)users, (String)"id");
    }

    private Map<Long, School> getSchoolsMap(Collection<Long> schoolIds) {
        List schools = this.schoolDao.querySchoolByIds(schoolIds, new String[]{"id", "name"});
        if (CollectionUtils.isEmpty((Collection)schools)) {
            return Maps.newHashMap();
        }
        return BaseUtils.listToMap((List)schools, (String)"id");
    }

    private Map<Long, Subject> getSubjectsMap(Collection<Long> subjectIds) {
        List sujects = this.subjectDao.getSubjectIds(subjectIds, new String[]{"id", "name"});
        if (CollectionUtils.isEmpty((Collection)sujects)) {
            return Maps.newHashMap();
        }
        return BaseUtils.listToMap((List)sujects, (String)"id");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delayFollowTime(Long id, String remark) {
        Student student = (Student)this.studentDao.getById((Serializable)id, new String[0]);
        if (student == null) throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7ebf\u7d22\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        Long adviserId = student.getAdviserId();
        if (adviserId <= 0L) throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u54a8\u8be2\u987e\u95ee\u7684\u7ebf\u7d22\u4e0d\u80fd\u5ef6\u957f\u8ddf\u8fdb\u65f6\u95f4");
        List records = this.auditRecordDao.queryDelayFowllowTimeRecord(id, adviserId, (Collection)Sets.newHashSet((Object[])new Integer[]{AuditStatus.ONGOING.getStatus()}));
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u7684\u7533\u8bf7\u6b63\u5728\u5ba1\u6279\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u5ba1\u6279");
        }
        records = this.auditRecordDao.queryDelayFowllowTimeRecord(id, adviserId, (Collection)Sets.newHashSet((Object[])new Integer[]{AuditStatus.PASS.getStatus()}));
        int alreadyDays = DateUtil.getDateDiff((Date)student.getAdviserAllocateTime(), (Date)new Date());
        if (alreadyDays > 30) {
            String returnMessage = String.format("\u5269\u4f59\u8ddf\u8fdb\u65f6\u95f4\u5c0f\u4e8e\u7b49\u4e8e%s\u5929\u65f6\uff0c\u624d\u80fd\u7533\u8bf7\u5ef6\u957f\u8ddf\u8fdb\u65f6\u95f4", 30);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, returnMessage);
        }
        Date now = new Date();
        BaseLoginUser user = LoginUtil.getCurrentUser();
        AuditRecord auditRecord = new AuditRecord();
        auditRecord.setApplyId(user.getUserId().longValue());
        auditRecord.setApplyRemarks(remark);
        auditRecord.setApplyTime(now);
        auditRecord.setApplyType(ApplyType.DELAY_FOLLOW_TIME.getType());
        auditRecord.setAuditId(Long.valueOf(0L));
        auditRecord.setAuditTime(null);
        auditRecord.setAuditRemarks("");
        String content = String.format(ApplyType.DELAY_FOLLOW_TIME.getContent(), student.getName(), student.getMobile());
        auditRecord.setContent(content);
        auditRecord.setCreateTime(now);
        auditRecord.setStatus(AuditStatus.ONGOING.getStatus());
        auditRecord.setTargetId(student.getId());
        auditRecord.setUpdateTime(now);
        auditRecord.setAdviserId(adviserId.longValue());
        this.auditRecordDao.save((Object)auditRecord, new String[0]);
    }

    @Override
    public ClueAuditDetailDto getClueDelayFollowTimeDetail(Long id) {
        AuditRecord auditRecord = (AuditRecord)this.auditRecordDao.getById((Serializable)id, new String[0]);
        if (auditRecord == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u5bf9\u5e94\u7684\u7533\u8bf7\u8bb0\u5f55");
        }
        Long studentId = auditRecord.getTargetId();
        Student student = (Student)this.studentDao.getById((Serializable)studentId, new String[0]);
        ClueAuditDetailDto dto = null;
        if (student != null && student.getStatus() == ClueStatus.CLUE.getStatus()) {
            School school;
            dto = new ClueAuditDetailDto();
            dto.setApplyId(auditRecord.getApplyId());
            dto.setApplyRemark(auditRecord.getApplyRemarks());
            dto.setApplyTime(auditRecord.getApplyTime().getTime());
            dto.setAuditStatus(auditRecord.getStatus());
            dto.setAuditStatusStr(AuditStatus.get((int)auditRecord.getStatus()).getLabel());
            dto.setAuditRemark(auditRecord.getAuditRemarks());
            User user = (User)this.userDao.getById((Serializable)Long.valueOf(auditRecord.getApplyId()), new String[0]);
            dto.setApplyUserName(user.getName());
            dto.setId(auditRecord.getId());
            dto.setMobile(student.getMobile());
            Long schoolId = student.getSchoolId();
            dto.setSchoolId(schoolId);
            String schoolName = "";
            if (schoolId != null && schoolId > 0L && (school = (School)this.schoolDao.getById((Serializable)schoolId, new String[0])) != null) {
                schoolName = school.getName();
            }
            dto.setSchoolName(schoolName);
            dto.setStudentId(student.getId());
            dto.setStudentName(student.getName());
            int gender = student.getGender();
            GenderType genderType = GenderType.get((int)gender);
            if (genderType != null) {
                dto.setGenderStr(genderType.getLabel());
            } else {
                dto.setGenderStr("\u672a\u77e5");
            }
        }
        return dto;
    }

    @Override
    public int computeLastFollowTime(int maxCCFollowTime, Student student) {
        Date now = new Date();
        int lastFollowDate = DateUtil.getDateDiff((Date)student.getAdviserAllocateTime(), (Date)now);
        AuditRecord auditRecord = this.auditRecordDao.queryLastDelayFowllowTimeRecord(student.getId(), Integer.valueOf(AuditStatus.PASS.getStatus()));
        int delayFollowTime = NumberUtils.INTEGER_ZERO;
        if (auditRecord != null && auditRecord.getAdviserId() == student.getAdviserId()) {
            delayFollowTime = maxCCFollowTime;
        }
        return maxCCFollowTime + delayFollowTime - lastFollowDate;
    }
}

