/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.student.service.impl;

import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.wedo.common.constant.BizConf;
import com.baijia.wedo.common.enums.LearningSubtaskType;
import com.baijia.wedo.common.enums.MessageBizType;
import com.baijia.wedo.common.enums.UserRole;
import com.baijia.wedo.common.enums.schedule.RepeatUnit;
import com.baijia.wedo.common.errorcode.CommonErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.model.BaseLoginUser;
import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.common.util.LoginUtil;
import com.baijia.wedo.dal.student.dao.LearningSubtaskDao;
import com.baijia.wedo.dal.student.dao.LearningTaskDao;
import com.baijia.wedo.dal.student.dao.StudentDao;
import com.baijia.wedo.dal.student.po.Student;
import com.baijia.wedo.dal.student.po.StudentLearningSubtask;
import com.baijia.wedo.dal.student.po.StudentLearningTask;
import com.baijia.wedo.dal.user.dao.UserDao;
import com.baijia.wedo.dal.user.po.User;
import com.baijia.wedo.dal.wechat.dao.WechatMobileDao;
import com.baijia.wedo.dal.wechat.po.WechatMobile;
import com.baijia.wedo.sal.student.dto.learning.LearningSubtaskAddDto;
import com.baijia.wedo.sal.student.dto.learning.LearningTaskAddReqDto;
import com.baijia.wedo.sal.student.dto.learning.LearningTaskListRespDto;
import com.baijia.wedo.sal.student.service.LearningTaskService;
import com.baijia.wedo.sal.wechat.dto.SendMsgRequest;
import com.baijia.wedo.sal.wechat.enums.WechatTemplateMsgType;
import com.baijia.wedo.sal.wechat.service.MsgSendService;
import com.beust.jcommander.internal.Maps;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LearningTaskServiceImpl
implements LearningTaskService {
    private static final Logger log = LoggerFactory.getLogger(LearningTaskServiceImpl.class);
    @Autowired
    private LearningSubtaskDao learningSubtaskDao;
    @Autowired
    private LearningTaskDao learningTaskDao;
    @Autowired
    private StudentDao studentDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private WechatMobileDao wechatMobileDao;
    @Autowired
    private MsgSendService msgSendService;

    @Override
    public List<LearningTaskListRespDto> getLearningTaskList(Long studentId, PageDto page) {
        Preconditions.checkArgument((studentId != null ? 1 : 0) != 0, (Object)"studentId is null");
        ArrayList taskListRespDtos = Lists.newArrayList();
        List tasks = this.learningTaskDao.getLearningTaskList(studentId, page);
        if (CollectionUtils.isNotEmpty((Collection)tasks)) {
            Set taskIds = BaseUtils.getPropertiesList((Collection)tasks, (String)"id");
            Map subtaskCache = this.learningSubtaskDao.getAndCacheByTaskIds((Collection)taskIds);
            Student student = (Student)this.studentDao.getById((Serializable)studentId, new String[0]);
            User assistant = null;
            if (student.getAssistantId() > 0L) {
                assistant = (User)this.userDao.getById((Serializable)Long.valueOf(student.getAssistantId()), new String[]{"id", "name"});
            }
            for (StudentLearningTask task : tasks) {
                LearningTaskListRespDto respDto = new LearningTaskListRespDto();
                respDto.setId(task.getId());
                respDto.setTaskDate(task.getTaskDate().getTime());
                respDto.setStartTime(task.getStartTime().getTime());
                respDto.setEndTime(task.getEndTime().getTime());
                respDto.setTimeRangeStr(String.format("%s~%s", BaseUtils.getFormatTime((Date)task.getStartTime(), (String)"HH:mm"), BaseUtils.getFormatTime((Date)task.getEndTime(), (String)"HH:mm")));
                this.populateContent(subtaskCache, respDto, task);
                if (assistant != null) {
                    respDto.setAssistantId(assistant.getId());
                    respDto.setAssistantName(assistant.getName());
                }
                taskListRespDtos.add(respDto);
            }
        }
        return taskListRespDtos;
    }

    @Override
    public List<LearningTaskListRespDto> getLearningTaskList(Long studentId, Date startTime, Date endTime, PageDto page) {
        Preconditions.checkArgument((studentId != null ? 1 : 0) != 0, (Object)"studentId is null");
        ArrayList taskListRespDtos = Lists.newArrayList();
        List tasks = this.learningTaskDao.getLearningTaskList(studentId, startTime, endTime, page);
        if (CollectionUtils.isNotEmpty((Collection)tasks)) {
            Set taskIds = BaseUtils.getPropertiesList((Collection)tasks, (String)"id");
            Map subtaskCache = this.learningSubtaskDao.getAndCacheByTaskIds((Collection)taskIds);
            Student student = (Student)this.studentDao.getById((Serializable)studentId, new String[0]);
            User assistant = null;
            if (student.getAssistantId() > 0L) {
                assistant = (User)this.userDao.getById((Serializable)Long.valueOf(student.getAssistantId()), new String[]{"id", "name"});
            }
            for (StudentLearningTask task : tasks) {
                LearningTaskListRespDto respDto = new LearningTaskListRespDto();
                respDto.setId(task.getId());
                respDto.setTaskDate(task.getTaskDate().getTime());
                respDto.setStartTime(task.getStartTime().getTime());
                respDto.setEndTime(task.getEndTime().getTime());
                respDto.setTimeRangeStr(String.format("%s~%s", BaseUtils.getFormatTime((Date)task.getStartTime(), (String)"HH:mm"), BaseUtils.getFormatTime((Date)task.getEndTime(), (String)"HH:mm")));
                this.populateContent(subtaskCache, respDto, task);
                if (assistant != null) {
                    respDto.setAssistantId(assistant.getId());
                    respDto.setAssistantName(assistant.getName());
                }
                taskListRespDtos.add(respDto);
            }
        }
        return taskListRespDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteLearningTask(Long taskId) {
        Preconditions.checkArgument((taskId != null ? 1 : 0) != 0, (Object)"taskId is null");
        StudentLearningTask task = (StudentLearningTask)this.learningTaskDao.getById((Serializable)taskId, new String[0]);
        if (task != null) {
            task.setIsDel(BizConf.TRUE.intValue());
            this.learningTaskDao.saveOrUpdate((Object)task, new String[0]);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addLearningTask(LearningTaskAddReqDto addReqDto) {
        BaseLoginUser loginUser = LoginUtil.getCurrentUser();
        RepeatUnit repeatUnit = addReqDto.getRepeatUnit();
        List calens = repeatUnit.getAvaliableDays(new Date(addReqDto.getTaskDate()), addReqDto.getRepeatCount(), addReqDto.getRepeatRange(), addReqDto.getWeekDays(), addReqDto.getCalendarDays());
        for (Calendar calendar : calens) {
            StudentLearningTask learningTask = new StudentLearningTask();
            learningTask.setStudentId(addReqDto.getStudentId());
            learningTask.setTaskDate(DateUtils.truncate((Calendar)calendar, (int)5).getTime());
            learningTask.setUserId(loginUser.getUserId());
            learningTask.setIsDel(BizConf.FALSE.intValue());
            Date now = new Date();
            learningTask.setCreateTime(now);
            learningTask.setUpdateTime(now);
            LearningTaskServiceImpl.populateTimeRange(learningTask, addReqDto, calendar);
            this.learningTaskDao.save((Object)learningTask, new String[0]);
            String comment = "";
            String first = "";
            if (!CollectionUtils.isNotEmpty(addReqDto.getSubtasks())) continue;
            for (LearningSubtaskAddDto subtaskAddDto : addReqDto.getSubtasks()) {
                StudentLearningSubtask subtask = new StudentLearningSubtask();
                subtask.setType(Integer.valueOf(subtaskAddDto.getType()));
                subtask.setContent(subtaskAddDto.getContent());
                subtask.setLearningTaskId(Long.valueOf(learningTask.getId()));
                subtask.setCreateTime(now);
                subtask.setUpdateTime(now);
                this.learningSubtaskDao.save((Object)subtask, new String[0]);
            }
            if (addReqDto.getSubtasks().size() == NumberUtils.INTEGER_ONE.intValue()) {
                first = "%s\u540c\u5b66,%s\u8001\u5e08\u5b89\u6392\u4e86\u65b0\u7684\u5b66\u4e60\u4efb\u52a1\uff0c\u8bf7\u767b\u5f55\u3010\u5b66\u5458\u4e2d\u5fc3\u3011-\u3010\u5b66\u4e60\u4efb\u52a1\u3011\u67e5\u770b\u8be6\u60c5";
                comment = addReqDto.getSubtasks().get(0).getContent() + ", \u8bf7\u6309\u65f6\u5b8c\u6210\u54e6^_^!";
            } else {
                first = "%s\u540c\u5b66,%s\u8001\u5e08\u5b89\u6392\u4e86" + addReqDto.getSubtasks().size() + "\u4e2a\u65b0\u7684\u5b66\u4e60\u4efb\u52a1\uff0c\u8bf7\u767b\u5f55\u3010\u5b66\u5458\u4e2d\u5fc3\u3011-\u3010\u5b66\u4e60\u4efb\u52a1\u3011\u67e5\u770b\u8be6\u60c5";
                comment = "\u8bf7\u6309\u65f6\u5b8c\u6210\u54e6^_^!";
            }
            BaseLoginUser user = LoginUtil.getCurrentUser();
            this.sendTemplateMsgToStudent(addReqDto.getStudentId(), user.getUserName(), comment, first, MessageBizType.ADD_LEARNING_TASK);
        }
    }

    void sendTemplateMsgToStudent(long studentId, String userName, String content, String first, MessageBizType bizType) {
        List wechatStudents = this.wechatMobileDao.getWechatMobiles(null, Long.valueOf(studentId), Integer.valueOf(UserRole.STUDENT.getRole()));
        if (CollectionUtils.isNotEmpty((Collection)wechatStudents)) {
            Set studentIds = BaseUtils.getPropertiesList((Collection)wechatStudents, (String)"userId");
            List students = this.studentDao.getByIds((Collection)studentIds, new String[]{"id", "name"});
            Map cache = BaseUtils.listToMap((List)students, (String)"id");
            for (WechatMobile wechatStudent : wechatStudents) {
                Student student = (Student)cache.get(wechatStudent.getUserId());
                if (student == null) continue;
                this.sendWechatMsg(wechatStudent.getWeixinOpenId(), student.getName(), userName, content, first, UserRole.STUDENT.getRole(), bizType, WechatTemplateMsgType.STUDENT_NOTIFY);
            }
        }
    }

    private void populateContent(Map<Long, List<StudentLearningSubtask>> subtaskCache, LearningTaskListRespDto respDto, StudentLearningTask task) {
        List<StudentLearningSubtask> subtasks = subtaskCache.get(task.getId());
        StringBuffer contentBuffer = new StringBuffer();
        if (subtasks != null) {
            for (StudentLearningSubtask subtask : subtasks) {
                LearningSubtaskType subtaskType = LearningSubtaskType.get((int)subtask.getType());
                if (contentBuffer.length() > 0) {
                    contentBuffer.append("; ");
                }
                contentBuffer.append(null != subtaskType ? subtaskType.getName() : "");
                contentBuffer.append(": ");
                contentBuffer.append(StringUtils.isNotBlank((String)subtask.getContent()) ? subtask.getContent() : "");
                LearningSubtaskType subType = LearningSubtaskType.get((int)subtask.getType());
                subtask.setTypeStr(subType.getName());
            }
            respDto.setSubtasks(subtasks);
        } else {
            respDto.setSubtasks(Lists.newArrayList());
        }
        respDto.setContent(contentBuffer.toString());
    }

    void sendWechatMsg(String openId, String studentName, String userName, String content, String first, int userRole, MessageBizType bizType, WechatTemplateMsgType templateType) {
        if (StringUtils.isNotBlank((String)openId)) {
            try {
                if (userRole != UserRole.STUDENT.getRole()) {
                    return;
                }
                first = String.format(first, studentName, userName);
                String keyword1 = bizType.getTitle();
                String keyword2 = "WEDO-" + String.format("%03d", bizType.getType());
                String keyword3 = content;
                SendMsgRequest request = this.getMsgParam(openId, templateType, first, keyword1, keyword2, keyword3, "", "");
                if (log.isDebugEnabled()) {
                    log.debug("Send wechat message:{}", (Object)request);
                }
                this.msgSendService.sendMsg(request);
            }
            catch (Throwable e) {
                log.warn("Send wechat message to user failed, openId:{}, studentName:{}, userName:{}, content:{}", new Object[]{openId, studentName, userName, content});
            }
        }
    }

    private SendMsgRequest getMsgParam(String weixinOpenId, WechatTemplateMsgType msgType, String first, String keyword1, String keyword2, String keyword3, String url, String remark) {
        SendMsgRequest request = new SendMsgRequest();
        Map params = Maps.newHashMap();
        params.put("first", first);
        params.put("keyword1", keyword1);
        params.put("keyword2", keyword2);
        params.put("keyword3", keyword3);
        params.put("remark", remark);
        params.put("url", url);
        request.setWeixinOpenId(weixinOpenId);
        request.setTemplateType(msgType);
        request.setParams(params);
        return request;
    }

    private static void populateTimeRange(StudentLearningTask task, LearningTaskAddReqDto addReqDto, Calendar calendar) {
        Calendar originStartTime = Calendar.getInstance();
        originStartTime.setTime(new Date(addReqDto.getStartTime()));
        Calendar originEndTime = Calendar.getInstance();
        originEndTime.setTime(new Date(addReqDto.getEndTime()));
        Calendar taskDateCal = DateUtils.truncate((Calendar)calendar, (int)5);
        Calendar startTime = (Calendar)taskDateCal.clone();
        startTime.set(11, originStartTime.get(11));
        startTime.set(12, originStartTime.get(12));
        Calendar endTime = (Calendar)taskDateCal.clone();
        endTime.set(11, originEndTime.get(11));
        endTime.set(12, originEndTime.get(12));
        task.setStartTime(startTime.getTime());
        task.setEndTime(endTime.getTime());
    }

    @Override
    public void editLearningTask(LearningTaskListRespDto editReqDto) {
        if (editReqDto.getId() == null || editReqDto.getId().longValue() == NumberUtils.LONG_ZERO.longValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u903b\u8f91\u9519\u8bef");
        }
        StudentLearningTask task = (StudentLearningTask)this.learningTaskDao.getById((Serializable)editReqDto.getId(), new String[0]);
        String first = "";
        String comment = "";
        if (task != null) {
            task.setEndTime(new Date(editReqDto.getEndTime()));
            task.setStartTime(new Date(editReqDto.getStartTime()));
            task.setTaskDate(new Date(editReqDto.getTaskDate()));
            task.setUpdateTime(new Date());
            this.learningTaskDao.update((Object)task, new String[0]);
            List<StudentLearningSubtask> subTasks = editReqDto.getSubtasks();
            if (CollectionUtils.isNotEmpty(subTasks)) {
                Date now = new Date();
                StringBuffer contentBuffer = new StringBuffer();
                for (StudentLearningSubtask subTask : subTasks) {
                    LearningSubtaskType subtaskType = LearningSubtaskType.get((int)subTask.getType());
                    if (contentBuffer.length() > 0) {
                        contentBuffer.append("; ");
                    }
                    contentBuffer.append(null != subtaskType ? subtaskType.getName() : "");
                    contentBuffer.append(": ");
                    contentBuffer.append(StringUtils.isNotBlank((String)subTask.getContent()) ? subTask.getContent() : "");
                    if (subTask.getId() != null && subTask.getId() > 0L) {
                        subTask.setUpdateTime(now);
                        this.learningSubtaskDao.update((Object)subTask, new String[0]);
                        continue;
                    }
                    subTask.setCreateTime(now);
                    subTask.setLearningTaskId(Long.valueOf(task.getId()));
                    subTask.setUpdateTime(now);
                    this.learningSubtaskDao.save((Object)subTask, new String[0]);
                }
                comment = contentBuffer.toString() + ", \u8bf7\u5173\u6ce8\u4efb\u52a1\u53d8\u5316\u54e6^_^!";
                first = "%s\u540c\u5b66,%s\u8001\u5e08\u4fee\u6539\u4e86" + BaseUtils.getFormatTime((Date)task.getStartTime(), (String)"yyyy-MM-dd") + "\u65e5\u7684\u5b66\u4e60\u4efb\u52a1\uff0c\u8bf7\u767b\u5f55\u3010\u5b66\u5458\u4e2d\u5fc3\u3011-\u3010\u5b66\u4e60\u4efb\u52a1\u3011\u67e5\u770b\u53d8\u52a8\u60c5\u51b5";
                BaseLoginUser user = LoginUtil.getCurrentUser();
                this.sendTemplateMsgToStudent(task.getStudentId(), user.getUserName(), comment, first, MessageBizType.EDIT_LEARNING_TASK);
            }
        }
    }

    @Override
    public int getLearningTaskCount(Long studentId) {
        return this.learningTaskDao.getLearningTaskCount(studentId);
    }
}

